/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.hl7command.norespcommand.adtrequest;

import gov.fhie.common.properties.PropertyElement;
import gov.va.med.hds.hdr.busobj.domain.CorrelatingDataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.hl7.Acknowledgment;
import gov.va.med.hds.hdr.busobj.hl7.JDOMDocumentAcknowledgmentBuilder;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.XMLPatientBuilder;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.Command;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.CommandExecutionException;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import org.dom4j.Document;

public class LinkPatientResponseCommand
implements Command {
    public LinkPatientResponseCommand(PropertyElement pe) {
    }

    public void execute(Document request) throws CommandExecutionException {
        try {
            Acknowledgment ack = JDOMDocumentAcknowledgmentBuilder.buildAcknowledgment(request);
            String origMessageControlId = ack.getOriginatingMessageControlId();
            String dataDomain = ServiceLocator.getInstance().getHL7Service().getDataDomainId(origMessageControlId);
            CorrelatingDataDomain dd = (CorrelatingDataDomain)DataDomainLocator.getInstance().locate(dataDomain);
            HL7AuditDAO hl7AuditDao = ServiceLocator.getInstance().getDAOFactory().createHL7AuditLogDAO();
            String patientXML = hl7AuditDao.getOriginalMessageData(dataDomain, origMessageControlId);
            Patient patient = XMLPatientBuilder.buildPaitient(patientXML);
            PatientIdentifier lid = patient.getFirstIdentifier(3);
            if ("AA".equals(ack.getAcknowledgmentCode()) || "CA".equals(ack.getAcknowledgmentCode())) {
                lid.setStatus("C");
                hl7AuditDao.setStatus(dataDomain, origMessageControlId, "C");
            } else {
                lid.setStatus("E");
                hl7AuditDao.setStatus(dataDomain, origMessageControlId, "E");
            }
            dd.updateIdentifierStatus(patient, lid);
        }
        catch (Exception e) {
            throw new CommandExecutionException("Error processing link patient acknowledgment message.", e);
        }
    }
}

