/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.hl7command.norespcommand.adtrequest;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.CorrelatingDataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.domain.NoNationalIdentifierException;
import gov.va.med.hds.hdr.busobj.hl7.Acknowledgment;
import gov.va.med.hds.hdr.busobj.hl7.JDOMDocumentAcknowledgmentBuilder;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.XmlPatient;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.Command;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.CommandExecutionException;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import org.dom4j.Document;

public class FindCandidatesResponseCommand
implements Command {
    private String domain = null;
    private static Synchronizer synchronizer = new Synchronizer();

    public FindCandidatesResponseCommand(PropertyElement properties) {
        PropertyElement[] domains = properties.getChildProperties("domain");
        if (domains != null && domains.length == 1) {
            this.domain = domains[0].getValue();
        }
    }

    public void execute(Document request) throws CommandExecutionException {
        long startExecute = System.currentTimeMillis();
        Patient patient = null;
        try {
            Acknowledgment ack = JDOMDocumentAcknowledgmentBuilder.buildAcknowledgment(request);
            String origMsgCtrlId = ack.getOriginatingMessageControlId();
            HL7Service hl7Service = ServiceLocator.getInstance().getHL7Service();
            this.domain = hl7Service.getDataDomainId(origMsgCtrlId);
            if (this.domain == null) {
                throw new CommandExecutionException("The data domian of the sender was non-determinable based on the orginating messasge control ID of the find candidates response messate. Please contact support to open ticket.");
            }
            HL7AuditDAO hl7AuditDao = ServiceLocator.getInstance().getDAOFactory().createHL7AuditLogDAO();
            if ("AA~OK".equals(ack.getAcknowledgmentCode()) || "CA~OK".equals(ack.getAcknowledgmentCode())) {
                hl7AuditDao.setStatus(this.domain, origMsgCtrlId, "C");
            } else {
                hl7AuditDao.setStatus(this.domain, origMsgCtrlId, "E");
            }
            patient = new XmlPatient(request);
            PatientIdentifier nid = patient.getFirstIdentifier(2);
            if (nid == null) {
                throw new NoNationalIdentifierException();
            }
            CorrelatingDataDomain dd = (CorrelatingDataDomain)DataDomainLocator.getInstance().locate(this.domain);
            dd.storePatient(patient);
            PatientIdentifier lid = patient.getFirstIdentifier(3);
            if (lid != null) {
                if ("AA~OK".equals(ack.getAcknowledgmentCode()) || "CA~OK".equals(ack.getAcknowledgmentCode())) {
                    lid.setStatus("C");
                } else {
                    lid.setStatus("E");
                }
            }
            dd.updateIdentifierStatus(patient, lid);
        }
        catch (NoNationalIdentifierException nnie) {
            StringBuffer sbMessage = new StringBuffer("The patient is not known by the MPI.\n");
            if (patient != null) {
                PatientIdentifier pid = patient.getFirstIdentifier(3);
                if (null != pid) {
                    sbMessage.append("Patient DFN: ").append(pid.getId()).append("\n").append("Patient Domain: ").append(pid.getDomain());
                } else {
                    String ssn = patient.getSsn();
                    if (null != ssn) {
                        sbMessage.append("Patient SSN: *****").append(ssn.substring(ssn.length() - 4));
                    } else {
                        sbMessage.append("No identifiers!");
                    }
                }
            }
            IMSException.getIMSException(sbMessage.toString(), nnie, (CharSequence)request.asXML());
        }
        catch (CommandExecutionException cee) {
            throw cee;
        }
        catch (Exception e) {
            throw new CommandExecutionException("An error was encountered while processing the find candidates response message from the MPI.", e);
        }
    }
}

