/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.hl7command.norespcommand.adtrequest;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.Command;
import gov.va.med.hds.hdr.service.adtprocess.AdtProcessException;
import org.dom4j.Document;
import org.dom4j.Node;

public abstract class AbstractADTProcessCommand
implements Command {
    private static final String A_PARAM_WHAT = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='what' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";
    private static final String A_MESSAGECONTROLID = "//graph/instance[@role='adt' and @type='AdmitDischargeTransfer']/attribute[@name='messageControlId' and @type='PlainText']/field[@name='value']";
    private static final String XP_WHATCODE_DOMAIN = "transformer/rpcbroker/what-code[@code='WHAT_CODE']/@domain";
    private static final String XP_WHATCODE_TEMPLATE = "transformer/rpcbroker/what-code[@code='WHAT_CODE']/@template";
    protected static final int DOMAIN_INDEX = 0;
    protected static final int SC_INDEX = 2;
    protected static final int DEST_INDEX = 3;

    public AbstractADTProcessCommand(PropertyElement entryPoint) {
    }

    private String getDocumentValue(Document document, String path) throws AdtProcessException {
        Node node = document.selectSingleNode(path);
        if (node != null) {
            return node.getText();
        }
        throw new AdtProcessException("Error getting document value.");
    }

    protected String getWhatCode(Document d) throws AdtProcessException {
        return this.getDocumentValue(d, A_PARAM_WHAT);
    }

    protected String getMessageControlId(Document d) throws AdtProcessException {
        return this.getDocumentValue(d, A_MESSAGECONTROLID);
    }

    protected String getDomain(Document d) throws AdtProcessException {
        String whatcode = this.getWhatCode(d);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xpath = XP_WHATCODE_DOMAIN.replaceFirst("WHAT_CODE", whatcode);
        return pm.getProperty(xpath).getValue();
    }

    protected String getTemplate(Document d) throws AdtProcessException {
        String whatcode = this.getWhatCode(d);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xpath = XP_WHATCODE_TEMPLATE.replaceFirst("WHAT_CODE", whatcode);
        return pm.getProperty(xpath).getValue();
    }
}

