/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.hl7command.norespcommand.adtrequest;

import gov.fhie.common.properties.PropertyElement;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.CommandExecutionException;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.adtrequest.AbstractADTProcessCommand;
import gov.va.med.hds.hdr.service.adtprocess.AdtProcessImpl;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentA43MessageMetaData;
import java.util.Hashtable;
import java.util.Map;
import org.dom4j.Document;

public class ADTA43ProcessCommand
extends AbstractADTProcessCommand {
    private static Map<String, SyncObject> inProcess = new Hashtable<String, SyncObject>();
    private static Object syncObject = new SyncObject();

    public ADTA43ProcessCommand(PropertyElement entryPoint) {
        super(entryPoint);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void execute(Document request) throws CommandExecutionException {
        boolean retVal = false;
        SyncObject syncObj = null;
        String mrgICN = null;
        try {
            XMLDocumentA43MessageMetaData metaData = new XMLDocumentA43MessageMetaData(request);
            mrgICN = metaData.getMrgICN();
            SyncObject syncObject = syncObj = ADTA43ProcessCommand.getSyncObject(mrgICN);
            synchronized (syncObject) {
                AdtProcessImpl adtp = new AdtProcessImpl(metaData.getFromMrgPidDomain());
                retVal = adtp.doUnlinkOperation(metaData);
            }
            if (mrgICN == null || syncObj == null) return;
        }
        catch (Exception e) {
            try {
                throw new CommandExecutionException("ADT A43 error:  " + e.getCause().getMessage());
            }
            catch (Throwable throwable) {
                if (mrgICN == null || syncObj == null) throw throwable;
                ADTA43ProcessCommand.returnSyncObject(mrgICN, syncObj);
                throw throwable;
            }
        }
        ADTA43ProcessCommand.returnSyncObject(mrgICN, syncObj);
        return;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SyncObject getSyncObject(String key) {
        Object object = syncObject;
        synchronized (object) {
            SyncObject obj = inProcess.get(key);
            if (obj == null) {
                obj = new SyncObject();
                inProcess.put(key, obj);
            }
            obj.addRef();
            return obj;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void returnSyncObject(String key, SyncObject obj) {
        Object object = syncObject;
        synchronized (object) {
            obj.release();
            if (!obj.isReferenced()) {
                inProcess.remove(key);
            }
        }
    }

    protected static class SyncObject {
        protected int refCount = 0;

        protected SyncObject() {
        }

        public int addRef() {
            return ++this.refCount;
        }

        public int release() {
            return --this.refCount;
        }

        public boolean isReferenced() {
            return this.refCount > 0;
        }
    }
}

