/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.hibernate;

import gov.va.med.hds.hdr.service.session.ImsSessionLifecycle;
import javax.transaction.Synchronization;
import org.hibernate.HibernateException;
import org.hibernate.Transaction;

public class LifecycleAwareHibernateTransaction
implements Transaction,
ImsSessionLifecycle {
    private Transaction wrapped;

    public LifecycleAwareHibernateTransaction(Transaction transaction) {
        this.wrapped = transaction;
    }

    public void commit() throws HibernateException {
        this.wrapped.commit();
    }

    public boolean isActive() throws HibernateException {
        return this.wrapped.isActive();
    }

    public void registerSynchronization(Synchronization synchronization) throws HibernateException {
        this.wrapped.registerSynchronization(synchronization);
    }

    public void rollback() throws HibernateException {
        this.wrapped.rollback();
    }

    public boolean wasCommitted() throws HibernateException {
        return this.wrapped.wasCommitted();
    }

    public boolean wasRolledBack() throws HibernateException {
        return this.wrapped.wasRolledBack();
    }

    public void begin() throws HibernateException {
        this.wrapped.begin();
    }

    public void setTimeout(int i) {
        this.wrapped.setTimeout(i);
    }

    public void exception() {
        if (this.wrapped != null) {
            this.rollback();
        }
    }

    public void preDestroy() {
        if (this.wrapped != null && !this.wasRolledBack() && !this.wasCommitted()) {
            try {
                this.commit();
            }
            catch (HibernateException he) {
                this.exception();
                throw he;
            }
        }
    }

    public void destroy() {
        this.wrapped = null;
    }
}

