/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.datasource;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.datasource.DataSourceFactory;
import gov.va.med.hds.hdr.common.datasource.DataSourceInitializationException;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import java.util.Properties;
import javax.sql.DataSource;

public class SpringAwareDataSourceManager
extends DataSourceManager {
    private DataSourceFactory dataSourceFactory;

    public SpringAwareDataSourceManager(DataSourceFactory dataSourceFactory) throws DataSourceInitializationException {
        this.dataSourceFactory = dataSourceFactory;
        PropertyMgr pmgr = PropertyMgr.getInstance();
        PropertyElement[] dataSources = pmgr.getProperties("*/datasources/*");
        for (int i = 0; i < dataSources.length; ++i) {
            String id = dataSources[i].getAttribute("id");
            Properties props = dataSourceFactory.buildProperties(dataSources[i].getChildProperties("property"));
            props.setProperty("id", id);
            DataSource ds = dataSourceFactory.createDataSource(props);
            this.dataSourceMap.put(id.toLowerCase(), ds);
            PropertyElement[] aliases = dataSources[i].getChildProperties("alias");
            for (int j = 0; j < aliases.length; ++j) {
                SpringAwareDataSourceManager.instance.dataSourceMap.put(aliases[j].getAttribute("id").toLowerCase(), ds);
            }
        }
    }

    public void setDataSourceFactory(DataSourceFactory dataSourceFactory) {
        this.dataSourceFactory = dataSourceFactory;
    }
}

