/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.datasource;

import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.HibernateException;
import org.hibernate.connection.ConnectionProvider;

public class FrameworkDataSourceConnectionProvider
implements ConnectionProvider {
    private static final String DATASOURCE_ID = "framework.datasource.id";
    private DataSource ds;

    public void configure(Properties props) throws HibernateException {
        try {
            String dataSourceId = props.getProperty(DATASOURCE_ID);
            this.ds = DataSourceManager.getInstance().getDataSource(dataSourceId);
        }
        catch (Exception e) {
            throw new HibernateException("Error getting datasource from DataSourceManager.", (Throwable)e);
        }
    }

    public Connection getConnection() throws SQLException {
        Connection c = this.ds.getConnection();
        if (c.getAutoCommit()) {
            c.setAutoCommit(false);
        }
        return c;
    }

    public void closeConnection(Connection conn) throws SQLException {
        conn.close();
    }

    public void close() throws HibernateException {
    }

    public boolean supportsAggressiveRelease() {
        return false;
    }
}

