/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.datasource;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.datasource.DataSourceFactory;
import gov.va.med.hds.hdr.common.datasource.DataSourceInitializationException;
import gov.va.med.hds.hdr.common.datasource.NoSuchDataSourceException;
import gov.va.med.hds.hdr.common.datasource.NoSuchHibernateSessionFactoryException;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.sql.DataSource;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.Configuration;

public class DataSourceManager {
    public static final String DOMAIN = "domain";
    public static final String XP_DATASOURCES = "*/datasources/*";
    public static final String ATTR_FACTORY = "factory";
    public static final String ATTR_ID = "id";
    public static final String ATTR_NAME = "name";
    public static final String ATTR_VALUE = "value";
    protected static DataSourceManager instance = null;
    protected Map<String, DataSource> dataSourceMap = new HashMap<String, DataSource>();
    protected Map<String, SessionFactory> hibernateSessionFactoriesMap = new HashMap<String, SessionFactory>();

    protected DataSourceManager() {
    }

    public static final DataSourceManager getInstance() throws DataSourceInitializationException {
        DataSourceManager.initialize();
        return instance;
    }

    public static final synchronized void setDataSourceManager(DataSourceManager dataSourceManager) {
        instance = dataSourceManager;
    }

    public static void initialize() throws DataSourceInitializationException {
        if (instance == null) {
            instance = new DataSourceManager();
            PropertyMgr pmgr = PropertyMgr.getInstance();
            PropertyElement[] dataSources = pmgr.getProperties(XP_DATASOURCES);
            for (int i = 0; i < dataSources.length; ++i) {
                String id = dataSources[i].getAttribute(ATTR_ID);
                String clazz = dataSources[i].getAttribute(ATTR_FACTORY);
                DataSourceFactory factory = DataSourceFactory.getInstance(id, clazz);
                Properties props = factory.buildProperties(dataSources[i].getChildProperties("property"));
                props.setProperty(ATTR_ID, id);
                DataSource ds = factory.createDataSource(props);
                DataSourceManager.instance.dataSourceMap.put(id.toLowerCase(), ds);
                PropertyElement[] aliases = dataSources[i].getChildProperties("alias");
                for (int j = 0; j < aliases.length; ++j) {
                    DataSourceManager.instance.dataSourceMap.put(aliases[j].getAttribute(ATTR_ID).toLowerCase(), ds);
                }
                PropertyElement[] hsElements = dataSources[i].getChildProperties("hibernate-session");
                if (hsElements.length <= 0) continue;
                try {
                    instance.configureHibernateSession(id, hsElements[0]);
                    continue;
                }
                catch (Exception e) {
                    throw new DataSourceInitializationException(id, e);
                }
            }
        }
    }

    protected void configureHibernateSession(String id, PropertyElement hibernateElement) throws Exception {
        Configuration configuration = new Configuration();
        PropertyElement[] directories = hibernateElement.getChildProperties("directory");
        for (int i = 0; i < directories.length; ++i) {
            configuration.addDirectory(new File(directories[i].getAttribute("path")));
        }
        PropertyElement[] classes = hibernateElement.getChildProperties("persistent-class");
        for (int i = 0; i < classes.length; ++i) {
            configuration.addClass(Class.forName(classes[i].getValue()));
        }
        Properties properties = new Properties();
        PropertyElement[] props = hibernateElement.getChildProperties("property");
        for (int i = 0; i < props.length; ++i) {
            properties.setProperty(props[i].getAttribute(ATTR_NAME), props[i].getAttribute(ATTR_VALUE));
        }
        configuration.setProperties(System.getProperties());
        configuration.addProperties(properties);
        PropertyElement[] eventListeners = hibernateElement.getChildProperties("event");
        for (int i = 0; i < eventListeners.length; ++i) {
            String type = eventListeners[i].getAttribute("type");
            PropertyElement[] listeners = eventListeners[i].getChildProperties();
            String[] listenerClassNames = new String[listeners.length];
            for (int j = 0; j < listeners.length; ++j) {
                configuration.setListener(type, Class.forName(listeners[j].getAttribute("class")).newInstance());
            }
        }
        DataSourceManager.instance.hibernateSessionFactoriesMap.put(id, configuration.buildSessionFactory());
    }

    public DataSource getDataSource(String id) throws NoSuchDataSourceException {
        DataSource dataSource = this.dataSourceMap.get(id.toLowerCase());
        if (dataSource == null) {
            throw new NoSuchDataSourceException(id);
        }
        return dataSource;
    }

    public SessionFactory getHibernateSessionFactory(String id) throws NoSuchHibernateSessionFactoryException {
        SessionFactory sessionFactory = this.hibernateSessionFactoriesMap.get(id);
        if (sessionFactory == null) {
            throw new NoSuchHibernateSessionFactoryException(id);
        }
        return sessionFactory;
    }

    public String getPersistenceLocationOfClass(Class c) {
        return c.getName().substring(c.getName().lastIndexOf(".") + 1);
    }

    public String[] listDataSources() {
        ArrayList<String> names = new ArrayList<String>();
        Iterator<String> iter = this.dataSourceMap.keySet().iterator();
        while (iter.hasNext()) {
            names.add(iter.next());
        }
        return names.toArray(new String[names.size()]);
    }
}

