/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.datasource;

import gov.fhie.common.properties.PropertyElement;
import gov.va.med.hds.hdr.common.datasource.DataSourceInitializationException;
import java.util.Properties;
import javax.sql.DataSource;

public abstract class DataSourceFactory {
    public static DataSourceFactory getInstance(String id, String factory) throws DataSourceInitializationException {
        try {
            return (DataSourceFactory)Class.forName(factory).newInstance();
        }
        catch (Exception e) {
            throw new DataSourceInitializationException(id, e);
        }
    }

    public Properties buildProperties(PropertyElement[] props) {
        Properties properties = new Properties();
        for (int i = 0; i < props.length; ++i) {
            String name = props[i].getAttribute("name");
            String value = props[i].getAttribute("value");
            properties.setProperty(name, value);
        }
        return properties;
    }

    public abstract DataSource createDataSource(Properties var1) throws DataSourceInitializationException;
}

