/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.adapter.xslt;

import gov.va.med.hds.hdr.common.adapter.AdaptationException;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterCreationException;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.adapter.IncompatibleInputException;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;
import java.util.Map;
import javax.xml.transform.Source;
import javax.xml.transform.Templates;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamResult;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.io.DocumentSource;
import org.springframework.core.io.ClassPathResource;
import org.xml.sax.InputSource;

public class XSLTAdapterFactory
implements AdapterFactory {
    private static final Map<String, Templates> TEMPLATE_MAP = new Hashtable<String, Templates>();
    protected String stylesheet = null;

    public XSLTAdapterFactory(String stylesheet) {
        this.stylesheet = stylesheet;
    }

    public Adapter createAdapter() throws AdapterCreationException {
        try {
            return new XSLTAdapter(this.stylesheet);
        }
        catch (IOException e) {
            throw new AdapterCreationException("Stylesheet file path is invalid. Could not create adapter object.", e);
        }
        catch (TransformerConfigurationException e) {
            throw new AdapterCreationException(e);
        }
    }

    protected class XSLTAdapter
    implements Adapter {
        protected Document input = null;
        protected String result = null;
        protected Templates templates = null;

        public XSLTAdapter(String stylesheet) throws IOException, TransformerConfigurationException {
            this.templates = (Templates)TEMPLATE_MAP.get(stylesheet);
            if (this.templates == null) {
                TransformerFactory factory = TransformerFactory.newInstance();
                SAXSource s = new SAXSource(new InputSource(new BufferedReader(new InputStreamReader(new ClassPathResource(stylesheet).getInputStream()))));
                this.templates = factory.newTemplates(s);
                TEMPLATE_MAP.put(stylesheet, this.templates);
            }
        }

        public void adapt() throws AdaptationException {
            long start = System.currentTimeMillis();
            try {
                if (this.templates == null) {
                    throw new Exception("The templates object is null.");
                }
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Transformer t = this.templates.newTransformer();
                String encoding = this.input.getXMLEncoding();
                t.setOutputProperty("encoding", null == encoding ? "iso-8859-1" : encoding);
                DocumentSource source = new DocumentSource(this.input);
                StreamResult result = new StreamResult(new BufferedOutputStream(bos));
                long startTransform = System.currentTimeMillis();
                t.transform((Source)source, result);
                this.result = bos.toString();
            }
            catch (Exception e) {
                throw new AdaptationException("An error occurred while adapting the data.", e);
            }
        }

        public Object getResult() throws Exception {
            return this.result;
        }

        public void setInput(Object obj) throws IncompatibleInputException, IOException {
            block4: {
                try {
                    if (obj != null && obj instanceof Document) {
                        this.input = (Document)obj;
                        break block4;
                    }
                    if (obj != null && obj instanceof String) {
                        this.input = DocumentHelper.parseText((String)((String)obj));
                        break block4;
                    }
                    throw new IncompatibleInputException("Input object cannot be null.");
                }
                catch (Exception e) {
                    throw new IncompatibleInputException("XSLTAdapter could not convert string input to XML Document.", e);
                }
            }
        }
    }
}

