/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.adapter.xslt;

import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterCreationException;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerConfigurationException;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class HxXML2TemplateXMLAdapterFactory
extends XSLTAdapterFactory {
    public HxXML2TemplateXMLAdapterFactory(String stylesheet) {
        super(stylesheet);
    }

    public Adapter createAdapter() throws AdapterCreationException {
        try {
            return new HxXML2TemplateXMLAdapter(this.stylesheet);
        }
        catch (Exception e) {
            throw new AdapterCreationException(e);
        }
    }

    protected class HxXML2TemplateXMLAdapter
    extends XSLTAdapterFactory.XSLTAdapter {
        public HxXML2TemplateXMLAdapter(String stylesheet) throws IOException, TransformerConfigurationException {
            super(HxXML2TemplateXMLAdapterFactory.this, stylesheet);
        }

        public Object getResult() throws Exception {
            ArrayList<Document> observations = new ArrayList<Document>();
            Document document = DocumentHelper.parseText((String)this.result);
            String encoding = document.getXMLEncoding();
            if (null == encoding) {
                String xmlDeclaration;
                Pattern encodingPattern = Pattern.compile("<\\?xml.*encoding=\"(.*)\" \\?>.*", 2);
                Matcher encodingMatch = encodingPattern.matcher(xmlDeclaration = this.result.split(System.getProperty("line.separator"), 2)[0].trim());
                encoding = encodingMatch.matches() ? encodingMatch.group(1) : "iso-8859-1";
                document.setXMLEncoding(encoding);
            }
            List list = document.selectNodes("observations/graph");
            Iterator iter = list.iterator();
            Document observation = null;
            Element content = null;
            while (iter.hasNext()) {
                observation = DocumentHelper.createDocument();
                observation.setXMLEncoding(document.getXMLEncoding());
                content = (Element)((Element)iter.next()).detach();
                observation.setRootElement(content);
                observation.setXMLEncoding(encoding);
                observations.add(observation);
            }
            return observations;
        }
    }
}

