/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.common.adapter.hl7.er7;

import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.va.med.hds.hdr.common.adapter.AdaptationException;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterCreationException;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.adapter.IncompatibleInputException;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParser;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegmentFactory;
import java.util.Hashtable;
import java.util.Map;

public class HL72ObjectAdapterFactory
implements AdapterFactory {
    private static final Map RULES = new Hashtable();

    public Adapter createAdapter() throws AdapterCreationException {
        return new HL72ObjectAdapter();
    }

    protected class HL72ObjectAdapter
    implements Adapter {
        private String message;
        private HL7MessageParser parser;
        private Object result;
        private String currentSegmentName;
        private String rulesId;

        protected HL72ObjectAdapter() {
        }

        public void adapt() throws AdaptationException {
            if (this.message == null || this.message.length() == 0) {
                throw new AdaptationException("Error: Message must not be null or zero-length.");
            }
            try {
                this.parser = new HL7MessageParser(this.message);
            }
            catch (MessageParserException e) {
                throw new AdaptationException("Error adapting message.\nMessage:\n" + this.message);
            }
        }

        public Object getResult() throws Exception {
            return this.result;
        }

        public void setInput(Object obj) throws IncompatibleInputException {
            if (obj == null || !(obj instanceof String)) {
                throw new IncompatibleInputException("Input cannot be a null or zero-length string.");
            }
            this.message = (String)obj;
            HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(this.message);
            MshSegment mshSegment = MshSegmentFactory.createSegment(HL7SegmentParser.parseLine(this.message, (HL7MessageInfo)messageInfo), (HL7MessageInfo)messageInfo);
            this.rulesId = mshSegment.getMessageType();
        }
    }
}

