/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.vhim.lab;

import gov.fhie.common.util.BeanHelper;
import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.busobj.vhim.common.ActId;
import gov.va.med.hds.hdr.busobj.vhim.common.Mergeable;
import gov.va.med.hds.hdr.busobj.vhim.common.PatientVisit;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabOrder;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabReport;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabRequest;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabTestOrder;
import gov.va.med.hds.hdr.busobj.vhim.lab.SpecimenCollection;
import gov.va.med.hds.hdr.busobj.vhim.lab.SpecimenCollectionOrder;
import gov.va.med.hds.hdr.common.hibernate.Persistable;
import gov.va.med.hds.hdr.xml.XmlSerializer;
import java.io.Serializable;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabTest
implements Serializable,
Mergeable,
Persistable,
XmlSerializer {
    private Long id;
    private PatientVisit patientVisit;
    private ActId accessionId;
    private Set<LabTestOrder> labTestOrders = new LinkedHashSet<LabTestOrder>();
    private Set<LabReport> labReports = new LinkedHashSet<LabReport>();
    private Set<LabRequest> labRequests = new LinkedHashSet<LabRequest>();
    private Date lastUpdateDate;

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        if (lastUpdateDate != null) {
            this.lastUpdateDate = new Date(DateTimeUtility.getMilliSecond(lastUpdateDate));
        }
    }

    @Override
    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public PatientVisit getPatientVisit() {
        return this.patientVisit;
    }

    public void setPatientVisit(PatientVisit patientVisit) {
        this.patientVisit = patientVisit;
        this.patientVisit.setLabTest(this);
    }

    public Set getLabRequests() {
        return this.labRequests;
    }

    private void setLabRequests(Set<LabRequest> labRequests) {
        this.labRequests = labRequests;
    }

    public void addLabRequest(LabRequest labRequest) {
        if (!this.labRequests.contains(labRequest)) {
            labRequest.setLabTest(this);
            this.labRequests.add(labRequest);
        }
    }

    public ActId getAccessionId() {
        return this.accessionId;
    }

    public void setAccessionId(ActId accessionId) {
        this.accessionId = accessionId;
    }

    public Set getLabReports() {
        return this.labReports;
    }

    private void setLabReports(Set<LabReport> labReports) {
        this.labReports = labReports;
    }

    public void addLabReport(LabReport labReport) {
        if (!this.labReports.contains(labReport)) {
            labReport.setLabTest(this);
            this.labReports.add(labReport);
        }
    }

    public Set getLabTestOrders() {
        return this.labTestOrders;
    }

    private void setLabTestOrders(Set<LabTestOrder> labTestOrders) {
        this.labTestOrders = labTestOrders;
    }

    public void addLabTestOrder(LabTestOrder labTestOrder) {
        if (!this.labTestOrders.contains(labTestOrder)) {
            labTestOrder.setLabTest(this);
            this.labTestOrders.add(labTestOrder);
        }
    }

    @Override
    public void merge(Object obj) throws IllegalArgumentException {
        if (!(obj instanceof LabTest)) {
            throw new IllegalArgumentException("Cannot merge object of type " + obj.getClass().getName() + " with object of type " + LabTest.class.getName());
        }
        Object sc = null;
        LabTest lt = (LabTest)obj;
        Set labRequests = lt.getLabRequests();
        for (Object o : labRequests) {
            LabRequest lr = (LabRequest)o;
            this.getSpecimenCollection().addLabRequest(lr);
            this.addLabRequest(lr);
        }
    }

    public String toString() {
        return BeanHelper.objectToString(this);
    }

    public boolean equals(Object arg0) {
        LabTest that;
        ActId accessionId;
        boolean matches;
        boolean bl = matches = this == arg0;
        if (!matches && (matches = arg0 instanceof LabTest) && (matches = (accessionId = (that = (LabTest)arg0).getAccessionId()) == this.accessionId || BeanHelper.isNull(accessionId) && BeanHelper.isNull(this.accessionId) || null != accessionId && accessionId.equals(this.accessionId))) {
            LabRequest[] thatLabRequests = that.getLabRequests().toArray(new LabRequest[0]);
            LabRequest[] thisLabRequests = this.getLabRequests().toArray(new LabRequest[0]);
            matches = thatLabRequests.length != 0 && thisLabRequests.length != 0 && thatLabRequests[0].getSpecimenCollection() != null && thisLabRequests[0].getSpecimenCollection() != null && thatLabRequests[0].getSpecimenCollection().getCollectionDate() != null && thisLabRequests[0].getSpecimenCollection().getCollectionDate() != null && thatLabRequests[0].getSpecimenCollection().getCollectionDate().equals(thisLabRequests[0].getSpecimenCollection().getCollectionDate());
        }
        return matches;
    }

    public int hashCode() {
        return BeanHelper.objectHashCode(this.getClass(), new Object[]{this.accessionId});
    }

    @Override
    public Element toXml() {
        Element labTest = DocumentFactory.getInstance().createElement("labTest").addAttribute("id", this.id != null ? this.id.toString() : "").addAttribute("lastUpdateDate", this.lastUpdateDate != null ? DateTimeUtility.getISOTime(this.lastUpdateDate.getTime()) : "");
        if (this.patientVisit != null) {
            labTest.add(((XmlSerializer)((Object)this.patientVisit)).toXml());
        }
        Element accId = this.accessionId.toXml();
        accId.setName("accessionId");
        labTest.add(accId);
        Element l = labTest.addElement("labTestOrders");
        if (this.labTestOrders != null) {
            Iterator<LabTestOrder> iter = this.labTestOrders.iterator();
            while (iter.hasNext()) {
                l.add(((XmlSerializer)((Object)iter.next())).toXml());
            }
        }
        Element lr = labTest.addElement("labReports");
        if (this.labReports != null) {
            Iterator<LabReport> iter = this.labReports.iterator();
            while (iter.hasNext()) {
                lr.add(((XmlSerializer)((Object)iter.next())).toXml());
            }
        }
        Element lrqs = labTest.addElement("labRequests");
        if (this.labRequests != null) {
            Iterator<LabRequest> iter = this.labRequests.iterator();
            while (iter.hasNext()) {
                lrqs.add(((XmlSerializer)((Object)iter.next())).toXml());
            }
        }
        return labTest;
    }

    private SpecimenCollection getSpecimenCollection() {
        SpecimenCollectionOrder sco;
        LabOrder lo;
        LabTestOrder lto;
        Iterator<LabTestOrder> i;
        SpecimenCollection sc = null;
        if (this.labTestOrders != null && (i = this.labTestOrders.iterator()).hasNext() && (lto = i.next()).getLabOrders() != null && (i = lto.getLabOrders().iterator()).hasNext() && (lo = (LabOrder)((Object)i.next())).getSpecimenCollectionOrders() != null && (i = lo.getSpecimenCollectionOrders().iterator()).hasNext() && (sco = (SpecimenCollectionOrder)((Object)i.next())).getSpecimenCollections() != null && (i = sco.getSpecimenCollections().iterator()).hasNext()) {
            sc = (SpecimenCollection)((Object)i.next());
        }
        return sc;
    }
}

