/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.vhim.lab;

import gov.fhie.common.util.BeanHelper;
import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.busobj.vhim.common.CodedValue;
import gov.va.med.hds.hdr.busobj.vhim.common.Note;
import gov.va.med.hds.hdr.busobj.vhim.common.PractitionerParticipation;
import gov.va.med.hds.hdr.busobj.vhim.lab.TestResult;
import gov.va.med.hds.hdr.common.hibernate.Persistable;
import java.io.Serializable;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LabObservation
implements Serializable,
Persistable {
    private Long id;
    private String resultsIdentifier;
    private TestResult testResult;
    private Double observationStartDate;
    private CodedValue characteristicObserved;
    private String alternateCharacteristicObserved;
    private CodedValue analyte;
    private String referenceRange;
    private Double referenceRangeNumerator;
    private Double referenceRangeDenominator;
    private CodedValue interpretation;
    private CodedValue resultType;
    private String textResult;
    private CodedValue unitOfMeasure;
    private Set<Note> notes = new LinkedHashSet<Note>();
    private Set<PractitionerParticipation> practitionerParticipations = new LinkedHashSet<PractitionerParticipation>();
    private Date lastUpdateDate;

    @Override
    public Long getId() {
        return this.id;
    }

    private void setId(Long id) {
        this.id = id;
    }

    public CodedValue getCharacteristicObserved() {
        return this.characteristicObserved;
    }

    public void setCharacteristicObserved(CodedValue characteristicObserved) {
        this.characteristicObserved = characteristicObserved;
    }

    public String getAlternateCharacteristicObserved() {
        return this.alternateCharacteristicObserved;
    }

    public void setAlternateCharacteristicObserved(String alternateCharacteristicObserved) {
        this.alternateCharacteristicObserved = alternateCharacteristicObserved;
    }

    public CodedValue getAnalyte() {
        return this.analyte;
    }

    public void setAnalyte(CodedValue analyte) {
        this.analyte = analyte;
    }

    public CodedValue getInterpretation() {
        return this.interpretation;
    }

    public void setInterpretation(CodedValue interpretation) {
        this.interpretation = interpretation;
    }

    public Set getPractitionerParticipations() {
        return this.practitionerParticipations;
    }

    private void setPractitionerParticipations(Set<PractitionerParticipation> labObservationPractitionerParticipants) {
        this.practitionerParticipations = labObservationPractitionerParticipants;
    }

    public void addPractitionerParticipation(PractitionerParticipation practitionerParticipation) {
        practitionerParticipation.addLabObservation(this);
        this.practitionerParticipations.add(practitionerParticipation);
    }

    public Double getObservationStartDate() {
        return this.observationStartDate;
    }

    public void setObservationStartDate(Double observationStartDate) {
        this.observationStartDate = observationStartDate;
    }

    public void setObservationStartDate(String observationStartDate) {
        this.observationStartDate = observationStartDate == null || observationStartDate.length() == 0 ? null : DateTimeUtility.isoTime2Double(observationStartDate);
    }

    public Double getReferenceRangeDenominator() {
        return this.referenceRangeDenominator;
    }

    public void setReferenceRangeDenominator(Double referenceRangeDenominator) {
        this.referenceRangeDenominator = referenceRangeDenominator;
    }

    public void setReferenceRangeDenominator(String referenceRangeDenominator) {
        this.referenceRangeDenominator = referenceRangeDenominator == null || referenceRangeDenominator.length() == 0 ? null : new Double(referenceRangeDenominator);
    }

    public Double getReferenceRangeNumerator() {
        return this.referenceRangeNumerator;
    }

    public void setReferenceRangeNumerator(Double referenceRangeNumerator) {
        this.referenceRangeNumerator = referenceRangeNumerator;
    }

    public void setReferenceRangeNumerator(String referenceRangeNumerator) {
        this.referenceRangeNumerator = referenceRangeNumerator == null || referenceRangeNumerator.length() == 0 ? null : new Double(referenceRangeNumerator);
    }

    public String getTextResult() {
        return this.textResult;
    }

    public void setTextResult(String textResult) {
        this.textResult = textResult == null || textResult.length() == 0 ? null : textResult;
    }

    public String getReferenceRange() {
        return this.referenceRange;
    }

    public void setReferenceRange(String referenceRange) {
        String string = this.referenceRange = referenceRange == null || referenceRange.length() == 0 ? null : referenceRange;
        if (this.referenceRange != null) {
            String[] split = this.referenceRange.split("-");
            try {
                this.setReferenceRangeNumerator(split[0]);
                this.setReferenceRangeDenominator(split.length > 1 ? split[1] : "0");
            }
            catch (NumberFormatException e) {
                this.setReferenceRangeNumerator((Double)null);
                this.setReferenceRangeDenominator((Double)null);
            }
        }
    }

    public CodedValue getUnitOfMeasure() {
        return this.unitOfMeasure;
    }

    public void setUnitOfMeasure(CodedValue unitOfMeasure) {
        this.unitOfMeasure = unitOfMeasure;
    }

    public CodedValue getResultType() {
        return this.resultType;
    }

    public void setResultType(CodedValue resultType) {
        this.resultType = resultType;
    }

    public Set getNotes() {
        return this.notes;
    }

    private void setNotes(Set<Note> notes) {
        this.notes = notes;
    }

    public void addNote(Note note) {
        note.setLabObservation(this);
        this.notes.add(note);
    }

    public TestResult getTestResult() {
        return this.testResult;
    }

    public void setTestResult(TestResult testResult) {
        this.testResult = testResult;
    }

    public String toString() {
        return BeanHelper.objectToString(this);
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    private void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public String getResultsIdentifier() {
        return this.resultsIdentifier;
    }

    public void setResultsIdentifier(String resultsIdentifier) {
        this.resultsIdentifier = resultsIdentifier == null || resultsIdentifier.length() == 0 ? null : resultsIdentifier;
    }
}

