/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.vhim.common;

import gov.fhie.common.util.BeanHelper;
import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.busobj.vhim.common.Mergeable;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Template<T>
implements MessageMetaData,
Serializable {
    protected String templateName;
    protected String facilityId;
    protected String messageControlId;
    protected String messageType;
    protected String sendingApplication;
    protected String version;
    protected String errorSection;
    protected String clinicallyRelevantDate;
    protected List<T> observations = new ArrayList<T>();
    protected Date lastUpdateDate;
    protected String messageDateTime;

    public Template(String templateName) {
        this.setTemplateName(templateName);
    }

    @Override
    public abstract String getClinicalId();

    public abstract void store() throws Exception;

    public List<T> getObservations() {
        return this.observations;
    }

    public void setObservations(List<T> data) {
        for (T t : data) {
            this.observations.add(t);
        }
    }

    public void add(T data) {
        int idx = this.observations.indexOf(data);
        if (idx != -1) {
            T t = this.observations.get(idx);
            if (t instanceof Mergeable) {
                Mergeable m = (Mergeable)t;
                m.merge(data);
            }
        } else {
            this.observations.add(data);
        }
    }

    public void addObservation(T data) {
        this.add(data);
    }

    public String getErrorSection() {
        return this.errorSection;
    }

    public void setErrorSection(String errorSection) {
        this.errorSection = errorSection;
    }

    public String getTemplateName() {
        return this.templateName;
    }

    public void setTemplateName(String templateName) {
        this.templateName = templateName == null || templateName.length() == 0 ? null : templateName;
    }

    public String toString() {
        return BeanHelper.objectToString(this);
    }

    public boolean equals(Object arg0) {
        boolean equals;
        boolean bl = equals = this == arg0;
        if (!equals && (equals = arg0 instanceof Template)) {
            String thisClinicalId = this.getClinicalId();
            Template that = (Template)arg0;
            String templateName = that.getTemplateName();
            String clinicalId = that.getClinicalId();
            equals = templateName == this.templateName || BeanHelper.isNull(templateName) && BeanHelper.isNull(this.templateName) || null != templateName && templateName.equals(this.templateName);
            if (equals) {
                equals = clinicalId == thisClinicalId || BeanHelper.isNull(clinicalId) && BeanHelper.isNull(thisClinicalId) || null != clinicalId && clinicalId.equals(thisClinicalId);
            }
        }
        return equals;
    }

    public int hashCode() {
        return BeanHelper.objectHashCode(this.getClass(), new Object[]{this.templateName, this.getClinicalId()});
    }

    public Date getLastUpdateDate() {
        return this.lastUpdateDate;
    }

    public void setLastUpdateDate(Date lastUpdateDate) {
        this.lastUpdateDate = lastUpdateDate;
    }

    public void setLastUpdateDate(String lastUpdateDate) {
        if (lastUpdateDate != null) {
            this.messageDateTime = DateTimeUtility.normalizeDateString(lastUpdateDate, this.getFacilityId());
            this.setLastUpdateDate(new Date(DateTimeUtility.getMilliSecond(this.messageDateTime)));
        }
    }

    public void setFacilityId(String facilityId) {
        this.facilityId = facilityId;
    }

    @Override
    public String getFacilityId() {
        return this.facilityId;
    }

    public void setMessageControlId(String messageControlId) {
        this.messageControlId = messageControlId;
    }

    @Override
    public String getMessageControlId() {
        return this.messageControlId;
    }

    @Override
    public String getMessageDateTime() {
        if (null == this.messageDateTime) {
            this.messageDateTime = DateTimeUtility.getISOTime(this.lastUpdateDate.getTime(), DateTimeUtility.getTimezoneFor(this.getFacilityId(), null));
        }
        return this.messageDateTime;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = sendingApplication;
    }

    @Override
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public void setClinicallyRelevantDate(String clinicallyRelevantDate) {
        this.clinicallyRelevantDate = clinicallyRelevantDate;
    }

    @Override
    public String getClinicallyRelevantDate() {
        return this.clinicallyRelevantDate;
    }
}

