/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.patient;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.patient.InvalidPatientDataException;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderHelper;
import gov.va.med.hds.hdr.transformer.template.TemplateBuildingException;
import gov.va.med.hds.hdr.transformer.template.XMLTemplateBuilderDelegate;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Node;

public class XmlPatient
implements Patient {
    private static final String ID = "ID";
    private static final String DOMAIN = "DOMAIN";
    private static final String TYPECODE = "TYPECODE";
    private static final String XP_FINDIDENTIFIER = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']/instance[@type='PatientIdentifier' and @role='patientIdentifier' and attribute[@type='PlainText' and @name='id']/field='ID' and attribute[@type='QualifiedName' and @name='assigningFacility']/field[@name='authority_id.naming_entity']='DOMAIN']";
    private static final String XP_IDENTIFIERS = "//graph/instance[@role='patient']/instance[@role='identifiers']/instance[@role='patientIdentifier']";
    private static final String XP_IDENTIFIERBYTYPE = "//graph/instance[@role='patient']/instance[@role='identifiers']/instance[@role='patientIdentifier' and attribute[@name='identifierTypeCode']/field='TYPECODE']";
    private static final String XP_DOB = "//graph/instance[@type='Patient' and @role='patient']/attribute[@name='dateOfBirth']/field";
    private static final String XP_SEX = "//graph/instance[@type='Patient' and @role='patient']/attribute[@name='sex']/field";
    private static final String XP_LASTNAME = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='PatientName']/attribute[@name='lastName']/field";
    private static final String XP_FIRSTNAME = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='PatientName']/attribute[@name='firstName']/field";
    private static final String XP_MIDDLENAME = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='PatientName']/attribute[@name='middleName']/field";
    private static final String XP_SUFFIX = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='PatientName']/attribute[@name='suffix']/field";
    private static final String XP_FINDIDENTIFIERS = "//graph/instance[@type='Patient' and @role='patient']/instance[@type='List' and @role='identifiers']";
    private static final String RXP_PIID = "attribute[@name='id']/field";
    private static final String RXP_PIDOMAIN = "attribute[@name='assigningFacility']/field[@name='authority_id.naming_entity']";
    private Document patient = null;
    private TemplateBuilderHelper templateBuilderHelper = new TemplateBuilderHelper(new XMLTemplateBuilderDelegate());

    public XmlPatient() throws InvalidPatientDataException {
        this(DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"graph")));
    }

    public XmlPatient(Document document) throws InvalidPatientDataException {
        if (document == null) {
            throw new InvalidPatientDataException();
        }
        this.patient = document;
    }

    public void removeIdentifier(PatientIdentifier pid, int idType) {
        try {
            String xpFindIdentifier = XP_FINDIDENTIFIER.replaceFirst(ID, pid.getId());
            xpFindIdentifier = xpFindIdentifier.replaceFirst(DOMAIN, pid.getDomain());
            Element identifier = (Element)this.patient.selectSingleNode(xpFindIdentifier);
            if (identifier != null) {
                Element identifierList = (Element)this.patient.selectSingleNode(XP_FINDIDENTIFIERS);
                identifierList.remove(identifier);
            }
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.addIdentifier", ErrorCode.ADT_007, new String[]{pid.getDomain(), pid.getId()});
        }
    }

    public void addIdentifier(PatientIdentifier pid, int idType) {
        try {
            String xpFindIdentifier = XP_FINDIDENTIFIER.replaceFirst(ID, pid.getId());
            xpFindIdentifier = xpFindIdentifier.replaceFirst(DOMAIN, pid.getDomain());
            Element identifier = (Element)this.patient.selectSingleNode(xpFindIdentifier);
            if (identifier == null) {
                Element idAttribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).identifiers(List).patientIdentifier(PatientIdentifier).id", "PlainText", true, true);
                this.templateBuilderHelper.setFieldText(idAttribute, "value", pid.getId(), false, '\u0000');
                Element typeCodeAttribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).identifiers(List).patientIdentifier(PatientIdentifier).identifierTypeCode", "PlainText", false, true);
                this.templateBuilderHelper.setFieldText(typeCodeAttribute, "value", this.getIdentifierTypeCode(idType), false, '\u0000');
                Element assigningFacilityAttribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).identifiers(List).patientIdentifier(PatientIdentifier).assigningFacility", "QualifiedName", false, true);
                this.templateBuilderHelper.setFieldText(assigningFacilityAttribute, "authority_id.naming_entity", pid.getDomain(), false, '\u0000');
            }
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.addIdentifier", ErrorCode.ADT_007, new String[]{pid.getDomain(), pid.getId()});
        }
    }

    private String getPatientValue(String xpath) {
        String s = null;
        Node e = this.patient.selectSingleNode(xpath);
        if (e != null) {
            s = e.getText();
        }
        return s;
    }

    public String getDob() {
        return this.getPatientValue(XP_DOB);
    }

    public String getSex() {
        return this.getPatientValue(XP_SEX);
    }

    public String getFirstName() {
        return this.getPatientValue(XP_FIRSTNAME);
    }

    public String getLastName() {
        return this.getPatientValue(XP_LASTNAME);
    }

    public PatientIdentifier[] getIdentifiers(int idType) {
        String xpath = null;
        xpath = idType == 0 ? XP_IDENTIFIERS : XP_IDENTIFIERBYTYPE.replaceFirst(TYPECODE, this.getIdentifierTypeCode(idType));
        List l = this.patient.selectNodes(xpath);
        Iterator iter = l.iterator();
        Vector<PatientIdentifier> v = new Vector<PatientIdentifier>();
        Element pid = null;
        Element id = null;
        Element domain = null;
        while (iter.hasNext()) {
            pid = (Element)iter.next();
            id = (Element)pid.selectSingleNode(RXP_PIID);
            domain = (Element)pid.selectSingleNode(RXP_PIDOMAIN);
            if (id == null || domain == null) continue;
            v.add(new PatientIdentifier(domain.getText(), id.getText()));
        }
        return v.toArray(new PatientIdentifier[v.size()]);
    }

    public PatientIdentifier getFirstIdentifier(int idType) {
        PatientIdentifier first = null;
        PatientIdentifier[] pids = this.getIdentifiers(idType);
        if (pids != null && pids.length > 0) {
            first = pids[0];
        }
        return first;
    }

    public String getMiddleName() {
        return this.getPatientValue(XP_MIDDLENAME);
    }

    public String getSsn() {
        String ssn = null;
        PatientIdentifier[] pids = this.getIdentifiers(4);
        if (pids != null && pids.length > 0) {
            ssn = pids[0].getId();
        }
        return ssn;
    }

    public String getSuffix() {
        return this.getPatientValue(XP_SUFFIX);
    }

    public void setDob(String dob) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).dateOfBirth", "DateTime", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", dob, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setDob", ErrorCode.ADT_011, null);
        }
    }

    public void setSex(String sex) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).sex", "PlainText", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", sex, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setDob", ErrorCode.ADT_011, null);
        }
    }

    public void setFirstName(String firstName) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).patientName(PatientName).firstName", "PlainText", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", firstName, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setFirstName", ErrorCode.ADT_011, null);
        }
    }

    public void setLastName(String lastName) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).patientName(PatientName).lastName", "PlainText", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", lastName, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setLastName", ErrorCode.ADT_011, null);
        }
    }

    public void setMiddleName(String middleName) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).patientName(PatientName).middleName", "PlainText", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", middleName, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setMiddleName", ErrorCode.ADT_011, null);
        }
    }

    public void setSsn(String ssn) {
        this.addIdentifier(new PatientIdentifier("", ssn), 4);
    }

    public void setSuffix(String suffix) {
        try {
            Element attribute = (Element)this.templateBuilderHelper.getAttribute(this.patient.getRootElement(), "patient(Patient).patientName(PatientName).suffix", "PlainText", false, true);
            this.templateBuilderHelper.setFieldText(attribute, "value", suffix, false, '\u0000');
        }
        catch (TemplateBuildingException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), "XmlPatient.setSuffix", ErrorCode.ADT_011, null);
        }
    }

    public Document getXmlDocument() {
        return this.patient;
    }

    private String getIdentifierTypeCode(int idType) {
        switch (idType) {
            case 1: {
                return "IMS";
            }
            case 3: {
                return "PI";
            }
            case 2: {
                return "NI";
            }
            case 4: {
                return "SS";
            }
        }
        return "";
    }

    public PatientIdentifier getCorrelatedIdForDomain(String dataDomain) {
        PatientIdentifier cid = null;
        PatientIdentifier[] cids = this.getIdentifiers(1);
        for (int i = 0; i < cids.length; ++i) {
            if (!cids[i].getDomain().equals(dataDomain)) continue;
            cid = cids[i];
            break;
        }
        return cid;
    }

    public String toString() {
        return this.patient.asXML();
    }
}

