/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.patient;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocatorException;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.service.adtprocess.AdtProcessException;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Document;

public class PatientRecord
implements Patient {
    private static final String VA_DOMAIN = "FHIE.GOV/VA0";
    private static final String SSN_DOMAIN = "USSSA";
    private static final String prefix;
    private int iDX;
    private String domain_id = null;
    private String station_id = null;
    private String lastName = null;
    private String firstName = null;
    private String middleName = null;
    private String suffixName = null;
    private String sSN = null;
    private String dOB = null;
    private String iCN = null;
    private String correlatedID = null;
    private List<Entry> ids = new ArrayList<Entry>();

    public PatientRecord(int iDX, String domain_id, String station_id) {
        this.setIDX(iDX);
        this.setDomain(domain_id);
        this.setStationId(station_id);
        if (null != domain_id && 0 < domain_id.length()) {
            this.ids.add(new Entry(3, new PatientIdentifier(prefix + station_id, domain_id)));
        }
    }

    public PatientRecord(int iDX, String domain_id, String station_id, String lastName, String firstName, String middleName, String suffixName, String sSN, String dOB, String iCN) {
        this.setIDX(iDX);
        this.setDomain(domain_id);
        this.setStationId(station_id);
        this.setFullName(lastName, firstName, middleName, suffixName);
        this.setSsn(sSN);
        this.setDob(dOB);
        this.setICN(iCN);
        if (null != domain_id && 0 < domain_id.length()) {
            this.ids.add(new Entry(3, new PatientIdentifier(prefix + station_id, domain_id)));
        }
        if (null != iCN && 0 < iCN.length()) {
            this.ids.add(new Entry(2, new PatientIdentifier(VA_DOMAIN, iCN)));
        }
        if (null != sSN && 0 < sSN.length()) {
            this.ids.add(new Entry(4, new PatientIdentifier(SSN_DOMAIN, sSN)));
        }
        if (null != this.correlatedID && 0 < this.correlatedID.length()) {
            this.ids.add(new Entry(1, new PatientIdentifier(VA_DOMAIN, this.correlatedID)));
        }
    }

    public PatientRecord(PatientRecord sourcePatient) {
        this.setIDX(sourcePatient.getIDX());
        this.setDomain(sourcePatient.getDomain());
        this.setStationId(sourcePatient.getStationId());
        this.setFullName(sourcePatient.getLastName(), sourcePatient.getFirstName(), sourcePatient.getMiddleName(), sourcePatient.getSuffix());
        this.setSsn(sourcePatient.getSsn());
        this.setDob(sourcePatient.getDob());
        this.setICN(sourcePatient.getICN());
        if (null != this.domain_id && 0 < this.domain_id.length()) {
            this.ids.add(new Entry(3, new PatientIdentifier(prefix + sourcePatient.getStationId(), sourcePatient.getDomain())));
        }
        if (null != this.iCN && 0 < this.iCN.length()) {
            this.ids.add(new Entry(2, new PatientIdentifier(VA_DOMAIN, sourcePatient.getICN())));
        }
        if (null != this.sSN && 0 < this.sSN.length()) {
            this.ids.add(new Entry(4, new PatientIdentifier(SSN_DOMAIN, sourcePatient.getSsn())));
        }
        if (null != this.correlatedID && 0 < this.correlatedID.length()) {
            this.ids.add(new Entry(1, new PatientIdentifier(VA_DOMAIN, sourcePatient.getICN())));
        }
    }

    public int getIDX() {
        return this.iDX;
    }

    public void setIDX(int iDX) {
        this.iDX = iDX;
    }

    public String getDomain() {
        return this.domain_id;
    }

    public void setDomain(String domain_id) {
        this.domain_id = domain_id;
    }

    public void setFullName(String lastName, String firstName, String middleName, String suffixName) {
        this.setLastName(lastName);
        this.setFirstName(firstName);
        this.setMiddleName(middleName);
        this.setSuffix(suffixName);
    }

    public String getLastName() {
        return this.lastName;
    }

    public String getLastNameU() {
        if (this.lastName != null) {
            return this.lastName.toUpperCase();
        }
        return "";
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public String getFirstName() {
        return this.firstName;
    }

    public String getFirstNameU() {
        if (this.firstName != null) {
            return this.firstName.toUpperCase();
        }
        return "";
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public String getMiddleName() {
        return this.middleName;
    }

    public String getMiddleNameU() {
        if (this.middleName != null) {
            return this.middleName.toUpperCase();
        }
        return "";
    }

    public void setMiddleName(String middleName) {
        this.middleName = middleName;
    }

    public String getSuffix() {
        return this.suffixName;
    }

    public String getSuffixNameU() {
        if (this.suffixName != null) {
            return this.suffixName.toUpperCase();
        }
        return "";
    }

    public void setSuffix(String suffixName) {
        this.suffixName = suffixName;
    }

    public String getSsn() {
        if (this.sSN != null) {
            return this.sSN;
        }
        return "0";
    }

    public void setSsn(String sSN) {
        this.sSN = sSN;
    }

    public String getDob() {
        if (this.dOB != null) {
            return this.dOB;
        }
        return "";
    }

    public void setDob(String dOB) {
        this.dOB = dOB;
    }

    public String getICN() {
        return this.iCN;
    }

    public void setICN(String iCN) {
        this.iCN = iCN;
    }

    public String getStationId() {
        return this.station_id;
    }

    public void setStationId(String station_id) {
        this.station_id = station_id;
    }

    public void setCorrId(String correlated_Id) {
        this.correlatedID = correlated_Id;
    }

    public String getCorrId() {
        return this.correlatedID;
    }

    public boolean doICNMatch(PatientRecord secondPatient) {
        return this.getICN().equalsIgnoreCase(secondPatient.getICN());
    }

    public boolean doLocalPatientMatch(PatientRecord secondPatient) {
        return this.getDomain().equalsIgnoreCase(secondPatient.getDomain()) && this.getStationId().equalsIgnoreCase(secondPatient.getStationId());
    }

    public boolean doPatientNameMatch(PatientRecord secondPatient) {
        return this.getLastName().equalsIgnoreCase(secondPatient.getLastName()) && this.getFirstName().equalsIgnoreCase(secondPatient.getFirstName()) && this.getMiddleName().equalsIgnoreCase(secondPatient.getMiddleName());
    }

    public boolean doPatientMatch(PatientRecord secondPatient) {
        if (!this.doICNMatch(secondPatient)) {
            return false;
        }
        if (!this.doLocalPatientMatch(secondPatient)) {
            return false;
        }
        if (!this.doPatientNameMatch(secondPatient)) {
            return false;
        }
        if (!this.getSsn().equalsIgnoreCase(secondPatient.getSsn())) {
            return false;
        }
        return this.getDob().equalsIgnoreCase(secondPatient.getDob());
    }

    public boolean doSSNMatch(PatientRecord secondPatient) {
        return this.getSsn().equalsIgnoreCase(secondPatient.getSsn());
    }

    public boolean doDOBMatch(PatientRecord secondPatient) {
        return this.getDob().equalsIgnoreCase(secondPatient.getDob());
    }

    public void addIdentifier(PatientIdentifier pid, int idType) {
        this.ids.add(new Entry(idType, pid));
    }

    public void removeIdentifier(PatientIdentifier pid, int idType) {
        this.ids.remove(new Entry(idType, pid));
    }

    public boolean belongsTo(DataDomain dataDomain) {
        return dataDomain.getName().equalsIgnoreCase(this.domain_id);
    }

    public PatientIdentifier getCorrelatedIdForDomain(String dataDomain) {
        PatientIdentifier cid = null;
        PatientIdentifier[] cids = this.getIdentifiers(1);
        for (int i = 0; i < cids.length; ++i) {
            if (!cids[i].getDomain().equals(dataDomain)) continue;
            cid = cids[i];
            break;
        }
        return cid;
    }

    public DataDomain getDataDomain() {
        try {
            return DataDomainLocator.getInstance().locate(this.domain_id);
        }
        catch (DataDomainLocatorException e1) {
            IMSException.getIMSException(new AdtProcessException("An error occurred while trying to locate the DataDomain object for the domain: " + this.domain_id + ".", e1));
            return null;
        }
    }

    public PatientIdentifier getFirstIdentifier(int idType) {
        return this.getIdentifiers(idType)[0];
    }

    public PatientIdentifier[] getIdentifiers(int idType) {
        ArrayList<PatientIdentifier> l = new ArrayList<PatientIdentifier>();
        for (Entry entry : this.ids) {
            if (0 != idType && idType != entry.getType()) continue;
            l.add(entry.getPi());
        }
        return l.toArray(new PatientIdentifier[l.size()]);
    }

    public Document getXmlDocument() {
        return null;
    }

    public String getSex() {
        return null;
    }

    public void setSex(String sex) {
    }

    public String getPrefix() {
        return prefix;
    }

    static {
        String prefix_tst;
        String namingEntityPrefix = "naming_entity_prefix";
        PropertyMgr pm = PropertyMgr.getInstance(VA_DOMAIN);
        if (null == pm) {
            PropertyMgr.addManager(VA_DOMAIN, new PropertyMgr("/properties/node/domain[@id='FHIE.GOV/VA0']"));
        }
        prefix = (prefix_tst = pm.getProperty("naming_entity_prefix").getValue()).endsWith("/") ? prefix_tst : prefix_tst + "/";
    }

    public class Entry {
        int type;
        PatientIdentifier pi;

        public Entry(int type, PatientIdentifier pi) {
            this.type = type;
            this.pi = pi;
        }

        public final PatientIdentifier getPi() {
            return this.pi;
        }

        public final void setPi(PatientIdentifier pi) {
            this.pi = pi;
        }

        public final int getType() {
            return this.type;
        }

        public final void setType(int type) {
            this.type = type;
        }
    }
}

