/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.hl7;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.util.BeanHelper;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.hl7.ApplicationAcknowledgmentException;
import gov.va.med.hds.hdr.busobj.hl7.ApplicationAcknowledgmentResponse;
import gov.va.med.hds.hdr.common.net.MllpNetworkClient;
import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.service.ServiceException;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.oracle.OracleHL7AuditDAO;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegmentFactory;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import javax.jms.Message;
import javax.jms.QueueConnection;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.jms.TextMessage;

public class HL7ApplicationAcknowledgment
implements ApplicationAcknowledgmentResponse {
    private String acknowledgementCode;
    private HL7MessageInfo msgInfo;
    private static final String PROP_ACCEPT_ACK = "applicationAck_AcceptAck";
    private static final String PROP_READ_ON_NE = "applicationAck_readOnNE";
    private static final String PROP_CA_TIMEOUT = "applicationAck_CAtimeoutSeconds";
    private static final ThreadLocal<Object[]> senderObjects = new ThreadLocal();
    private final boolean readOnNE;
    private final int commitAckResponseTimeout;
    private static final HL7Service hl7Service = ServiceLocator.getInstance().getHL7Service();
    private static final MllpNetworkClient mllpNetworkClient = MllpNetworkClient.getInstance();
    private final QueueLocator qLocator = hl7Service.getApplicationAcknowledgeJMSQueueLocator();
    private final QueueConnection qConnection = this.qLocator.getConnection();
    protected MshSegment mshSeg;
    protected InetSocketAddress socketAddress;
    private static final String MSA = "MSA";
    private static final String ACCEPT_ACK_POSITIVE = "CA";

    public HL7ApplicationAcknowledgment() throws Exception {
        boolean read;
        int timeout;
        try {
            timeout = Integer.valueOf(hl7Service.getProperty(PROP_CA_TIMEOUT));
        }
        catch (NumberFormatException e) {
            timeout = 10;
        }
        this.commitAckResponseTimeout = timeout;
        try {
            read = Boolean.valueOf(hl7Service.getProperty(PROP_READ_ON_NE));
        }
        catch (Exception e) {
            read = false;
        }
        this.readOnNE = read;
    }

    public static final boolean requestsApplicationAcknowledgment(String hl7, String ackCode) {
        HL7MessageInfoImpl mi = new HL7MessageInfoImpl(hl7);
        String ackType = MshSegmentFactory.createSegment(HL7SegmentParser.parseLine(StringHelper.split((String)hl7, (String)HL7MessageInfo.LINE_DELIMETER)[0], (HL7MessageInfo)mi), (HL7MessageInfo)mi).getApplicationAcknowledgmentType();
        boolean requestsAck = "AL".equals(ackType);
        if (!requestsAck && (requestsAck = !"NE".equals(ackType)) && !(requestsAck = "AA".equals(ackCode) && "SU".equals(ackType))) {
            requestsAck = "ER".equals(ackType) && !"AA".equals(ackCode);
        }
        return requestsAck;
    }

    public String getApplicationAck(String domain, String error) throws ApplicationAcknowledgmentException {
        try {
            return new StringBuffer().append(this.getMshSegment(domain)).append(HL7MessageInfo.LINE_DELIMETER).append(this.getMsaSegment(error)).toString();
        }
        catch (Exception e) {
            if (e instanceof ApplicationAcknowledgmentException) {
                throw (ApplicationAcknowledgmentException)e;
            }
            throw new ApplicationAcknowledgmentException(e);
        }
    }

    public String getAcceptAckType() {
        return null != this.mshSeg ? this.mshSeg.getAcceptAcknowledgmentType() : "";
    }

    public String getApplicationAckType() {
        return null != this.mshSeg ? this.mshSeg.getApplicationAcknowledgmentType() : "";
    }

    public void setAcknowledgeCode(String code) throws ApplicationAcknowledgmentException {
        if (code != "AA" && code != "AE" && code != "AR") {
            throw new ApplicationAcknowledgmentException("Invalid Application Acknowledgment code");
        }
        this.acknowledgementCode = code;
    }

    public void setOriginatingMessage(String hl7) {
        this.msgInfo = new HL7MessageInfoImpl(hl7);
        this.mshSeg = MshSegmentFactory.createSegment(HL7SegmentParser.parseLine(hl7.split(HL7MessageInfo.LINE_DELIMETER)[0], this.msgInfo), this.msgInfo);
    }

    public void sendApplicationAck(String ackMsg) throws Exception {
        try {
            Method method = hl7Service.getApplicationAcknowledgeMethod();
            method.invoke((Object)this, ackMsg);
        }
        catch (Exception e) {
            throw IMSException.getIMSException(e, (CharSequence)"Application ACK exception", "HL7ApplicationAcknowledgment:sendApplicationAck(String)", ErrorCode.HL7M_011, new String[]{ackMsg});
        }
    }

    public void sendApplicationAck(String originalMsg, boolean success, String domain, String error) throws Exception {
        String ackCode = success ? "AA" : "AE";
        switch (hl7Service.getApplicationAcknowledgeMode()) {
            case 3: {
                break;
            }
            case 1: {
                if (!HL7ApplicationAcknowledgment.requestsApplicationAcknowledgment(originalMsg, ackCode)) break;
            }
            default: {
                try {
                    this.setOriginatingMessage(originalMsg);
                    this.setAcknowledgeCode(ackCode);
                    String appAck = this.getApplicationAck(domain, error);
                    this.sendApplicationAck(appAck);
                    break;
                }
                catch (Exception e) {
                    IMSException.getIMSException(e, (CharSequence)"Application ACK exception", "HL7ApplicationAcknowledgment:sendApplicationAck(String)", ErrorCode.HL7M_011, new String[]{originalMsg});
                }
            }
        }
    }

    public String getOriginatingMessageControlId() {
        return null != this.mshSeg ? this.mshSeg.getMessageControlId() : "";
    }

    public String getAcknowledgmentCode() {
        return this.acknowledgementCode;
    }

    private String getMshSegment(String domain) throws ServiceException, ApplicationAcknowledgmentException {
        if (null == this.msgInfo || null == this.mshSeg) {
            throw new ApplicationAcknowledgmentException("No original message is set.");
        }
        String sendingFacility = null == this.mshSeg.getSendingFacility() ? hl7Service.getApplicationAcknowledgeSendingFacility() : this.mshSeg.getSendingFacility();
        StringBuffer msh = new StringBuffer("MSH").append(this.msgInfo.getFieldDelimeter()).append(this.mshSeg.getEncodingCharacters()).append(this.msgInfo.getFieldDelimeter()).append(this.mshSeg.getReceivingApplication()).append(this.msgInfo.getFieldDelimeter()).append(this.mshSeg.getReceivingFacility()).append(this.msgInfo.getFieldDelimeter()).append(this.mshSeg.getSendingApplication()).append(this.msgInfo.getFieldDelimeter()).append(sendingFacility).append(this.msgInfo.getFieldDelimeter()).append(DateTimeUtility.getCurrentTime()).append(this.msgInfo.getFieldDelimeter()).append(this.msgInfo.getFieldDelimeter()).append("ACK").append(this.msgInfo.getFieldDelimeter()).append(hl7Service.generateMessageControlId(domain)).append(this.msgInfo.getFieldDelimeter()).append(this.mshSeg.getProcessingId()).append(this.msgInfo.getFieldDelimeter()).append(this.msgInfo.getVersion()).append(this.msgInfo.getFieldDelimeter()).append(this.msgInfo.getFieldDelimeter()).append(this.msgInfo.getFieldDelimeter()).append(hl7Service.getProperty(PROP_ACCEPT_ACK)).append(this.msgInfo.getFieldDelimeter()).append("NE");
        return msh.toString();
    }

    private String getMsaSegment(String error) {
        StringBuffer msa = new StringBuffer(MSA).append(this.msgInfo.getFieldDelimeter()).append(this.getAcknowledgmentCode()).append(this.msgInfo.getFieldDelimeter()).append(this.getOriginatingMessageControlId());
        if (null != error && 0 < error.length()) {
            msa.append(this.msgInfo.getFieldDelimeter()).append(error.substring(0, 80));
        }
        return msa.toString();
    }

    public boolean equals(Object obj) {
        boolean equals;
        boolean bl = equals = obj == this;
        if (!equals && (equals = obj instanceof HL7ApplicationAcknowledgment)) {
            HL7ApplicationAcknowledgment that = (HL7ApplicationAcknowledgment)obj;
            String ackCode = that.getAcknowledgmentCode();
            String originatingMessageControlId = that.getOriginatingMessageControlId();
            equals = ackCode == this.acknowledgementCode || null != ackCode && ackCode.equals(this.acknowledgementCode);
            if (equals) {
                equals = originatingMessageControlId == this.getOriginatingMessageControlId() || null != originatingMessageControlId && originatingMessageControlId.equals(this.getOriginatingMessageControlId());
            }
        }
        return equals;
    }

    public int hashCode() {
        int hashCode = BeanHelper.nameHash(this.getClass().getName());
        hashCode += null == this.acknowledgementCode ? System.identityHashCode(null) : this.acknowledgementCode.hashCode();
        return hashCode += null == this.getOriginatingMessageControlId() ? System.identityHashCode(null) : this.getOriginatingMessageControlId().hashCode();
    }

    public String toString() {
        try {
            return this.getApplicationAck(null, null);
        }
        catch (ApplicationAcknowledgmentException e) {
            return e.getLocalizedMessage();
        }
    }

    public void asynchronousResponse(String response) throws Exception {
        QueueSession qSession = null;
        QueueSender qSender = null;
        Object[] qObjects = senderObjects.get();
        if (null == qObjects) {
            qSession = this.qConnection.createQueueSession(false, 1);
            qSender = this.qLocator.getSender(qSession, this.qLocator.getQueue((Session)qSession));
            senderObjects.set(new Object[]{qSession, qSender});
        } else {
            qSession = (QueueSession)qObjects[0];
            qSender = (QueueSender)qObjects[1];
        }
        TextMessage responseMsg = qSession.createTextMessage(response);
        qSender.send((Message)responseMsg);
    }

    public void synchronousResponse(String response) throws Exception {
        OracleHL7AuditDAO auditor = new OracleHL7AuditDAO();
        this.setOriginatingMessage(response);
        String msgid = this.getMsgId(response);
        String domain = hl7Service.getApplicationAcknowledgeDomain();
        auditor.addMessage(domain, msgid, response);
        InetSocketAddress address = this.getSocketAddress();
        boolean acceptAck = this.expectAcceptAck(response.trim());
        if (acceptAck || this.readOnNE) {
            String reply = mllpNetworkClient.doRequest(response, address.getHostName(), address.getPort(), (long)this.commitAckResponseTimeout * 1000L);
            if (0 < reply.length() && acceptAck) {
                this.processResponse(reply, msgid);
                auditor.addMessage(domain, this.getMsgId(response), reply);
            } else if (acceptAck) {
                throw IMSException.getIMSException(new Exception("Expected CA not received."), (CharSequence)"Expected CA not received", "HL7ApplicationAcknowledgment:synchronousResponse", ErrorCode.HL7M_013, new String[]{response});
            }
        }
    }

    private boolean expectAcceptAck(String msg) {
        boolean expected = false;
        try {
            String ackType = this.getAcceptAckType();
            expected = 0 < ackType.length() && !ackType.equals("NE");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return expected;
    }

    private String getMsgId(String ackMsg) {
        String msgId = null;
        try {
            msgId = this.getOriginatingMessageControlId();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return msgId;
    }

    private void processResponse(String acceptAck, String msgId) {
        String[] segments = StringHelper.split((String)acceptAck, (String)HL7Service.LINE_SEP);
        String[] fields = StringHelper.split((String)segments[1], (String)acceptAck.substring(3, 4));
        if (!MSA.equals(fields[0]) || !ACCEPT_ACK_POSITIVE.equals(fields[1])) {
            throw IMSException.getIMSException(new Exception("Negative Accept ACK"), (CharSequence)"Negative Accept ACK", "HL7ApplicationAcknowledgment:processResponse", ErrorCode.HL7M_011, new String[]{acceptAck});
        }
        if (!msgId.equals(fields[2])) {
            throw IMSException.getIMSException(new Exception("Incorrect HL7 Message Id"), (CharSequence)"Incorrect HL7 Message Id", "HL7ApplicationAcknowledgment:processResponse", ErrorCode.HL7M_015, new String[]{msgId, fields[2]});
        }
    }

    protected synchronized InetSocketAddress getSocketAddress() {
        if (null == this.socketAddress) {
            String[] url = hl7Service.getApplicationAcknowledgeURL().split(":");
            String host = url[0];
            int port = Integer.parseInt(url[1]);
            this.socketAddress = new InetSocketAddress(host, port);
        }
        return this.socketAddress;
    }
}

