/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.domain;

import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.PatientRecord;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.ServiceUnavailableException;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.PatientDAO;
import java.util.ArrayList;
import java.util.List;

public class PatientOperationsDomain {
    protected String name = null;
    protected List children = new ArrayList();
    protected String originationDomain = null;

    public PatientOperationsDomain(String originatingDomain) {
        this.originationDomain = originatingDomain;
    }

    public PatientIdentifier getPossibleCorrId(String originatingDomain, String domainId, String currentDomain) throws DataAccessException, ServiceUnavailableException {
        PropertyMgr pmgr = PropertyMgr.getInstance(currentDomain);
        Object corrupdatePatient = null;
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientIdentifier correlatedId = patientDAO.getPossibleCorrelatedId(new PatientIdentifier(originatingDomain, domainId), currentDomain);
        return correlatedId;
    }

    public PatientIdentifier[] getAllLocalIdsForDomain(PatientIdentifier correlatedId, String domain, String currentDomain) throws DataAccessException, ServiceUnavailableException {
        if (correlatedId == null) {
            return null;
        }
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientIdentifier[] pids = patientDAO.getLocalIdsForDomain(correlatedId, domain, currentDomain);
        return pids;
    }

    public PatientIdentifier[] getAllLocalIds(PatientIdentifier correlatedId, String currentDomain) throws DataAccessException, ServiceUnavailableException {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientIdentifier[] pids = patientDAO.getLocalIds(correlatedId, currentDomain);
        return pids;
    }

    public String checkDupPatientId(PatientIdentifier dfn, String NationalICN) throws DataAccessException, ServiceUnavailableException {
        String localICN = null;
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientRecord[] pids = patientDAO.getExistingLocalId(dfn, this.originationDomain);
        if (pids.length == 0 || pids[0] == null) {
            return null;
        }
        for (int i = 0; i < pids.length; ++i) {
            if (pids[i].getDomain().equals(NationalICN)) {
                return null;
            }
            if (!pids[i].getStationId().equals("FHIE.GOV/VA0")) continue;
            localICN = pids[i].getICN();
        }
        return localICN;
    }

    public PatientRecord addNewPatient(PatientRecord patientInfo, String currDomain) throws Exception {
        String correlatingId = null;
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        if (patientInfo.getCorrId() == null) {
            correlatingId = patientDAO.addToMPI(patientInfo, currDomain);
            patientInfo.setCorrId(correlatingId);
        }
        correlatingId = this.addNewICNPatId(patientInfo, currDomain);
        String namingEntityPrefix = this.getNamingEntityPrefix(currDomain);
        PatientIdentifier correlatdId = patientDAO.getPossibleCorrelatedId(new PatientIdentifier(namingEntityPrefix + patientInfo.getStationId(), patientInfo.getDomain()), currDomain);
        if (correlatdId == null && patientInfo.getDomain() != null) {
            patientDAO.addLocalPatID(patientInfo, currDomain);
        }
        return patientInfo;
    }

    public PatientRecord addNewCorrelatedPatient(PatientRecord patientInfo, String currDomain) throws Exception {
        String correlatedId = this.updateMPI(patientInfo, currDomain);
        patientInfo.setCorrId(correlatedId);
        this.addNewLocalPatId(patientInfo, currDomain);
        return patientInfo;
    }

    public String updateMPI(PatientRecord patientInfo, String currDomain) throws Exception {
        String sourceCorrId = null;
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        if (patientInfo.getCorrId() == null) {
            sourceCorrId = patientDAO.addToMPI(patientInfo, currDomain);
            patientInfo.setCorrId(sourceCorrId);
            return sourceCorrId;
        }
        PatientRecord[] MPIRecords = patientDAO.getMPIInfo(patientInfo.getCorrId(), currDomain);
        boolean returnStatus = true;
        if (MPIRecords.length == 0) {
            sourceCorrId = patientDAO.addToMPI(patientInfo, currDomain);
            patientInfo.setCorrId(sourceCorrId);
            return sourceCorrId;
        }
        return patientInfo.getCorrId();
    }

    public void auditToIdModification(PatientRecord patientInfo, String destinationCorrId, String currDomain, String patientOperation) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        boolean returnStatus = patientDAO.addToIdModification(patientInfo, destinationCorrId, currDomain, patientOperation);
    }

    public void auditIdModification(PatientRecord patientFromInfo, PatientRecord patientToInfo, String currDomain, String patientOperation) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        boolean returnStatus = patientDAO.addToIdModification(patientFromInfo, patientToInfo, currDomain, patientOperation);
    }

    public void addNewCorrPatId(PatientRecord patientInfo, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        patientDAO.addLocalPatID(patientInfo, currDomain);
    }

    public String addNewLocalPatId(PatientRecord patientInfo, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        patientDAO.addLocalPatID(patientInfo, currDomain);
        return patientInfo.getCorrId();
    }

    public String addNewChildPatId(PatientRecord patientInfo, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        String corrId = patientDAO.addChildPatID(patientInfo, currDomain);
        return corrId;
    }

    public String createMPIEntry(PatientRecord mrgPatient, String originatingDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        return patientDAO.addToMPI(mrgPatient, originatingDomain);
    }

    public String addNewICNPatId(PatientRecord patientInfo, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        String correlatingId = patientDAO.addICNPatID(patientInfo, currDomain);
        return correlatingId;
    }

    public String getNamingEntityPrefix(String currDomain) {
        PropertyMgr pmgr = PropertyMgr.getInstance(currDomain);
        String namingEntityPrefix = pmgr.getProperty("naming_entity_prefix").getValue();
        return namingEntityPrefix;
    }

    public boolean moveLocalPatId(PatientRecord patientInfo, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        boolean status = patientDAO.mvLocalPatID(patientInfo, currDomain);
        return true;
    }

    public void doLinkPatientId(PatientRecord fromPatientInfo, PatientRecord toPatientInfo, String currDomain) throws Exception {
        try {
            PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
            patientDAO.linkFromTo(fromPatientInfo.getCorrId(), toPatientInfo.getCorrId(), currDomain);
            patientDAO.removeFromMPI(fromPatientInfo.getCorrId(), currDomain);
        }
        catch (Exception e) {
            throw new DataAccessException("doLinkPatientId failed in domain " + currDomain);
        }
    }

    public void doUpdateCorrPatientId(PatientRecord fromPatientInfo, PatientRecord toPatientInfo, String currDomain) throws Exception {
        try {
            PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
            patientDAO.removeFromCorrelate(fromPatientInfo.getCorrId(), fromPatientInfo.getDomain(), currDomain);
            patientDAO.linkFromTo(fromPatientInfo.getCorrId(), toPatientInfo.getCorrId(), currDomain);
        }
        catch (Exception e) {
            throw new DataAccessException("dUpdateCorrPatientId failed in domain " + currDomain);
        }
    }

    public void doLinkCorrPatientId(PatientRecord fromPatientInfo, PatientRecord toPatientInfo, String currDomain) throws Exception {
        try {
            PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
            if (fromPatientInfo.getCorrId() != null) {
                patientDAO.removeFromCorr(fromPatientInfo.getCorrId(), currDomain);
                patientDAO.removeFromMPI(fromPatientInfo.getCorrId(), currDomain);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("doLinkPatientId failed in domain " + currDomain);
        }
    }

    public void removeCorrelate(PatientRecord correlatePatient, String currDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        patientDAO.removeFromCorrelate(correlatePatient.getCorrId(), correlatePatient.getStationId(), currDomain);
    }
}

