/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.domain;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainAccessor;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocatorException;
import java.lang.reflect.Constructor;
import java.util.Hashtable;
import java.util.Map;

public class DataDomainLocator {
    private static DataDomainLocator instance = null;
    private Map<String, DataDomainAccessor> dataDomainMap = new Hashtable<String, DataDomainAccessor>();

    private DataDomainLocator() throws DataDomainLocatorException {
        String id;
        int i;
        PropertyMgr pm = PropertyMgr.getInstance();
        PropertyElement[] domains = pm.getProperties("domain");
        DataDomainAccessor dataDomain = null;
        for (i = 0; i < domains.length; ++i) {
            id = domains[i].getAttribute("id");
            String clazz = domains[i].getAttribute("type");
            try {
                Constructor<?> constructor = Class.forName(clazz).getConstructor(String.class);
                dataDomain = (DataDomainAccessor)constructor.newInstance(id);
            }
            catch (Exception e) {
                throw new DataDomainLocatorException("An error occurred while initializing the DataDomain for the '" + id + "' domain. " + "Please check the application configuration and restart " + "the framework.", e);
            }
            this.dataDomainMap.put(id, dataDomain);
        }
        for (i = 0; i < domains.length; ++i) {
            id = domains[i].getAttribute("id");
            dataDomain = this.dataDomainMap.get(id);
            PropertyElement[] childDomains = domains[i].getChildProperties("child_domain");
            for (int x = 0; x < childDomains.length; ++x) {
                dataDomain.addChild((DataDomain)((Object)this.dataDomainMap.get(childDomains[x].getValue())));
            }
            PropertyElement[] parentDomains = domains[i].getChildProperties("parent_domain");
            for (int x = 0; x < parentDomains.length; ++x) {
                dataDomain.setParent((DataDomain)((Object)this.dataDomainMap.get(parentDomains[x].getValue())));
            }
        }
    }

    public static DataDomainLocator getInstance() throws DataDomainLocatorException {
        if (instance == null) {
            instance = new DataDomainLocator();
        }
        return instance;
    }

    public DataDomain locate(String domainName) {
        return (DataDomain)((Object)this.dataDomainMap.get(domainName));
    }
}

