/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.domain;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.AbstractDataDomain;
import gov.va.med.hds.hdr.busobj.domain.NoLocalIdentifierException;
import gov.va.med.hds.hdr.busobj.domain.NoNationalIdentifierException;
import gov.va.med.hds.hdr.busobj.domain.PatientNotKnownException;
import gov.va.med.hds.hdr.busobj.domain.PatientOperationsDomain;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.PatientRecord;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.common.util.ExceptionList;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.PatientDAO;
import gov.va.med.hds.hdr.service.mpi.MasterPatientIndex;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.springframework.jms.core.JmsTemplate;
import org.springframework.jms.core.MessageCreator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CorrelatingDataDomain
extends AbstractDataDomain {
    private static final PatientIdentifier DUMMY_PID = new PatientIdentifier("DUMMY", "DUMMY");
    private static final String ICN_DATA_DOMAIN = "FHIE.GOV/VA0";
    private static Synchronizer synchronizer = new Synchronizer();
    private PropertyMgr propMgr = PropertyMgr.getInstance(this.getName());
    private PatientDAO patientDAO = null;
    private MasterPatientIndex mpi = null;
    private JmsTemplate jmsTemplate = null;
    private static final String ADTLINK = "LINK";
    private static final String ADTUNLINK = "UNLINK";
    private static final String ADTMOVE = "MOVE";
    private static final DateFormat df = DateTimeUtility.stdDateFmt;
    private static long lastTime;
    private static long corrCount;
    private static long findPatient;
    private static long patientFound;

    public CorrelatingDataDomain(String name) {
        super(name);
    }

    @Override
    public PatientIdentifier[] resolveIds(PatientIdentifier id) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        return patientDAO.getLocalIds(id, this.getName());
    }

    @Override
    public final void correlatePatientAsync(final Patient patient) throws Exception {
        PatientIdentifier lid = patient.getFirstIdentifier(3);
        if (lid == null) {
            throw new NoLocalIdentifierException("The patient has no Local identifier.");
        }
        if (!this.isIdentifierInDomain(lid)) {
            if (this.jmsTemplate == null) {
                PropertyElement jmsTemplateIdElement = this.propMgr.getProperty("jmsTemplateId");
                this.jmsTemplate = ServiceLocator.getInstance().getJmsTemplate(jmsTemplateIdElement.getValue());
            }
            this.jmsTemplate.send(new MessageCreator(){

                public Message createMessage(Session session) throws JMSException {
                    return session.createTextMessage(patient.toString());
                }
            });
        }
    }

    @Override
    public final void correlatePatient(Patient patient) throws Exception {
        long startCorrelate = lastTime = System.currentTimeMillis();
        ++corrCount;
        PatientIdentifier lid = patient.getFirstIdentifier(3);
        PatientIdentifier nid = patient.getFirstIdentifier(2);
        if (lid == null) {
            throw new NoLocalIdentifierException("There is no local identifier present in patient object.");
        }
        if (nid == null) {
            nid = DUMMY_PID;
        }
        boolean isIdentifierInDomain = this.isIdentifierInDomain(lid);
        if (nid != DUMMY_PID) {
            try {
                this.storePatient(patient);
            }
            catch (Exception e) {
                throw IMSException.getIMSException("An error occurred while trying to store the patient in the domain.", e);
            }
        }
        if (!isIdentifierInDomain) {
            long startFindCandidates = System.currentTimeMillis();
            if (this.mpi == null) {
                this.mpi = ServiceLocator.getInstance().getMPIService();
            }
            ++findPatient;
            this.mpi.correlatePatient(this.getName(), patient);
        } else {
            ++patientFound;
        }
    }

    public final void storePatient(Patient patient) throws Exception {
        long startStorePatient = System.currentTimeMillis();
        PatientDAO pdao = this.getPatientDAO();
        PatientIdentifier nationalId = patient.getFirstIdentifier(2);
        if (nationalId != null) {
            pdao.findCorrelatedIdForPatient(patient, this.getName());
            PatientIdentifier correlatedId = patient.getCorrelatedIdForDomain(this.getName());
            this.doStoreNationIdentifier(patient);
            PatientIdentifier localIdentifier = patient.getFirstIdentifier(3);
            if (null == localIdentifier) {
                throw IMSException.getIMSException(new NoLocalIdentifierException());
            }
            if (!this.isIdentifierInDomain(localIdentifier)) {
                pdao.storeDomainIdentifier(patient, localIdentifier, this.getName());
                pdao.storePatientDemographics(patient, this.getName());
            }
            long localCorrelatedId = pdao.findCorrelatedIdByPatientId(localIdentifier, this.getName());
            long nationalCorrelatedId = pdao.findCorrelatedIdByPatientId(nationalId, this.getName());
            if (nationalCorrelatedId != localCorrelatedId) {
                this.doUpdateCorrelationId(patient, localCorrelatedId, nationalCorrelatedId);
            }
        } else {
            throw new NoNationalIdentifierException();
        }
    }

    private void doUpdateCorrelationId(Patient patient, Long fromCorrelatedId, Long toCorrelatedId) throws Exception {
        CorrelatingDataDomain parent = (CorrelatingDataDomain)this.getParent();
        PatientDAO patientDao = this.getPatientDAO();
        if (parent == null) {
            PatientIdentifier[] from = patientDao.findIdsByCorrelatedId(fromCorrelatedId, this.getName());
            PatientIdentifier[] to = patientDao.findIdsByCorrelatedId(toCorrelatedId, this.getName());
            block0: for (PatientIdentifier fromCid : from) {
                for (PatientIdentifier toCid : to) {
                    if (!fromCid.getDomain().equals(toCid.getDomain())) continue;
                    patientDao.moveIdentifiers(patient, Long.parseLong(fromCid.getId()), Long.parseLong(toCid.getId()), toCid.getDomain());
                    continue block0;
                }
            }
            patientDao.deleteIdentifiers(fromCorrelatedId, this.getName());
        } else {
            Long parentFromCorrelatedId = patientDao.findCorrelatedIdByPatientId(new PatientIdentifier(this.getName(), fromCorrelatedId.toString()), parent.getName());
            Long parentToCorrelatedId = patientDao.findCorrelatedIdByPatientId(new PatientIdentifier(this.getName(), toCorrelatedId.toString()), parent.getName());
            parent.doUpdateCorrelationId(patient, parentFromCorrelatedId, parentToCorrelatedId);
        }
    }

    private final void doStoreNationIdentifier(Patient patient) throws Exception {
        long startDoStoreNationalIdentifier = System.currentTimeMillis();
        if (this.isChild()) {
            ((CorrelatingDataDomain)this.getParent()).doStoreNationIdentifier(patient);
        } else {
            this.storeNationalIdentifier(patient);
        }
    }

    private final PatientIdentifier storeNationalIdentifier(Patient patient) throws Exception {
        PatientDAO pdao = this.getPatientDAO();
        PatientIdentifier correlatedId = this.getDomainCorrelatedIdForPatient(patient);
        PatientIdentifier nationalId = patient.getFirstIdentifier(2);
        if (this.isLeafDomain()) {
            if (!this.isIdentifierInDomain(nationalId) || !this.identifierHasCorrelatedId(nationalId, correlatedId, this.getName())) {
                pdao.storeDomainIdentifier(patient, nationalId, this.getName());
            }
        } else {
            Iterator iter = this.children.iterator();
            CorrelatingDataDomain child = null;
            Vector<PatientIdentifier> corrIds = new Vector<PatientIdentifier>();
            while (iter.hasNext()) {
                child = (CorrelatingDataDomain)iter.next();
                PatientIdentifier correlatedChild = new PatientIdentifier(child.getName(), correlatedId.getId());
                if ((correlatedChild = this.isInChildDomain(correlatedChild, this.getName())) != null) {
                    patient.addIdentifier(correlatedChild, 1);
                }
                corrIds.add(child.storeNationalIdentifier(patient));
            }
            iter = corrIds.iterator();
            PatientIdentifier cid = null;
            while (iter.hasNext()) {
                cid = (PatientIdentifier)iter.next();
                if (this.isIdentifierInDomain(cid)) continue;
                pdao.storeDomainIdentifier(correlatedId, cid, this.getName());
            }
        }
        return correlatedId;
    }

    public void updateIdentifierStatus(Patient patient, PatientIdentifier pid) throws Exception {
        PatientDAO pdao = this.getPatientDAO();
        PatientIdentifier cid = this.getDomainCorrelatedIdForPatient(patient);
        if (cid != null) {
            pdao.updateIdentifierStatus(Long.parseLong(cid.getId()), pid, this.getName());
        }
    }

    private PatientIdentifier getDomainCorrelatedIdForPatient(Patient patient) throws Exception {
        PatientDAO pdao = this.getPatientDAO();
        PatientIdentifier cid = patient.getCorrelatedIdForDomain(this.getName());
        if (cid == null) {
            cid = pdao.findCorrelatedIdForPatient(patient, this.getName());
        }
        if (cid == null) {
            cid = pdao.createCorrelatedId(this.getName());
            patient.addIdentifier(cid, 1);
        }
        return cid;
    }

    private PatientDAO getPatientDAO() throws Exception {
        if (this.patientDAO == null) {
            this.patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        }
        return this.patientDAO;
    }

    private PatientIdentifier isInChildDomain(PatientIdentifier pid, String dataDomain) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientIdentifier[] corrPids = patientDAO.getLocalIdsForDomain(pid, dataDomain, pid.getDomain());
        if (corrPids.length != 0) {
            return corrPids[0];
        }
        return null;
    }

    private boolean identifierHasCorrelatedId(PatientIdentifier pid, PatientIdentifier cid, String dataDomain) {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        try {
            PatientIdentifier[] pids = patientDAO.getLocalIdsForDomain(cid, dataDomain, pid.getDomain());
            for (int i = 0; i < pids.length; ++i) {
                if (!pids[i].getId().equals(pid.getId())) continue;
                return true;
            }
        }
        catch (DataAccessException e) {
            // empty catch block
        }
        return false;
    }

    private boolean isIdentifierInDomain(PatientIdentifier pid) throws Exception {
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        return patientDAO.findCorrelatedIdByPatientId(pid, this.getName()) != -1L;
    }

    @Override
    public boolean doAdtLink(PatientRecord fromPatient, PatientRecord toPatient, String originatingDomain) throws Exception {
        PatientRecord corrFromPatient = null;
        PatientRecord corrToPatient = null;
        PatientRecord newPatient = null;
        PatientRecord childCorrRecord = null;
        PatientIdentifier correlatedIdDfn = null;
        PatientIdentifier corrFromId = null;
        PatientIdentifier corrToId = null;
        boolean correlationFlag = true;
        PatientOperationsDomain patientOperations = new PatientOperationsDomain(originatingDomain);
        if (this.parent != null) {
            corrFromId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, fromPatient.getICN(), this.getName());
            if (corrFromId == null) {
                newPatient = patientOperations.addNewPatient(fromPatient, originatingDomain);
                fromPatient.setCorrId(newPatient.getCorrId());
                correlationFlag = false;
            } else {
                fromPatient.setCorrId(corrFromId.getId());
            }
            correlatedIdDfn = patientOperations.getPossibleCorrId(patientOperations.getNamingEntityPrefix(originatingDomain) + fromPatient.getStationId(), fromPatient.getDomain(), originatingDomain);
            if (correlatedIdDfn == null && fromPatient.getDomain() != null) {
                patientOperations.addNewLocalPatId(fromPatient, this.getName());
            }
            if ((corrToId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, toPatient.getICN(), this.getName())) == null) {
                newPatient = patientOperations.addNewPatient(toPatient, originatingDomain);
                toPatient.setCorrId(newPatient.getCorrId());
                correlationFlag = true;
            } else {
                toPatient.setCorrId(corrToId.getId());
            }
            if (fromPatient.getCorrId().equals(toPatient.getCorrId())) {
                String idWarning = "ICN = " + fromPatient.getICN() + ", DFN/StationID = " + fromPatient.getDomain() + "/" + originatingDomain;
                IMSException.getIMSException((Throwable)null, null, null, ErrorCode.ADT_013, new String[]{idWarning});
                return true;
            }
            patientOperations.doLinkPatientId(fromPatient, toPatient, this.getName());
            patientOperations.auditToIdModification(fromPatient, toPatient.getCorrId(), this.getName(), ADTLINK);
            if (correlationFlag) {
                corrFromPatient = this.createCorrelatePatientRecord(fromPatient, this.getName());
                corrToPatient = this.createCorrelatePatientRecord(toPatient, this.getName());
                this.parent = this.getParent();
                this.parent.doAdtLink(corrFromPatient, corrToPatient, this.getName());
            }
        } else {
            newPatient = null;
            corrFromId = patientOperations.getPossibleCorrId(originatingDomain, fromPatient.getDomain(), this.getName());
            corrToId = patientOperations.getPossibleCorrId(originatingDomain, toPatient.getDomain(), this.getName());
            if (this.children != null && this.children.size() > 0) {
                if (corrToId == null) {
                    newPatient = patientOperations.addNewCorrelatedPatient(toPatient, this.getName());
                    toPatient.setCorrId(newPatient.getCorrId());
                    patientOperations.auditToIdModification(fromPatient, toPatient.getCorrId(), this.getName(), ADTLINK);
                }
                if (corrFromId != null) {
                    fromPatient.setCorrId(corrFromId.getId());
                    if (corrToId != null) {
                        toPatient.setCorrId(corrToId.getId());
                    }
                }
                Iterator iter = this.children.iterator();
                corrFromPatient = this.createCorrelatePatientRecord(fromPatient, this.getName());
                corrToPatient = this.createCorrelatePatientRecord(toPatient, this.getName());
                while (iter.hasNext()) {
                    String childCorrelatedId;
                    PatientRecord childRecord;
                    PatientIdentifier topids;
                    childCorrRecord = null;
                    AbstractDataDomain d = (AbstractDataDomain)iter.next();
                    if (originatingDomain.equalsIgnoreCase(d.name)) continue;
                    PatientIdentifier pids = this.getOneLocalIdsForDomain(corrFromId, this.getName(), d.getName());
                    if (pids != null && corrFromPatient != null && corrToPatient != null) {
                        topids = this.getOneLocalIdsForDomain(corrToId, this.getName(), d.getName());
                        if (topids == null) {
                            childRecord = this.createChildPatientRecord(corrToPatient, originatingDomain);
                            childCorrelatedId = patientOperations.addNewChildPatId(childRecord, d.getName());
                            childCorrRecord = this.createCorrelatePatientRecord(corrToPatient, d.getName());
                            childCorrRecord.setCorrId(newPatient.getCorrId());
                            childCorrRecord.setDomain(childCorrelatedId);
                            childCorrRecord.setStationId(d.getName());
                            patientOperations.addNewCorrPatId(childCorrRecord, this.getName());
                            patientOperations.auditToIdModification(corrFromPatient, childCorrelatedId, d.getName(), ADTLINK);
                            corrToPatient.setCorrId(childCorrelatedId);
                            corrFromPatient.setCorrId(pids.getId());
                            patientOperations.doLinkPatientId(corrFromPatient, corrToPatient, d.getName());
                            patientOperations.auditToIdModification(corrFromPatient, childCorrelatedId, d.getName(), ADTLINK);
                            continue;
                        }
                        corrToPatient.setCorrId(topids.getId());
                        corrFromPatient.setCorrId(pids.getId());
                        patientOperations.doLinkPatientId(corrFromPatient, corrToPatient, d.getName());
                        patientOperations.auditToIdModification(corrFromPatient, corrToPatient.getCorrId(), d.getName(), ADTLINK);
                        continue;
                    }
                    topids = this.getOneLocalIdsForDomain(corrToId, this.getName(), d.getName());
                    if (topids != null) continue;
                    childRecord = this.createChildPatientRecord(corrToPatient, originatingDomain);
                    childCorrelatedId = patientOperations.addNewChildPatId(childRecord, d.getName());
                    childCorrRecord = this.createCorrelatePatientRecord(corrToPatient, d.getName());
                    childCorrRecord.setCorrId(newPatient.getCorrId());
                    childCorrRecord.setDomain(childCorrelatedId);
                    childCorrRecord.setStationId(d.getName());
                    patientOperations.addNewCorrPatId(childCorrRecord, this.getName());
                    patientOperations.auditToIdModification(corrFromPatient, childCorrelatedId, d.getName(), ADTLINK);
                }
                if (toPatient.getCorrId() != null) {
                    patientOperations.doLinkCorrPatientId(fromPatient, toPatient, this.getName());
                    patientOperations.auditToIdModification(fromPatient, toPatient.getCorrId(), this.getName(), ADTLINK);
                } else if (fromPatient.getCorrId() != null) {
                    patientOperations.doLinkCorrPatientId(fromPatient, childCorrRecord, this.getName());
                    patientOperations.auditToIdModification(fromPatient, childCorrRecord.getCorrId(), this.getName(), ADTLINK);
                }
            }
        }
        return true;
    }

    @Override
    public boolean updateADT(PatientRecord updatePatient, String patientICN, String originatingDomain) throws Exception {
        PatientRecord corrUpdatePatient = null;
        PatientRecord newPatient = null;
        PatientRecord childCorrRecord = null;
        boolean status = false;
        PatientOperationsDomain patientOperations = new PatientOperationsDomain(originatingDomain);
        if (this.parent != null) {
            PatientIdentifier correlatedId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, patientICN, this.getName());
            PatientIdentifier correlatedIdForDfn = patientOperations.getPossibleCorrId(patientOperations.getNamingEntityPrefix(originatingDomain) + updatePatient.getStationId(), updatePatient.getDomain(), originatingDomain);
            if (correlatedId == null) {
                if (correlatedIdForDfn == null) {
                    newPatient = patientOperations.addNewPatient(updatePatient, originatingDomain);
                    correlatedId = new PatientIdentifier(newPatient.getStationId(), newPatient.getDomain());
                    correlatedIdForDfn = new PatientIdentifier(newPatient.getStationId(), newPatient.getDomain());
                } else {
                    updatePatient.setCorrId(correlatedIdForDfn.getId());
                    correlatedIdForDfn = new PatientIdentifier(updatePatient.getStationId(), patientOperations.addNewICNPatId(updatePatient, this.getName()));
                }
            } else {
                updatePatient.setCorrId(correlatedId.getId());
                correlatedIdForDfn = patientOperations.getPossibleCorrId(patientOperations.getNamingEntityPrefix(originatingDomain) + updatePatient.getStationId(), updatePatient.getDomain(), originatingDomain);
                if (correlatedIdForDfn == null) {
                    correlatedIdForDfn = new PatientIdentifier(updatePatient.getStationId(), patientOperations.addNewLocalPatId(updatePatient, this.getName()));
                } else if (correlatedId.getId() != correlatedIdForDfn.getId()) {
                    status = patientOperations.moveLocalPatId(updatePatient, this.getName());
                }
                updatePatient.setCorrId(correlatedId.getId());
                patientOperations.updateMPI(updatePatient, this.getName());
            }
            patientOperations.auditToIdModification(updatePatient, correlatedIdForDfn.getId(), this.getName(), ADTLINK);
            corrUpdatePatient = this.createCorrelatePatientRecord(updatePatient, this.getName());
            this.parent = this.getParent();
            status = this.parent.updateADT(corrUpdatePatient, corrUpdatePatient.getDomain(), this.getName());
        } else {
            PatientIdentifier correlatedId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, patientICN, this.getName());
            newPatient = new PatientRecord(updatePatient);
            if (this.children != null && this.children.size() > 0) {
                for (AbstractDataDomain d : this.children) {
                    String childCorrelatedId;
                    if (originatingDomain.equalsIgnoreCase(d.name)) continue;
                    if (correlatedId == null) {
                        PatientRecord childRecord = this.createChildPatientRecord(updatePatient, originatingDomain);
                        String childCorrelatedId2 = patientOperations.addNewChildPatId(childRecord, d.getName());
                        childCorrRecord = this.createCorrelatePatientRecord(updatePatient, d.getName());
                        childCorrRecord.setCorrId(newPatient.getCorrId());
                        childCorrRecord.setDomain(childCorrelatedId2);
                        childCorrRecord.setStationId(d.getName());
                        patientOperations.addNewCorrPatId(childCorrRecord, this.getName());
                        patientOperations.auditToIdModification(updatePatient, childCorrelatedId2, d.getName(), ADTLINK);
                        newPatient = patientOperations.addNewCorrelatedPatient(updatePatient, this.getName());
                        updatePatient.setCorrId(newPatient.getCorrId());
                        correlatedId = new PatientIdentifier(newPatient.getStationId(), newPatient.getDomain());
                        patientOperations.auditToIdModification(newPatient, newPatient.getCorrId(), this.getName(), ADTLINK);
                        continue;
                    }
                    PatientIdentifier updatePids = this.getOneLocalIdsForDomain(correlatedId, this.getName(), d.getName());
                    PatientRecord childRecord = this.createChildPatientRecord(updatePatient, originatingDomain);
                    if (updatePids != null) {
                        childRecord.setCorrId(updatePids.getId());
                        childCorrelatedId = patientOperations.addNewChildPatId(childRecord, d.getName());
                    } else {
                        childCorrelatedId = patientOperations.addNewChildPatId(childRecord, d.getName());
                        childCorrRecord = this.createCorrelatePatientRecord(updatePatient, d.getName());
                        childCorrRecord.setCorrId(newPatient.getCorrId());
                        childCorrRecord.setDomain(childCorrelatedId);
                        childCorrRecord.setStationId(d.getName());
                        patientOperations.addNewCorrPatId(childCorrRecord, this.getName());
                    }
                    patientOperations.auditToIdModification(childRecord, childRecord.getCorrId(), d.getName(), ADTLINK);
                }
            }
        }
        return true;
    }

    @Override
    public boolean doAdtUnlink(PatientRecord toPatient, PatientRecord mrgPatient, String originatingDomain) throws Exception {
        boolean retVal = false;
        boolean correlate = false;
        PatientRecord corrMrgPatient = null;
        PatientRecord corrToPatient = null;
        PatientRecord localPatient = null;
        PatientIdentifier[] pids = null;
        PatientOperationsDomain patientOperations = new PatientOperationsDomain(originatingDomain);
        if (this.parent != null) {
            PatientIdentifier corrMrgId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, mrgPatient.getICN(), this.getName());
            if (corrMrgId == null) {
                IMSException.getIMSException((Throwable)null, null, null, ErrorCode.ADT_015, new String[]{"From Patient does not exist.  Patient ICN = " + mrgPatient.getICN() + "."});
                return retVal;
            }
            mrgPatient.setCorrId(corrMrgId.getId());
            if (mrgPatient.getDomain() == null) {
                pids = patientOperations.getAllLocalIds(corrMrgId, this.getName());
                correlate = true;
            } else {
                PatientIdentifier tmppid = patientOperations.getPossibleCorrId(patientOperations.getNamingEntityPrefix(originatingDomain) + mrgPatient.getStationId(), mrgPatient.getDomain(), originatingDomain);
                if (tmppid != null) {
                    pids = new PatientIdentifier[]{tmppid};
                }
                correlate = true;
            }
            if (toPatient.getICN() == null || toPatient.getICN().equals("\"\"")) {
                for (int i = 0; i < pids.length; ++i) {
                    String newPatientCorrId = patientOperations.createMPIEntry(mrgPatient, originatingDomain);
                    localPatient = new PatientRecord(1, pids[i].getId(), pids[i].getDomain());
                    localPatient.setCorrId(newPatientCorrId);
                    patientOperations.moveLocalPatId(localPatient, originatingDomain);
                    patientOperations.auditToIdModification(mrgPatient, toPatient.getCorrId(), this.getName(), ADTUNLINK);
                }
            } else {
                PatientIdentifier corrToId = patientOperations.getPossibleCorrId(ICN_DATA_DOMAIN, toPatient.getICN(), this.getName());
                if (corrToId == null) {
                    String newPatientCorrId = patientOperations.createMPIEntry(mrgPatient, originatingDomain);
                    toPatient.setCorrId(newPatientCorrId);
                    localPatient = patientOperations.addNewPatient(toPatient, originatingDomain);
                } else {
                    toPatient.setCorrId(corrToId.getId());
                }
                if (pids == null) {
                    patientOperations.addNewLocalPatId(toPatient, this.getName());
                    patientOperations.auditToIdModification(mrgPatient, toPatient.getCorrId(), this.getName(), ADTUNLINK);
                } else {
                    if (pids.length > 1) {
                        return false;
                    }
                    if (!toPatient.getCorrId().equals(pids[0].getId())) {
                        patientOperations.moveLocalPatId(toPatient, this.getName());
                        patientOperations.auditToIdModification(mrgPatient, toPatient.getCorrId(), this.getName(), ADTUNLINK);
                    } else {
                        correlate = false;
                    }
                }
                PatientIdentifier tmppid = patientOperations.getPossibleCorrId(patientOperations.getNamingEntityPrefix(originatingDomain) + toPatient.getStationId(), toPatient.getDomain(), originatingDomain);
                if (tmppid == null) {
                    patientOperations.addNewLocalPatId(toPatient, this.getName());
                    patientOperations.auditToIdModification(toPatient, toPatient.getCorrId(), this.getName(), ADTMOVE);
                }
            }
            if (correlate) {
                corrMrgPatient = this.createCorrelatePatientRecord(mrgPatient, this.getName());
                corrToPatient = this.createCorrelatePatientRecord(toPatient, this.getName());
                this.parent = this.getParent();
                this.parent.doAdtUnlink(corrToPatient, corrMrgPatient, this.getName());
            }
        } else {
            PatientIdentifier corrMrgId = patientOperations.getPossibleCorrId(originatingDomain, mrgPatient.getDomain(), this.getName());
            PatientIdentifier corrToId = patientOperations.getPossibleCorrId(originatingDomain, toPatient.getDomain(), this.getName());
            if (this.children != null && this.children.size() > 0) {
                Iterator iter = this.children.iterator();
                while (iter.hasNext()) {
                    PatientIdentifier[] corrpids = null;
                    AbstractDataDomain d = (AbstractDataDomain)iter.next();
                    if (originatingDomain.equalsIgnoreCase(d.name)) continue;
                    PatientRecord newPatientOtherDomain = null;
                    PatientIdentifier[] corrids = patientOperations.getAllLocalIdsForDomain(corrMrgId, this.getName(), d.getName());
                    if (corrids.length == 0) {
                        IMSException.getIMSException((Throwable)null, null, null, ErrorCode.ADT_015, new String[]{"No Correlated Entry.  Patient ICN = " + mrgPatient.getICN() + ".  Correlated id in x domain = " + corrMrgId.getDomain()});
                    } else {
                        corrpids = patientOperations.getAllLocalIds(corrids[0], d.getName());
                        mrgPatient.setCorrId(corrids[0].getId());
                        for (int i = 0; corrpids != null && i < corrpids.length; ++i) {
                            if (corrToId != null || i != 0) continue;
                            PatientRecord newChildRecord = this.createChildPatientRecord(toPatient, originatingDomain);
                            String childCorrelatedId = patientOperations.addNewChildPatId(newChildRecord, d.getName());
                            newPatientOtherDomain = new PatientRecord(1, childCorrelatedId, d.getName());
                            patientOperations.auditToIdModification(mrgPatient, newChildRecord.getCorrId(), d.getName(), ADTUNLINK);
                        }
                        PatientRecord delPatient = new PatientRecord(1, corrids[0].getId(), d.getName());
                        delPatient.setCorrId(corrMrgId.getId());
                    }
                    if (corrToId == null) {
                        PatientRecord newPatient = patientOperations.addNewCorrelatedPatient(toPatient, this.getName());
                        if (newPatientOtherDomain != null) {
                            newPatientOtherDomain.setCorrId(newPatient.getCorrId());
                            patientOperations.addNewLocalPatId(newPatientOtherDomain, this.getName());
                        }
                    }
                    patientOperations.auditToIdModification(mrgPatient, null, this.getName(), ADTUNLINK);
                }
            }
        }
        return true;
    }

    private PatientRecord createCorrelatePatientRecord(PatientRecord currentPatient, String currentDomain) {
        PatientRecord correlatedPatient = new PatientRecord(currentPatient);
        correlatedPatient.setDomain(currentPatient.getCorrId());
        correlatedPatient.setStationId(currentDomain);
        return correlatedPatient;
    }

    private PatientRecord createChildPatientRecord(PatientRecord currentPatient, String originatingStation) {
        PatientRecord correlatedPatient = new PatientRecord(currentPatient);
        correlatedPatient.setDomain(currentPatient.getICN());
        correlatedPatient.setStationId(originatingStation);
        return correlatedPatient;
    }

    private PatientIdentifier getOneLocalIdsForDomain(PatientIdentifier correlatedId, String currDomain, String childDomain) throws Exception {
        PatientOperationsDomain patientOperations = new PatientOperationsDomain(currDomain);
        PatientIdentifier[] pids = patientOperations.getAllLocalIdsForDomain(correlatedId, currDomain, childDomain);
        if (pids != null && pids.length > 0) {
            return pids[0];
        }
        return null;
    }

    @Override
    public Collection<Object> collectObservations(PatientIdentifier id, final String template, final String rangeStart, final String rangeEnd, final String requestingFacility, final AdapterFactory adapterFactory, final ExceptionList exceptionList) throws Exception {
        Collection<Object> observations;
        PatientDAO patientDAO = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        if (this.parent != null) {
            PatientIdentifier correlatedId = patientDAO.getCorreledId(id, this.getName());
            if (correlatedId == null) {
                throw new PatientNotKnownException();
            }
            observations = this.parent.collectObservations(correlatedId, template, rangeStart, rangeEnd, requestingFacility, adapterFactory, exceptionList);
        } else {
            observations = new ArrayList<Object>();
            if (this.children != null && this.children.size() > 0) {
                Iterator iter = this.children.iterator();
                ArrayList<Thread> threadList = new ArrayList<Thread>();
                PatientIdentifier correlatedId = patientDAO.getCorreledId(id, this.getName());
                if (null == correlatedId) {
                    return observations;
                }
                block2: while (iter.hasNext()) {
                    int i;
                    final CorrelatingDataDomain d = (CorrelatingDataDomain)iter.next();
                    PatientIdentifier[] pids = patientDAO.getLocalIdsForDomain(correlatedId, this.getName(), d.getName());
                    for (i = 0; i < pids.length; ++i) {
                        final PatientIdentifier pid = pids[i];
                        Thread t = new Thread(new Runnable(){

                            public void run() {
                                try {
                                    d.collect(observations, pid, template, rangeStart, rangeEnd, requestingFacility, adapterFactory, exceptionList);
                                }
                                catch (Exception e) {
                                    exceptionList.addCause(e);
                                }
                            }
                        });
                        threadList.add(t);
                        t.start();
                    }
                    for (i = threadList.size() - 1; i >= 0 && threadList.size() != 0; --i) {
                        try {
                            ((Thread)threadList.get(i)).join();
                            continue;
                        }
                        catch (InterruptedException e) {
                            continue block2;
                        }
                    }
                }
            } else {
                PatientIdentifier correlatedId = patientDAO.getCorreledId(id, this.getName());
                if (null != correlatedId) {
                    this.collect(observations, correlatedId, template, rangeStart, rangeEnd, requestingFacility, adapterFactory, exceptionList);
                }
            }
        }
        return observations;
    }

    public static void resetStats() {
        corrCount = 0L;
        patientFound = 0L;
        findPatient = 0L;
    }

    public static void printStats() {
        if (0L < corrCount) {
            System.out.println(new StringBuffer(CorrelatingDataDomain.class.getName()).append("\n\tNumber of messages processed: ").append(corrCount).append("\n\t   Last Time: ").append(0L < lastTime ? df.format(new Date(lastTime)) : "").append("\n\tFound in IMS: ").append(patientFound).append("\n\t Queried MPI: ").append(findPatient).append("\n").toString());
        }
    }
}

