/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.busobj.domain;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainAccessor;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.util.ExceptionList;
import gov.va.med.hds.hdr.transformer.collector.ObservationCollector;
import gov.va.med.hds.hdr.transformer.collector.ObservationCollectorFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDataDomain
implements DataDomain,
DataDomainAccessor {
    protected String name = null;
    protected DataDomain parent = null;
    protected List<DataDomain> children = new ArrayList<DataDomain>();

    public AbstractDataDomain(String name) {
        if (name == null) {
            throw new IllegalArgumentException("Data domain name must not be null or zero-length.");
        }
        this.name = name;
    }

    protected void collect(final Collection<Object> c, PatientIdentifier id, final String template, final String rangeStart, final String rangeEnd, final String requestingFacility, AdapterFactory adapterFactory, final ExceptionList exceptionList) {
        try {
            final ObservationCollector oc = ObservationCollectorFactory.getInstance().createObservationCollector(this.getName(), template, adapterFactory);
            PatientIdentifier[] patientIds = this.resolveIds(id);
            ArrayList<Thread> threadList = new ArrayList<Thread>();
            for (int i = 0; i < patientIds.length; ++i) {
                final PatientIdentifier pid = patientIds[i];
                Thread t = new Thread(new Runnable(){

                    public void run() {
                        try {
                            oc.getObservations(c, pid, template, rangeStart, rangeEnd, requestingFacility);
                        }
                        catch (Exception e) {
                            exceptionList.addCause(e);
                        }
                    }
                });
                threadList.add(t);
                t.start();
            }
            for (int j = threadList.size() - 1; j >= 0 && threadList.size() != 0; --j) {
                try {
                    ((Thread)threadList.get(j)).join();
                    continue;
                }
                catch (InterruptedException e) {
                    break;
                }
            }
        }
        catch (Exception e) {
            throw IMSException.getIMSException(e, null, null, ErrorCode.UNCL_000, new String[]{e.getMessage()});
        }
    }

    @Override
    public void addChild(DataDomain domain) {
        this.children.add(domain);
    }

    @Override
    public DataDomain[] getChildren() {
        return this.children.toArray(new DataDomain[this.children.size()]);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public DataDomain getParent() {
        return this.parent;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public void setParent(DataDomain parent) {
        this.parent = parent;
    }

    public boolean isChild() {
        return this.parent != null;
    }

    public boolean isParent() {
        return this.children.size() > 0;
    }

    public boolean isLeafDomain() {
        return this.children.size() == 0;
    }
}

