/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.systemcontrol;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.ResourceManager;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlEvent;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlListener;
import gov.fhie.transformer.systemcontrol.ServiceManager;
import gov.fhie.transformer.systemcontrol.SupportComponents;
import gov.va.med.hds.hdr.busobj.domain.CorrelatingDataDomain;
import gov.va.med.hds.hdr.common.util.GetArgs;
import gov.va.med.hds.hdr.common.util.StdinProcessor;
import gov.va.med.hds.hdr.nio.server.ServerManager;
import gov.va.med.hds.hdr.transformer.msgloader.HL7TextMessageListener;
import gov.va.med.hds.hdr.transformer.msgloader.oracle.OracleHL7TypedMessageListener;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class Transformer {
    private static boolean verbose = false;
    private static final String NL = System.getProperty("line.separator");
    private static final String version = "1.1.0";
    public static final int DEFAULT_TIMEOUT = 60000;
    public static final String APPLICATION_NAME = "app_name";
    public static final String FRAMEWORK_BUILD_LOG_FILENAME = "build_log.txt";
    public static String ADMIN_QUEUE_NAME = "IMS_ADMIN_MSG_Q";
    public static final String MS_WINDOWS = "Windows";
    public static final String DEFAULT = "default";
    public static Transformer m_transformer;
    protected static final String TRANSFORMER_INIT_SESSION = "transformer";
    private static boolean shutdownInProgress;
    private boolean jmsDrivenShutdown = false;
    private String applicationID;
    private String propFileName = "fhie_properties.xml";
    private String[] domains;
    private Vector<ApplicationCtrlListener> applicationCtrlListeners = new Vector();
    private List<ServiceManager> serviceMgrs;
    private SupportComponents sc;
    private PrintStream outFile = null;
    private PrintStream errFile = null;
    private static final DateFormat dateFormat;
    private Thread shutdownHook = new Thread("Shutdown"){

        public void run() {
            this.setPriority(10);
            System.out.println(Transformer.class.getName() + " initiating shutdown: " + dateFormat.format(Calendar.getInstance().getTime()));
            String tName = "ShutdownServices";
            if (!Transformer.this.jmsDrivenShutdown) {
                new Thread("ShutdownServices"){

                    public void run() {
                        Transformer.this.shutdownSvr(Transformer.this.jmsDrivenShutdown = false);
                    }
                }.start();
            }
            if (null != Transformer.this.outFile) {
                Transformer.this.outFile.flush();
                Transformer.this.outFile.close();
            }
            if (null != Transformer.this.errFile) {
                Transformer.this.errFile.flush();
                Transformer.this.errFile.close();
            }
            Thread[] threads = new Thread[Thread.activeCount()];
            for (int i = 0; i < threads.length; ++i) {
                if (null == threads[i]) continue;
                String threadName = threads[i].getName();
                System.out.println(threadName);
                if (null == threadName || !threadName.equals("ShutdownServices")) continue;
                try {
                    threads[i].join();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                break;
            }
            System.out.println(Transformer.class.getName() + " completed shutdown: " + dateFormat.format(Calendar.getInstance().getTime()));
        }
    };
    private static final String STDIN_PIPE = "log/.transformer.stdin";
    private static final String IMS_MODULE;
    private StdinProcessor stdin = new StdinProcessor("Stdin"){

        protected boolean execute(String cmd) {
            if ("shutdown".equals(cmd.toLowerCase().trim())) {
                Runtime.getRuntime().removeShutdownHook(Transformer.this.shutdownHook);
                Transformer.this.shutdownHook.start();
                try {
                    Transformer.this.shutdownHook.join();
                    System.exit(0);
                }
                catch (InterruptedException e) {}
            } else if ("stats".equals(cmd.toLowerCase().trim())) {
                Runtime rt = Runtime.getRuntime();
                StringBuffer sb = new StringBuffer("\n>>>>>> ").append(IMS_MODULE).append(" Stats " + new Date(System.currentTimeMillis()) + " <<<<<<").append("\nTotal memory: ").append(rt.totalMemory()).append("\n\tMaximum memory: ").append(rt.maxMemory()).append("\n\t   Free memory: ").append(rt.freeMemory()).append("\n");
                System.out.println(sb.toString());
                OracleHL7TypedMessageListener.printStats();
                HL7TextMessageListener.printStats();
                CorrelatingDataDomain.printStats();
            } else if ("reset".equals(cmd.toLowerCase().trim())) {
                OracleHL7TypedMessageListener.resetStats();
                HL7TextMessageListener.resetStats();
                CorrelatingDataDomain.resetStats();
            } else if ("gc".equals(cmd.toLowerCase().trim())) {
                System.gc();
            }
            return super.execute(cmd);
        }
    };

    protected Transformer(String p_file, String app_id) throws Exception {
        this(p_file, app_id, new SupportComponents(p_file, TRANSFORMER_INIT_SESSION, app_id));
    }

    public Transformer(String propertiesFileName, String applicationId, SupportComponents supportCompmponents) throws Exception {
        this.propFileName = propertiesFileName;
        m_transformer = this;
        this.applicationID = applicationId;
        this.sc = supportCompmponents;
        PropertyMgr app_pm = PropertyMgr.getInstance("app_node_key");
        this.domains = this.sc.getDomainList(app_pm);
        String vi = this.getVersionAndBuild();
    }

    public static Transformer getInstance() {
        return m_transformer;
    }

    public static boolean getVerbose() {
        return verbose;
    }

    private static void setVerbose(boolean verbose) {
        Transformer.verbose = verbose;
    }

    protected void initServices() {
        String methodName = "initServices";
        try {
            this.serviceMgrs = new ArrayList<ServiceManager>(this.domains.length);
            for (int i = 0; i < this.domains.length; ++i) {
                ServiceManager svcMgr = new ServiceManager(this.domains[i]);
                this.serviceMgrs.add(svcMgr);
                if (!svcMgr.messageLoadingSvcsAvailable()) continue;
                List loaders = svcMgr.getJMSMessageLoaders();
                Iterator iter = loaders.iterator();
                ApplicationCtrlListener listener = null;
                while (iter.hasNext()) {
                    listener = (ApplicationCtrlListener)iter.next();
                    this.addApplicationCtrlListener(listener);
                    listener.startFileLoading(null);
                }
            }
        }
        catch (Exception ex) {
            IMSException.getIMSException(ex, (CharSequence)ex.getMessage(), null, ErrorCode.CRBA_021, null);
            ex.printStackTrace();
            System.exit(0);
        }
    }

    private void open$In() {
        this.stdin.open$In(STDIN_PIPE);
    }

    protected void initGraphCollectionMgrs() {
    }

    public static boolean isShuttingDown() {
        return shutdownInProgress;
    }

    public synchronized void shutDown() {
        this.jmsDrivenShutdown = true;
        this.shutdownSvr(true);
    }

    protected String[] getDomainsToStart() {
        return this.domains;
    }

    public synchronized void shutdownSvr(boolean fromShutdownHook) {
        String methodName = "shutdownSvr";
        shutdownInProgress = true;
        ApplicationCtrlEvent event = new ApplicationCtrlEvent(this);
        Iterator<Object> iter = this.applicationCtrlListeners.listIterator();
        while (iter.hasNext()) {
            ApplicationCtrlListener listener = (ApplicationCtrlListener)iter.next();
            listener.shutdown(event);
            iter.remove();
        }
        iter = this.serviceMgrs.iterator();
        while (iter.hasNext()) {
            ServiceManager svcMgr = (ServiceManager)iter.next();
            svcMgr.shutdown();
            iter.remove();
        }
    }

    public void startFileLoading(String target) {
        ApplicationCtrlEvent event = new ApplicationCtrlEvent(this, target);
        int size = this.applicationCtrlListeners.size();
        for (int i = 0; i < size; ++i) {
            ApplicationCtrlListener listener = this.applicationCtrlListeners.elementAt(i);
            listener.startFileLoading(event);
        }
    }

    public void stopFileLoading(String target) {
        ApplicationCtrlEvent event = new ApplicationCtrlEvent(this, target);
        int size = this.applicationCtrlListeners.size();
        for (int i = 0; i < size; ++i) {
            ApplicationCtrlListener listener = this.applicationCtrlListeners.elementAt(i);
            listener.stopFileLoading(event);
        }
    }

    public String getVersionAndBuild() {
        return "FHIE Version: 1.1.0" + NL + this.getBuildInfo(FRAMEWORK_BUILD_LOG_FILENAME);
    }

    public String getBuildInfo(String filename) {
        try {
            return ResourceManager.loadFileIntoString(filename);
        }
        catch (IOException ex) {
            return "Cannot find the build information in the distribution.";
        }
    }

    public ServiceManager[] getServiceManagers() {
        return this.serviceMgrs.toArray(new ServiceManager[this.serviceMgrs.size()]);
    }

    public String getApplicationID() {
        return this.applicationID;
    }

    public String getAdminQueue() {
        return ADMIN_QUEUE_NAME;
    }

    public String getVersion() {
        return version;
    }

    public synchronized void addApplicationCtrlListener(ApplicationCtrlListener l) {
        if (this.applicationCtrlListeners.contains(l)) {
            return;
        }
        this.applicationCtrlListeners.addElement(l);
    }

    public synchronized void removeApplicationCtrlListener(ApplicationCtrlListener l) {
        this.applicationCtrlListeners.removeElement(l);
    }

    private Thread getShutdownHook() {
        return this.shutdownHook;
    }

    public void setOutFile(PrintStream outFile) {
        this.outFile = outFile;
    }

    public PrintStream getOutFile() {
        return this.outFile;
    }

    private void setErrFile(PrintStream errFile) {
        this.errFile = errFile;
    }

    private static PrintStream openAlternateIO(String fileName) {
        PrintStream altIO = null;
        try {
            altIO = new PrintStream(new FileOutputStream(fileName));
        }
        catch (Exception e) {
            String cause = null != e.getLocalizedMessage() ? e.getLocalizedMessage() : e.getClass().getName();
            System.err.println(cause + NL + "Unable to open " + fileName + ". Using default stdio instead.");
        }
        return altIO;
    }

    public static void main(String[] args) {
        PrintStream outFile = null;
        PrintStream errFile = null;
        PrintStream stdout = System.out;
        PrintStream stderr = System.err;
        GetArgs getOpts = new GetArgs(Transformer.class, args, "svc_name:app_props:out:err", "verbose", "svc_name");
        String svc_name = getOpts.getArg("svc_name", null);
        Transformer.setVerbose(getOpts.getUnaryOpt("verbose", false));
        stdout.println(Transformer.class.getName() + " initiating startup: " + dateFormat.format(Calendar.getInstance().getTime()));
        if (Transformer.getVerbose()) {
            System.out.println("Using service name = " + svc_name);
        }
        try {
            String applicationProperties = getOpts.hasOpt("app_props") ? getOpts.getArg("app_props") : "fhie_properties.xml";
            Transformer trans = new Transformer(applicationProperties, svc_name);
            Runtime.getRuntime().addShutdownHook(trans.getShutdownHook());
            if (getOpts.hasOpt("out")) {
                outFile = Transformer.openAlternateIO(getOpts.getArg("out"));
                trans.setOutFile(outFile);
            }
            if (getOpts.hasOpt("err")) {
                errFile = Transformer.openAlternateIO(getOpts.getArg("err"));
                trans.setErrFile(errFile);
            }
            if (null != outFile) {
                System.setOut(outFile);
            }
            if (null != errFile) {
                System.setErr(errFile);
            }
            ServerManager acl = ServerManager.getInstance();
            acl.startFileLoading(null);
            trans.addApplicationCtrlListener(acl);
            trans.initServices();
            trans.open$In();
            stdout.println(Transformer.class.getName() + " completed startup: " + dateFormat.format(Calendar.getInstance().getTime()));
        }
        catch (Exception ex) {
            stderr.println("An exception occurred trying to start the transformer.");
            ex.printStackTrace();
            System.exit(1);
        }
    }

    static {
        shutdownInProgress = false;
        dateFormat = new SimpleDateFormat("yyyy.MM.dd HH:mm:ssZ");
        IMS_MODULE = System.getProperty("ims.module", Transformer.class.getName());
    }
}

