/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.systemcontrol;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import java.sql.SQLException;

public class SupportComponents {
    public static final String APP_TYPE_ADMINSERVER = "admin_server";
    public static final String APP_TYPE_MSGHANDLER = "loghandler";
    public static final String APP_TYPE_TRANSFORMER = "transformer";
    public static final String DEFAULT_APP_ID = "tfmr_all_1";
    protected static final String STARTING_DOMAIN_ELEMENT = "domain_to_start";
    private PropertyMgr main_pm;
    private static final String PROPERTY_ROOT = "//properties/node";
    private static final String DOMAIN_ELEMENT = "domain";

    public SupportComponents() throws Exception {
        this.initProperties("fhie_properties.xml", APP_TYPE_TRANSFORMER, DEFAULT_APP_ID);
        this.init();
    }

    public SupportComponents(boolean no_init) throws Exception {
        if (!no_init) {
            this.initProperties("fhie_properties.xml", APP_TYPE_TRANSFORMER, DEFAULT_APP_ID);
            this.init();
        }
    }

    public SupportComponents(String filename, String appType) throws Exception {
        this.initProperties(filename, appType, DEFAULT_APP_ID);
        this.init();
    }

    public SupportComponents(String filename, String app_type, String app_id) throws Exception {
        this.initProperties(filename, app_type, app_id);
        this.init();
    }

    public SupportComponents(String fileName, String applicaitonType, String applicationId, DataSourceManager dataSourceManager) {
        this.initProperties(fileName, applicaitonType, applicationId);
        DataSourceManager.setDataSourceManager(dataSourceManager);
    }

    public SupportComponents(String filename, String app_type, String app_id, boolean init) throws Exception {
        this.initProperties(filename, app_type, app_id);
        if (init) {
            this.init();
        }
    }

    public void init() throws Exception {
        try {
            this.initLogging();
        }
        catch (SQLException ex) {
            throw new Exception("Cannot initialize database connections: " + ex.getLocalizedMessage() + "(" + ex.getErrorCode() + ")");
        }
    }

    public void initProperties(String propFileName, String app_type, String app_id) {
        this.main_pm = new PropertyMgr(propFileName, PROPERTY_ROOT);
        PropertyMgr.addManager("default", this.main_pm);
        PropertyMgr app_pm = null;
        if (app_type != null && app_id != null) {
            String appRoot = "//properties/node/" + app_type + this.main_pm.createAttrSelector("id", app_id);
            app_pm = new PropertyMgr(propFileName, appRoot.toString());
            PropertyMgr.addManager("app_node_key", app_pm);
        }
        if (app_pm != null) {
            String[] dmns = this.getDomainList(app_pm);
            for (int i = 0; i < dmns.length; ++i) {
                StringBuffer buf = new StringBuffer(PROPERTY_ROOT);
                buf.append("/").append(DOMAIN_ELEMENT);
                buf.append(this.main_pm.createAttrSelector("id", dmns[i]));
                PropertyMgr pm2 = new PropertyMgr(propFileName, buf.toString());
                PropertyMgr.addManager(dmns[i], pm2);
            }
        }
    }

    public void initLogging() throws Exception {
        PropertyMgr appPm = PropertyMgr.getInstance("app_node_key");
    }

    public String[] getDomainList(PropertyMgr app_pm) {
        PropertyElement[] pe = app_pm.getProperties(STARTING_DOMAIN_ELEMENT);
        String[] domains = new String[pe.length];
        for (int i = 0; i < pe.length; ++i) {
            domains[i] = pe[i].getValue();
        }
        return domains;
    }
}

