/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.systemcontrol;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.transformer.msgloader.JMSMessageLoader;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ServiceManager {
    protected static final String CAPTIVE_PIDS_SERVICE = "frameworkpids";
    protected static final String HL7_MESSAGELOADING_SERVICE = "messageloader";
    protected static final String USER_SESSION_SERVICE = "usersession";
    protected String[] serviceList = new String[]{"frameworkpids", "usersession", "messageloader"};
    private String domain;
    private boolean fileLoadingSvcs = false;
    private boolean sessionSvcs = false;
    private boolean messageLoadingSvcs = false;
    private List<JMSMessageLoader> jmsMessageLoaders;

    public ServiceManager(String domain) throws Exception {
        this.domain = domain;
        Set st = this.getServices(domain);
        this.createServices(st);
    }

    protected void shutdown() {
    }

    public String getDomain() {
        return this.domain;
    }

    public List getJMSMessageLoaders() {
        return this.jmsMessageLoaders;
    }

    public boolean fileLoadingSvcsAvailable() {
        return this.fileLoadingSvcs;
    }

    public boolean messageLoadingSvcsAvailable() {
        return this.messageLoadingSvcs;
    }

    public boolean userSessionSvcsAvailable() {
        return this.sessionSvcs;
    }

    protected Set getServices(String domain) {
        HashSet<String> s = new HashSet<String>(this.serviceList.length);
        PropertyMgr pm = PropertyMgr.getInstance(domain);
        if (pm != null) {
            for (int i = 0; i < this.serviceList.length; ++i) {
                PropertyElement pe = pm.getProperty(".//" + this.serviceList[i]);
                if (!this.serviceList[i].equalsIgnoreCase(pe.getTagName())) continue;
                s.add(this.serviceList[i]);
            }
        }
        return s;
    }

    protected void createServices(Set services) throws Exception {
        if (services.contains(HL7_MESSAGELOADING_SERVICE)) {
            this.jmsMessageLoaders = new ArrayList<JMSMessageLoader>();
            this.messageLoadingSvcs = true;
            PropertyMgr pm = PropertyMgr.getInstance(this.domain);
            PropertyElement[] msgLoaders = pm.getProperties(HL7_MESSAGELOADING_SERVICE);
            for (int i = 0; i < msgLoaders.length; ++i) {
                this.jmsMessageLoaders.add(new JMSMessageLoader(this.domain, msgLoaders[i].getAttribute("name")));
            }
        }
    }
}

