/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.systemcontrol;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.util.FrameworkControlException;
import gov.va.med.hds.hdr.common.util.FrameworkProcessControl;
import gov.va.med.hds.hdr.common.util.GetArgs;
import gov.va.med.hds.hdr.common.util.IProcessControl;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.TreeSet;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Framework {
    private List<Object> processControls = new ArrayList<Object>();
    private final Hashtable<String, Boolean> debugMap = new Hashtable(3);
    private final PropertyMgr properties;
    private String pid;
    Comparator<PropertyElement> propOrder = new Comparator<PropertyElement>(){

        @Override
        public int compare(PropertyElement x, PropertyElement y) {
            int rslt = 0;
            Integer xOrder = Integer.valueOf(x.getAttribute("order"));
            Integer yOrder = Integer.valueOf(y.getAttribute("order"));
            String xParallelS = x.getAttribute("parallel");
            String yParallelS = y.getAttribute("parallel");
            Integer xParallel = new Integer(null != xParallelS ? (Boolean.valueOf(xParallelS.toLowerCase()).booleanValue() ? 0 : 1) : 0);
            Integer yParallel = new Integer(null != yParallelS ? (Boolean.valueOf(yParallelS.toLowerCase()).booleanValue() ? 0 : 1) : 0);
            rslt = xOrder.compareTo(yOrder);
            if (0 == rslt && 0 == (rslt = xParallel.compareTo(yParallel))) {
                rslt = x.getAttribute("name").compareTo(y.getAttribute("name"));
            }
            return rslt;
        }
    };

    public Framework() {
        try {
            String lhost = InetAddress.getLocalHost().getCanonicalHostName();
        }
        catch (UnknownHostException e) {
            String lhost = "localhost";
        }
        this.properties = new PropertyMgr("/properties/node");
    }

    public String getOSProcessId(String srch) {
        String user = System.getProperty("user.name");
        String grepCmd = "ps -xu " + user;
        try {
            String line;
            Process psu = Runtime.getRuntime().exec(grepCmd);
            BufferedReader processOut = new BufferedReader(new InputStreamReader(psu.getInputStream()));
            Pattern pattern = Pattern.compile("^\\s+(\\d+)\\s+.+" + srch + ".+$");
            while (null != (line = processOut.readLine())) {
                Matcher pid = pattern.matcher(line);
                if (!pid.matches()) continue;
                return pid.group(1);
            }
        }
        catch (Exception e) {
            System.err.print("Unable to determine process id for " + srch + " (" + e.getLocalizedMessage() + ")");
        }
        return null;
    }

    private Object constructor(PropertyElement component, String parentComponent) throws Exception {
        Class<?> clazz = Class.forName(component.getAttribute("name"));
        List<? extends Object>[] args = this.getArguments(component.getChildProperties(), parentComponent);
        List<? extends Object> argType = args[0];
        List<? extends Object> argValue = args[1];
        Constructor<?> control = clazz.getConstructor(argType.toArray(new Class[argType.size()]));
        return control.newInstance(argValue.toArray());
    }

    public Object executeMethods(Object obj, PropertyElement[] methodProperties, String component) throws Exception {
        Process retVal = null;
        if (null != methodProperties && 0 < methodProperties.length) {
            TreeSet<PropertyElement> methods = new TreeSet<PropertyElement>(this.propOrder);
            methods.addAll(Arrays.asList(methodProperties));
            for (PropertyElement methodDef : methods) {
                List<? extends Object>[] methodArgs = this.getArguments(methodDef.getChildProperties(), component);
                List<? extends Object> methodArgTypes = methodArgs[0];
                List<? extends Object> methodArgValues = methodArgs[1];
                Method method = obj.getClass().getMethod(methodDef.getAttribute("name"), methodArgTypes.toArray(new Class[methodArgTypes.size()]));
                retVal = (Process)method.invoke(obj, methodArgValues.toArray());
            }
        }
        return retVal;
    }

    public String shutdownFramework() {
        Vector<PropertyElement> procs = null;
        StringBuffer msg = new StringBuffer("\nTerminated processes:\n\n");
        int count = 0;
        procs = new Vector<PropertyElement>(Arrays.asList(this.properties.getProperties("framework_control/shutdown/component")));
        if (0 < procs.size()) {
            TreeSet<PropertyElement> sortProcs = new TreeSet<PropertyElement>(this.propOrder);
            sortProcs.addAll(procs);
            boolean lastOrder = false;
            ListIterator<PropertyElement> iter = new ArrayList<PropertyElement>(sortProcs).listIterator();
            while (iter.hasNext()) {
                PropertyElement proc = iter.next();
                String name = proc.getAttribute("name");
                this.pid = this.getOSProcessId(name);
                if (null == this.pid) continue;
                try {
                    Object obj = this.constructor(this.properties.getProperty("class", proc), name);
                    if (null == obj) continue;
                    this.executeMethods(obj, this.properties.getProperties("method", proc), name);
                    ++count;
                    msg.append("\n\t" + name + ": " + this.pid);
                }
                catch (Exception e) {
                    System.err.println("Unable to stop process for " + name + " (" + this.pid + "): " + e.getLocalizedMessage());
                }
            }
        }
        return 0 < count ? msg.toString() + "\n" : "\nNothing to shutdown because no framework components are running.\n";
    }

    public String frameworkStatus() {
        StringBuffer msg = new StringBuffer();
        Vector<PropertyElement> procs = null;
        procs = new Vector<PropertyElement>(Arrays.asList(this.properties.getProperties("framework_control/shutdown/component")));
        if (0 < procs.size()) {
            String user = System.getProperty("user.name");
            String grepCmd = "ps -xu " + user;
            try {
                Process psu = Runtime.getRuntime().exec(grepCmd);
                boolean firstTime = true;
                try {
                    int value = psu.exitValue();
                    if (0 == value) {
                        throw new IllegalThreadStateException("Successful completion.");
                    }
                }
                catch (IllegalThreadStateException s) {
                    String line;
                    BufferedReader processOut = new BufferedReader(new InputStreamReader(psu.getInputStream()));
                    StringBuffer srch = new StringBuffer();
                    for (PropertyElement component : procs) {
                        if (0 < srch.length()) {
                            srch.append("|");
                        }
                        srch.append(component.getAttribute("name"));
                    }
                    Pattern pattern = Pattern.compile("^\\s+(\\d+)\\s+.+(" + srch.toString() + ").+$");
                    String firstLine = "";
                    while (null != (line = processOut.readLine())) {
                        Matcher pid = pattern.matcher(line);
                        if (firstTime && 0 == firstLine.length()) {
                            firstLine = line;
                        }
                        if (!pid.matches()) continue;
                        if (firstTime) {
                            firstTime = false;
                            msg.append("\n\n" + firstLine + "\n");
                        }
                        msg.append("\n" + pid.group(2) + " (" + pid.group(1) + ")\n" + line + "\n");
                    }
                }
                if (firstTime) {
                    msg.append("\nNo framework components are running.\n");
                }
            }
            catch (Exception e) {
                System.err.print("Unable to determine framework status (" + e.getLocalizedMessage() + ")");
            }
        }
        return msg.toString();
    }

    public void stopFramework(boolean test) {
        Iterator<Object> iter = this.processControls.iterator();
        while (iter.hasNext()) {
            try {
                ((FrameworkProcessControl)iter.next()).kill();
            }
            catch (ClassCastException classCastException) {}
        }
    }

    private Boolean isDebug(String name, String defaultValue) {
        Boolean debug = null;
        debug = this.debugMap.get(name);
        if (null != debug) {
            return debug;
        }
        if (null != defaultValue && 0 < defaultValue.length() && !"null".equals(defaultValue.toLowerCase())) {
            return Boolean.valueOf(defaultValue.toLowerCase());
        }
        return Boolean.FALSE;
    }

    private Class getPrimitiveClass(String primitiveName, boolean constructor) {
        Object[][] primitives = new Object[][]{{"boolean", Boolean.TYPE, Boolean.class}, {"byte", Byte.TYPE, Byte.class}, {"char", Character.TYPE, Character.class}, {"short", Short.TYPE, Short.class}, {"int", Integer.TYPE, Integer.class}, {"long", Long.TYPE, Long.class}, {"float", Float.TYPE, Float.class}, {"double", Double.TYPE, Double.class}, {"void", Void.TYPE, Void.class}};
        for (int i = 0; i < primitives.length; ++i) {
            if (!primitiveName.equals(primitives[i][0])) continue;
            return (Class)primitives[i][constructor ? 2 : 1];
        }
        return null;
    }

    private void setDebug(String[] debug, List procs) {
        if (null == debug) {
            return;
        }
        Iterator iter = null;
        for (PropertyElement proc : procs) {
            if (!proc.hasAttribute("debug")) continue;
            String debugName = proc.getAttribute("debug").toLowerCase();
            for (int i = 0; i < debug.length; ++i) {
                if (!debugName.equals(debug[i].toLowerCase())) continue;
                this.debugMap.put(proc.getAttribute("name"), Boolean.TRUE);
            }
        }
    }

    private Object getArgValue(Class type, String fieldName, String defaultValue, String parentName) {
        Object value = null;
        if ("debug".equals(fieldName)) {
            value = this.isDebug(parentName, defaultValue);
        } else {
            Class<?> thiz = this.getClass();
            Field field = null;
            try {
                if (null != fieldName) {
                    field = thiz.getDeclaredField(fieldName);
                }
                if (!(null != field && null != (value = field.get(this)) || null == defaultValue || "null".equals(defaultValue))) {
                    value = type.isPrimitive() ? this.getPrimitiveClass(type.getName(), true).getConstructor(String.class).newInstance(defaultValue) : type.getConstructor(String.class).newInstance(defaultValue);
                }
            }
            catch (Exception e) {
                value = null;
            }
        }
        return value;
    }

    private void awaitProcessStart(List processes) throws FrameworkControlException {
        ListIterator iter = processes.listIterator();
        while (iter.hasNext()) {
            IProcessControl proc = (IProcessControl)iter.next();
            if (proc instanceof Thread && ((Thread)((Object)proc)).isAlive()) {
                try {
                    ((Thread)((Object)proc)).join();
                }
                catch (InterruptedException e) {
                    throw new FrameworkControlException(proc.getSymbolicName() + " failed to start.", e);
                }
            }
            if (!proc.isStarted()) {
                throw new FrameworkControlException(proc.getSymbolicName() + " failed to start.");
            }
            iter.remove();
        }
    }

    private List<? extends Object>[] getArguments(PropertyElement[] args, String parentName) throws Exception {
        ArrayList argClass = new ArrayList();
        ArrayList<Object> argValue = new ArrayList<Object>();
        ArrayList[] argAttributes = new ArrayList[]{argClass, argValue};
        if (null != args && 0 < args.length) {
            Arrays.sort(args, this.propOrder);
            for (int j = 0; j < args.length; ++j) {
                String typeAttr = args[j].getAttribute("type");
                Class<?> type = this.getPrimitiveClass(typeAttr, false);
                type = null != type ? type : Class.forName(typeAttr);
                argClass.add(type);
                argValue.add(this.getArgValue(type, args[j].getAttribute("variable"), args[j].getAttribute("value"), parentName));
            }
        }
        return argAttributes;
    }

    public void startFramework(boolean test, String[] debug) throws Exception {
        Vector<PropertyElement> procs = null;
        procs = new Vector<PropertyElement>(Arrays.asList(this.properties.getProperties("framework_control/startup/component[@" + (test ? "test" : "production") + "='true']")));
        if (0 < procs.size()) {
            this.setDebug(debug, procs);
            TreeSet<PropertyElement> startups = new TreeSet<PropertyElement>(this.propOrder);
            startups.addAll(procs);
            ArrayList<IProcessControl> processes = new ArrayList<IProcessControl>();
            int lastOrder = 0;
            for (PropertyElement startup : startups) {
                Object obj;
                String name;
                int order = Integer.parseInt(startup.getAttribute("order"));
                if (order > lastOrder || !Boolean.valueOf(startup.getAttribute("parallel").toLowerCase()).booleanValue()) {
                    this.awaitProcessStart(processes);
                    lastOrder = order;
                }
                if (null != this.getOSProcessId(name = startup.getAttribute("name")) || null == (obj = this.constructor(this.properties.getProperty("class", startup), name))) continue;
                this.executeMethods(obj, this.properties.getProperties("method", startup), name);
                if (obj instanceof IProcessControl) {
                    IProcessControl ipc = (IProcessControl)obj;
                    processes.add(ipc);
                }
                if (!Boolean.valueOf(startup.getAttribute("parallel").toLowerCase()).booleanValue()) {
                    this.awaitProcessStart(processes);
                }
                this.processControls.add(obj);
            }
            this.awaitProcessStart(processes);
        }
    }

    public void setInitialDir(String cwd) {
    }

    public static void usage() {
        System.err.println("\njava gov.fhie.transformer.systemControl.Framework (-start | -shutdown | -status) [-test] [-cwd path] [-help] [-debug transformer[,loghandler]]\n");
        System.err.println("\t-start    - start framework components.\n\t-shutdown - shutdown framework components.\n\t-status   - list the process status of the framework components\n\t-test     - start the test PIDS stub (otherwise connect\n\t            to the live PIDS server.\t-cwd      - initial directory for starting services.  All references\n\t            to files (classpath, etc.) will be from this directory.\n\t-debug    - start the specified component in debug mode\n\t-help     - display this message.\n\n\tOne and only one of start, shutdown, or status must be included.");
        System.exit(1);
    }

    public static void main(String[] args) {
        GetArgs getOpts = new GetArgs(Framework.class, args, "cwd:debug", "(start:shutdown:status):test:help:d");
        Framework frameWork = new Framework();
        String[] debug = null;
        boolean test = false;
        boolean start = true;
        boolean stop = false;
        boolean status = false;
        if (getOpts.getUnaryOpt("d")) {
            System.getProperties().list(System.out);
        }
        if (getOpts.getUnaryOpt("help")) {
            Framework.usage();
        }
        if (getOpts.hasOpt("debug")) {
            debug = getOpts.getArg("debug", "").split(",");
        }
        test = getOpts.getUnaryOpt("test");
        frameWork.setInitialDir(getOpts.getArg("cwd", System.getProperty("user.dir")));
        status = getOpts.getUnaryOpt("status");
        start = getOpts.getUnaryOpt("start");
        stop = getOpts.getUnaryOpt("shutdown");
        try {
            if (status) {
                System.out.println(frameWork.frameworkStatus());
            } else if (start) {
                frameWork.startFramework(test, debug);
            } else if (stop) {
                System.out.println(frameWork.shutdownFramework());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }
}

