/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.supportclasslibraries.loggerlibrary;

import gov.fhie.common.logger.ErrorCode;
import java.io.Serializable;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class IMSException
extends RuntimeException
implements Serializable {
    private static final long serialVersionUID = -5743748698738766520L;
    private static Log logger = LogFactory.getLog(IMSException.class);
    private boolean logged = false;
    private CharSequence imsMessage;
    private String sessionId;
    private final StackTraceElement tos = this.getStackTrace()[1];
    private String[] errorParams = new String[]{this.tos.toString()};
    private ErrorCode error = ErrorCode.UNCL_000;
    private String errorDetails = null;

    private IMSException() {
    }

    private IMSException(String message) {
        super(message);
    }

    private IMSException(String message, Throwable cause) {
        super(message, cause);
    }

    private IMSException(Throwable cause) {
        super(cause);
    }

    public static IMSException getIMSException() {
        IMSException except = new IMSException();
        return except;
    }

    public static IMSException getIMSException(String message) {
        IMSException except = new IMSException(message);
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(Throwable cause) {
        IMSException except = new IMSException(cause);
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, Throwable cause) {
        IMSException except = new IMSException(message, cause);
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(CharSequence imsMessage) {
        IMSException except = new IMSException();
        except.imsMessage = imsMessage;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, CharSequence imsMessage) {
        IMSException except = new IMSException(message);
        except.imsMessage = imsMessage;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(Throwable cause, CharSequence imsMessage) {
        IMSException except = new IMSException(cause);
        except.errorDetails = cause.getCause() != null ? cause.getCause().getMessage() : "No cause associated with exception.";
        except.imsMessage = imsMessage;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, Throwable cause, CharSequence imsMessage) {
        IMSException except = new IMSException(message, cause);
        except.imsMessage = imsMessage;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(CharSequence imsMessage, String sessionId) {
        IMSException except = new IMSException();
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, CharSequence imsMessage, String sessionId) {
        IMSException except = new IMSException(message);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(Throwable cause, CharSequence imsMessage, String sessionId) {
        IMSException except = new IMSException(cause);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, Throwable cause, CharSequence imsMessage, String sessionId) {
        IMSException except = new IMSException(message, cause);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(CharSequence imsMessage, String sessionId, ErrorCode error, String[] params) {
        IMSException except = new IMSException();
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        except.error = error;
        except.errorParams = params;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, CharSequence imsMessage, String sessionId, ErrorCode error, String[] params) {
        IMSException except = new IMSException(message);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        except.error = error;
        except.errorParams = params;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(Throwable cause, CharSequence imsMessage, String sessionId, ErrorCode error, String[] params) {
        IMSException except = new IMSException(cause);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        except.error = error;
        except.errorParams = params;
        logger.error((Object)except);
        return except;
    }

    public static IMSException getIMSException(String message, Throwable cause, CharSequence imsMessage, String sessionId, ErrorCode error, String[] params) {
        IMSException except = new IMSException(message, cause);
        except.imsMessage = imsMessage;
        except.sessionId = sessionId;
        except.error = error;
        except.errorParams = params;
        logger.error((Object)except);
        return except;
    }

    public boolean isLogged() {
        return this.logged;
    }

    public CharSequence getImsMessage() {
        return this.imsMessage;
    }

    public void setImsMessage(CharSequence imsMessage) {
        this.imsMessage = imsMessage;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public ErrorCode getErrorCode() {
        return this.error;
    }

    public boolean hasErrorCode(ErrorCode errorCode) {
        Throwable c = null;
        if (this.error.equals(errorCode)) {
            return true;
        }
        while (null != (c = c.getCause())) {
            if (!(c instanceof IMSException) || !((IMSException)c).getErrorCode().equals(errorCode)) continue;
            return true;
        }
        return false;
    }

    public String getMessage() {
        return this.toString();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (null != this.error) {
            sb.append(this.error.toString());
        }
        if (null != this.sessionId) {
            sb.append("; session ID: ").append(this.sessionId);
        }
        if (null != this.tos) {
            sb.append("; top of stack: ").append(this.tos);
        }
        if (null != this.imsMessage) {
            sb.append("; ims message: ").append(((Object)this.imsMessage).toString());
        }
        return sb.append("\n").toString();
    }

    public boolean equals(Object o) {
        boolean equal = o instanceof Throwable;
        if (equal && !(equal = this == o)) {
            Throwable e = (Throwable)o;
            equal = this.getMessage().equals(e.getMessage());
        }
        return equal;
    }
}

