/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.rimlibrary.AuthorityID;
import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;

public class TimeSpan
extends DomainValue {
    private final String emptyString;
    public String start_time;
    public String stop_time;

    public TimeSpan() {
        this.start_time = this.emptyString = new String();
        this.stop_time = this.emptyString;
    }

    public TimeSpan(String start_time, String stop_time) {
        this.emptyString = new String();
        this.start_time = start_time;
        this.stop_time = stop_time;
    }

    public void print(String indent) {
        if (!this.printAbsent(indent)) {
            System.out.println(new StringBuffer(indent).append("TimeSpan start: ").append(this.start_time).append("  stop: ").append(this.stop_time).toString());
        }
    }

    public String toString() {
        return new StringBuffer("  TimeSpan start: ").append(this.start_time).append("  stop: ").append(this.stop_time).toString();
    }

    public boolean equals(TimeSpan ts) {
        boolean match = false;
        if (ts == null) {
            return false;
        }
        match = super.equals(ts);
        if (match && !(match = this.start_time == ts.start_time && this.stop_time == ts.stop_time) && (match = null != this.start_time && this.start_time.equals(ts.start_time) && null != this.stop_time)) {
            return this.stop_time.equals(ts.stop_time);
        }
        return match;
    }

    public static TimeSpan validateTimeSpan(TimeSpan timeSpan) throws Exception {
        DateTimeUtility.validateISOTime(timeSpan.start_time);
        DateTimeUtility.validateISOTime(timeSpan.stop_time);
        String currTime = DateTimeUtility.getCurrentTime();
        if (timeSpan.start_time.compareTo(timeSpan.stop_time) > 0) {
            throw new Exception("start_time is later than stop time.");
        }
        return new TimeSpan(timeSpan.start_time, timeSpan.stop_time);
    }

    public static void main(String[] args) {
        TimeSpan ts1 = new TimeSpan("20050102094900.325-0700", "20050103094900.325-0700");
        ts1.absent = true;
        ts1.reason = new QualifiedCode(new AuthorityID(1, "Me"), "One");
        TimeSpan ts2 = new TimeSpan();
        ts2.absent = true;
        ts2.reason = new QualifiedCode(new AuthorityID(1, "Me"), "One");
        System.out.println("ts1(" + ts1 + ").equal(ts2)(" + ts2 + "): " + ts1.equals(ts2));
        ts2 = new TimeSpan("20050102094900.325-0700", "20050104094900.325-0700");
        System.out.println("ts1(" + ts1 + ").equal(ts2)(" + ts2 + "): " + ts1.equals(ts2));
        ts2 = new TimeSpan("20050102094900.325-0700", "20050103094900.325-0700");
        ts1.absent = false;
        ts1.reason = null;
        System.out.println("ts1(" + ts1 + ").equal(ts2)(" + ts2 + "): " + ts1.equals(ts2));
        ts2 = ts1;
        System.out.println("ts1(" + ts1 + ").equal(ts2)(" + ts2 + "): " + ts1.equals(ts2));
    }
}

