/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import gov.fhie.transformer.rimlibrary.Ratio;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class RatioMeasurement
extends DomainValue {
    public Ratio value;
    public QualifiedCode relationalOperator;
    public float precision;

    public RatioMeasurement() {
    }

    public RatioMeasurement(Ratio value, QualifiedCode relationalOperator) {
        this.value = value;
        this.relationalOperator = relationalOperator;
    }

    public RatioMeasurement(Ratio value, QualifiedCode relationalOperator, float precision) {
        this.value = value;
        this.relationalOperator = relationalOperator;
        this.precision = precision;
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        if (this.value != null) {
            System.out.print("RatioMeasurement value: ");
            this.value.print("");
        }
        if (this.relationalOperator != null) {
            System.out.print(indent + "relationalOperator: ");
            this.relationalOperator.print("");
        }
        System.out.println(indent + "precision: " + this.precision);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.value != null) {
            sb.append("RatioMeasurement value: " + this.value.toString());
        }
        if (this.relationalOperator != null) {
            sb.append("  relationalOperator: " + this.relationalOperator.toString());
        }
        sb.append("  precision: " + this.precision);
        return sb.toString();
    }

    public boolean equals(RatioMeasurement r) {
        if (r == null) {
            return false;
        }
        if (!super.equals(r)) {
            return false;
        }
        if (this.value == null ? r.value != null : !this.value.equals(r.value)) {
            return false;
        }
        if (this.relationalOperator == null ? r.relationalOperator != null : !this.relationalOperator.equals(r.relationalOperator)) {
            return false;
        }
        return this.precision == r.precision;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

