/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Range
extends DomainValue {
    public QualifiedCode units;
    public float lower;
    public float upper;

    public Range() {
    }

    public Range(QualifiedCode units, float lower, float upper) {
        this.units = units;
        this.lower = lower;
        this.upper = upper;
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        System.out.println(indent + "RangeValue: " + this.lower + " to " + this.upper);
        if (this.units != null) {
            System.out.print(indent + "units: ");
            this.units.print("");
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("  RangeValue: " + this.lower + " to " + this.upper);
        if (this.units != null) {
            sb.append("  units: " + this.units.toString());
        }
        return sb.toString();
    }

    public boolean equals(Range r) {
        if (r == null) {
            return false;
        }
        if (!super.equals(r)) {
            return false;
        }
        if (this.units == null ? r.units != null : !this.units.equals(r.units)) {
            return false;
        }
        if (this.lower != r.lower) {
            return false;
        }
        return this.upper == r.upper;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

