/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.AuthorityID;
import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class PlainText
extends DomainValue {
    public String value = "";
    public QualifiedCode language;

    public PlainText() {
        this.value = "";
        this.language = new QualifiedCode(new AuthorityID(), "");
    }

    public PlainText(String value) {
        this.value = value;
    }

    public PlainText(String value, QualifiedCode language) {
        this.value = value;
        this.language = language;
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        System.out.println(indent + "PlainText: " + this.value);
        if (this.language != null) {
            System.out.print(indent + "language: ");
            this.language.print("");
        }
    }

    public String toString() {
        StringBuffer ptStr = new StringBuffer();
        String indent = "  ";
        ptStr.append(indent + "PlainText: " + this.value);
        if (this.language != null) {
            ptStr.append(indent + "language: ");
            ptStr.append(this.language.toString());
        }
        return ptStr.toString();
    }

    public boolean equals(PlainText pt) {
        if (pt == null) {
            return false;
        }
        if (!super.equals(pt)) {
            return false;
        }
        if (this.value == null ? pt.value != null : !this.value.equals(pt.value)) {
            return false;
        }
        return !(this.language == null ? pt.language != null : !this.language.equals(pt.language));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

