/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.text.MessageFormat;

public class NumericValue
extends DomainValue {
    public Float value = null;
    public QualifiedCode units;

    public NumericValue() {
        this.units = new QualifiedCode();
    }

    public NumericValue(float value) {
        this.value = new Float(value);
    }

    public NumericValue(float value, QualifiedCode units) {
        this.value = new Float(value);
        this.units = units;
    }

    public NumericValue(NumericValue nv) {
        this.value = nv.value;
        if (nv.units != null) {
            this.units = (QualifiedCode)nv.units.clone();
        }
    }

    public Object clone() {
        return new NumericValue(this);
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        System.out.println(indent + "NumericValue: " + this.value.floatValue());
        if (this.units != null) {
            System.out.print(indent + "units: ");
            this.units.print("");
        }
    }

    public String toString() {
        boolean hasUnits = null != this.units;
        String out = "  NumericValue: {0}{1}{2}";
        return MessageFormat.format(out, String.valueOf(this.value.floatValue()), hasUnits ? "  units: " : "", hasUnits ? this.units.toString() : "");
    }

    public boolean equals(NumericValue nv) {
        if (nv == null) {
            return false;
        }
        if (!super.equals(nv)) {
            return false;
        }
        if (!nv.value.equals(this.value)) {
            return false;
        }
        return !(this.units == null ? nv.units != null : !this.units.equals(nv.units));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

