/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.NumericValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class NumericMeasurement
extends DomainValue {
    public NumericValue value;
    public QualifiedCode relationalOperator;
    public float precision;

    public NumericMeasurement() {
    }

    public NumericMeasurement(NumericValue value) {
        this.value = value;
    }

    public NumericMeasurement(NumericValue value, QualifiedCode relationalOperator, float precision) {
        this.value = value;
        this.relationalOperator = relationalOperator;
        this.precision = precision;
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        if (this.value != null) {
            System.out.print("NumericMeasurement value: ");
            this.value.print("");
        }
        if (this.relationalOperator != null) {
            System.out.print(indent + "relationalOperator: ");
            this.relationalOperator.print("");
        }
        System.out.println(indent + "precision: " + this.precision);
    }

    public String toString() {
        StringBuffer nmStr = new StringBuffer();
        String indent = "  ";
        if (this.value != null) {
            nmStr.append("NumericMeasurement value: ");
            nmStr.append(this.value.toString());
        }
        if (this.relationalOperator != null) {
            nmStr.append(indent + "relationalOperator: ");
            nmStr.append(this.relationalOperator.toString());
        }
        nmStr.append(indent + "precision: " + this.precision);
        return nmStr.toString();
    }

    public boolean equals(NumericMeasurement nv) {
        if (nv == null) {
            return false;
        }
        if (!super.equals(nv)) {
            return false;
        }
        if (this.value == null ? nv.value != null : !this.value.equals(nv.value)) {
            return false;
        }
        if (this.relationalOperator == null ? nv.relationalOperator != null : !this.relationalOperator.equals(nv.relationalOperator)) {
            return false;
        }
        return this.precision == nv.precision;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

