/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.AuthorityID;
import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;

public class MediatedCode
extends DomainValue
implements Serializable {
    public QualifiedCode preMediatedValue;
    public String prePreferredText = "";
    public QualifiedCode postMediatedValue;
    public String postPreferredText = "";
    public QualifiedCode mediationFailureType;
    public AuthorityID coding_scheme_id;
    public String version_id;

    public MediatedCode() {
        this.prePreferredText = "";
        this.preMediatedValue = new QualifiedCode();
    }

    public MediatedCode(QualifiedCode preMediatedValue, String prePreferredText) {
        this.preMediatedValue = preMediatedValue;
        this.prePreferredText = prePreferredText;
    }

    public MediatedCode(MediatedCode mc) {
        this.absent = mc.absent;
        if (mc.reason != null) {
            this.reason = (QualifiedCode)mc.reason.clone();
        }
        if (mc.preMediatedValue != null) {
            this.preMediatedValue = (QualifiedCode)mc.preMediatedValue.clone();
        }
        this.prePreferredText = mc.prePreferredText;
        if (mc.postMediatedValue != null) {
            this.postMediatedValue = (QualifiedCode)mc.postMediatedValue.clone();
        }
        this.postPreferredText = mc.postPreferredText;
        if (mc.mediationFailureType != null) {
            this.mediationFailureType = (QualifiedCode)mc.mediationFailureType.clone();
        }
        if (mc.coding_scheme_id != null) {
            this.coding_scheme_id = (AuthorityID)mc.coding_scheme_id.clone();
        }
        this.version_id = mc.version_id;
    }

    public Object clone() {
        return new MediatedCode(this);
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        if (this.preMediatedValue != null) {
            System.out.print(indent + "premediated value: ");
            this.preMediatedValue.print("");
            System.out.println(indent + "prePreferredText: " + this.prePreferredText);
        }
        if (this.postMediatedValue != null) {
            System.out.print(indent + "postmediated value: ");
            this.postMediatedValue.print("");
            System.out.println(indent + "postPreferredText: " + this.postPreferredText);
        }
        if (this.mediationFailureType != null) {
            System.out.print(indent + "failure type: ");
            this.mediationFailureType.print("");
        }
        if (this.coding_scheme_id != null) {
            System.out.print(indent + "coding_scheme_id: ");
            this.coding_scheme_id.print("");
        }
        if (this.version_id != null) {
            System.out.println(indent + "version_id: " + this.version_id);
        }
    }

    public String toString() {
        StringBuffer mediatedCodeStr = new StringBuffer();
        if (this.preMediatedValue != null) {
            mediatedCodeStr.append("  premediated value: ");
            mediatedCodeStr.append(this.preMediatedValue.toString());
            mediatedCodeStr.append("  prePreferredText: " + this.prePreferredText);
        }
        if (this.postMediatedValue != null) {
            mediatedCodeStr.append("  postmediated value: ");
            mediatedCodeStr.append(this.postMediatedValue.toString());
            mediatedCodeStr.append("  postPreferredText: " + this.postPreferredText);
        }
        if (this.mediationFailureType != null) {
            mediatedCodeStr.append("  failure type: ");
            mediatedCodeStr.append(this.mediationFailureType.toString());
        }
        if (this.coding_scheme_id != null) {
            mediatedCodeStr.append("  coding_scheme_id: ");
            mediatedCodeStr.append(this.coding_scheme_id.toString());
        }
        if (this.version_id != null) {
            mediatedCodeStr.append("  version_id: " + this.version_id);
        }
        return mediatedCodeStr.toString();
    }

    public boolean equals(MediatedCode mc) {
        if (mc == null) {
            return false;
        }
        if (!super.equals(mc)) {
            return false;
        }
        if (this.preMediatedValue == null ? mc.preMediatedValue != null : !this.preMediatedValue.equals(mc.preMediatedValue)) {
            return false;
        }
        if (this.prePreferredText == null ? mc.prePreferredText != null : !this.prePreferredText.equals(mc.prePreferredText)) {
            return false;
        }
        if (this.postMediatedValue == null ? mc.postMediatedValue != null : !this.postMediatedValue.equals(mc.postMediatedValue)) {
            return false;
        }
        if (this.postPreferredText == null ? mc.postPreferredText != null : !this.postPreferredText.equals(mc.postPreferredText)) {
            return false;
        }
        if (this.mediationFailureType == null ? mc.mediationFailureType != null : !this.mediationFailureType.equals(mc.mediationFailureType)) {
            return false;
        }
        if (this.coding_scheme_id == null ? mc.coding_scheme_id != null : !this.coding_scheme_id.equals(mc.coding_scheme_id)) {
            return false;
        }
        if (this.version_id == null) {
            return mc.version_id == null;
        }
        return this.version_id.equals(mc.version_id);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

