/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.DomainValue;
import java.lang.reflect.Field;

public class DomainValueHelper {
    public static DomainValue buildDomainValue(String classname) throws Exception {
        Object m_object = null;
        Class<?> m_class = null;
        m_class = Class.forName("gov.fhie.transformer.rimlibrary." + classname);
        m_object = m_class.newInstance();
        return m_object;
    }

    public static boolean setFieldValue(Object dv, String name, String value) throws Exception {
        Class<?> m_class = dv.getClass();
        Field field = null;
        try {
            field = m_class.getField(name);
        }
        catch (NoSuchFieldException ex) {
            // empty catch block
        }
        if (field != null) {
            DomainValueHelper.setField(dv, field, value);
            return true;
        }
        Field[] fields = m_class.getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            Class<?> field_class = fields[i].getType();
            if (field_class.isPrimitive() || field_class == String.class) continue;
            Object field_object = fields[i].get(dv);
            boolean create_object = false;
            if (field_object == null) {
                create_object = true;
                field_object = field_class.newInstance();
            }
            if (DomainValueHelper.setFieldValue(field_object, name, value)) {
                if (create_object) {
                    fields[i].set(dv, field_object);
                }
                return true;
            }
            if (!create_object) continue;
            field_object = null;
        }
        return false;
    }

    public static Object getFieldValue(Object value, String name) throws Exception {
        Field field = value.getClass().getField(name);
        return field.get(value);
    }

    public static void setField(Object _object, Field field, String value) throws Exception {
        Class<?> field_type = field.getType();
        if (field_type == Integer.TYPE) {
            field.setInt(_object, Integer.parseInt(value));
        } else if (field_type == Short.TYPE) {
            field.setShort(_object, Short.parseShort(value));
        } else if (field_type == Long.TYPE) {
            field.setLong(_object, Long.parseLong(value));
        } else if (field_type == Boolean.TYPE) {
            field.setBoolean(_object, Boolean.valueOf(value));
        } else if (field_type == Double.TYPE) {
            field.setDouble(_object, Double.parseDouble(value));
        } else if (field_type == Float.TYPE) {
            field.setFloat(_object, Float.parseFloat(value));
        } else if (field_type == String.class) {
            if (value == null) {
                field.set(_object, "");
            } else {
                field.set(_object, value);
            }
        } else if (field_type == Float.class) {
            field.set(_object, new Float(Float.parseFloat(value)));
        }
    }
}

