/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.AuthorityID;
import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.NumericValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class DateTime
extends DomainValue {
    public String value = "";
    public QualifiedCode relationalOperator;
    public NumericValue accuracy;
    public QualifiedCode accuracyContext;
    public QualifiedCode accuracyUnit;

    public DateTime() {
        this.value = "";
        this.relationalOperator = new QualifiedCode(new AuthorityID(2, ""), "");
    }

    public DateTime(String value) {
        this.value = value;
    }

    public DateTime(String value, QualifiedCode relationalOperator) {
        this.value = value;
        this.relationalOperator = relationalOperator;
    }

    public DateTime(String value, NumericValue accuracy) {
        this.value = value;
        this.accuracy = accuracy;
    }

    public DateTime(DateTime dt) {
        this.absent = dt.absent;
        if (dt.reason != null) {
            this.reason = (QualifiedCode)dt.reason.clone();
        }
        this.value = dt.value;
        if (dt.relationalOperator != null) {
            this.relationalOperator = (QualifiedCode)dt.relationalOperator.clone();
        }
        if (dt.accuracy != null) {
            this.accuracy = (NumericValue)dt.accuracy.clone();
        }
        if (dt.accuracyContext != null) {
            this.accuracyContext = (QualifiedCode)dt.accuracyContext.clone();
        }
        if (dt.accuracyUnit != null) {
            this.accuracyUnit = (QualifiedCode)dt.accuracyUnit.clone();
        }
    }

    public Object clone() {
        return new DateTime(this);
    }

    public void print(String indent) {
        if (this.printAbsent(indent)) {
            return;
        }
        System.out.println(indent + "DateTime: " + this.value);
        if (this.relationalOperator != null) {
            System.out.print(indent + "relationalOperator: ");
            this.relationalOperator.print("");
        }
        if (this.accuracy != null) {
            this.accuracy.print(indent);
        }
        if (this.accuracyContext != null) {
            System.out.print(indent + "accuracyContext: ");
            this.accuracyContext.print("");
        }
        if (this.accuracyUnit != null) {
            System.out.print(indent + "accuracyUnit: ");
            this.accuracyUnit.print("");
        }
    }

    public String toString() {
        StringBuffer dtStr = new StringBuffer();
        dtStr.append("  DateTime: " + this.value);
        if (this.relationalOperator != null) {
            dtStr.append("  relationalOperator: ");
            dtStr.append(this.relationalOperator.toString());
        }
        if (this.accuracy != null) {
            dtStr.append(this.accuracy.toString());
        }
        if (this.accuracyContext != null) {
            dtStr.append("  accuracyContext: ");
            dtStr.append(this.accuracyContext.toString());
        }
        if (this.accuracyUnit != null) {
            dtStr.append("  accuracyUnit: ");
            dtStr.append(this.accuracyUnit.toString());
        }
        return dtStr.toString();
    }

    public boolean equals(DateTime dt) {
        if (dt == null) {
            return false;
        }
        if (!super.equals(dt)) {
            return false;
        }
        if (this.value == null ? dt.value != null : !this.value.equals(dt.value)) {
            return false;
        }
        if (this.relationalOperator == null ? dt.relationalOperator != null : !this.relationalOperator.equals(dt.relationalOperator)) {
            return false;
        }
        if (this.accuracy == null ? dt.accuracy != null : !this.accuracy.equals(dt.accuracy)) {
            return false;
        }
        if (this.accuracyContext == null ? dt.accuracyContext != null : !this.accuracyContext.equals(dt.accuracyContext)) {
            return false;
        }
        return !(this.accuracyUnit == null ? dt.accuracyUnit != null : !this.accuracyUnit.equals(dt.accuracyUnit));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }
}

