/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.rimlibrary;

import gov.fhie.transformer.rimlibrary.AuthorityID;
import gov.fhie.transformer.rimlibrary.DomainValue;
import gov.fhie.transformer.rimlibrary.QualifiedCode;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class Boolean
extends DomainValue {
    public boolean booleanValue;

    public Boolean() {
    }

    public Boolean(boolean booleanValue) {
        this.booleanValue = booleanValue;
    }

    public Boolean(String booleanStr) {
        this.booleanValue = java.lang.Boolean.valueOf(booleanStr);
    }

    public Boolean(Boolean bool) {
        this.absent = bool.absent;
        if (bool.reason != null) {
            this.reason = (QualifiedCode)bool.reason.clone();
        }
        this.booleanValue = bool.booleanValue;
    }

    public Object clone() {
        return new Boolean(this);
    }

    public void print(String indent) {
        if (!this.printAbsent(indent)) {
            System.out.println(indent + "boolean: " + this.booleanValue);
        }
    }

    public String toString() {
        return "  boolean: " + this.booleanValue;
    }

    public boolean equals(Boolean bool) {
        return super.equals(bool) && this.booleanValue == bool.booleanValue;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeBoolean(this.absent);
        out.writeObject(this.reason);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.absent = in.readBoolean();
        this.reason = (QualifiedCode)in.readObject();
    }

    public static void main(String[] args) {
        Boolean bool1 = new Boolean(true);
        bool1.absent = true;
        bool1.reason = new QualifiedCode(new AuthorityID(1, "Me"), "One");
        Boolean bool2 = new Boolean();
        bool2.absent = true;
        bool2.reason = new QualifiedCode(new AuthorityID(1, "Me"), "One");
        System.out.println("bool1(" + bool1 + ").equal(bool2)(" + bool2 + "): " + bool1.equals(bool2));
        bool2 = new Boolean(false);
        System.out.println("bool1(" + bool1 + ").equal(bool2)(" + bool2 + "): " + bool1.equals(bool2));
        bool2 = new Boolean(true);
        System.out.println("bool1(" + bool1 + ").equal(bool2)(" + bool2 + "): " + bool1.equals(bool2));
        bool2 = bool1;
        System.out.println("bool1(" + bool1 + ").equal(bool2)(" + bool2 + "): " + bool1.equals(bool2));
    }
}

