/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7repository;

import gov.va.med.hds.hdr.common.util.SqlUtil;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.text.MessageFormat;
import java.util.StringTokenizer;
import oracle.jdbc.driver.OracleDriver;

public class JunkCharacterCleaner {
    private static final String queryJunkTemplate = "select message,message_control_id,facility_id from {0}hl7_repository where facility_id in (";
    private final String queryJunk = MessageFormat.format("select message,message_control_id,facility_id from {0}hl7_repository where facility_id in (", SqlUtil.getSchemaFor("hl7_plus", "."));

    public void removeRowsContainingJunk(String dbUrl, String[] facilityIds) throws Exception {
        System.out.println("dbUrl = " + dbUrl);
        OracleDriver driver = new OracleDriver();
        DriverManager.registerDriver((Driver)driver);
        Connection conn = DriverManager.getConnection(dbUrl);
        conn.setAutoCommit(false);
        System.out.println("connection established to " + dbUrl);
        StringBuffer selectStr = new StringBuffer(this.queryJunk);
        for (int i = 0; i < facilityIds.length; ++i) {
            selectStr.append(0 < i ? ",?" : "?");
        }
        selectStr.append(")");
        System.out.println(selectStr);
        PreparedStatement prepState = conn.prepareStatement(selectStr.toString());
        for (int i = 0; i < facilityIds.length; ++i) {
            prepState.setString(i + 1, facilityIds[i]);
        }
        ResultSet rs = prepState.executeQuery();
        int count = 0;
        while (rs.next()) {
            String facility = rs.getString("FACILITY_ID");
            System.out.println("facility_id = " + facility);
            String controlId = rs.getString("MESSAGE_CONTROL_ID");
            System.out.println("message_control_id = " + controlId);
            Clob clob = rs.getClob("MESSAGE");
            String msg = clob.getSubString(1L, (int)clob.length());
            boolean containsJunk = this.containsJunkChars(msg);
            if (!containsJunk) continue;
            String delStr = "delete from hl7_repository where message_control_id=? and facility_id=?";
            PreparedStatement delState = conn.prepareStatement(delStr);
            delState.setString(1, controlId);
            delState.setString(2, facility);
            delState.executeUpdate();
            delState.close();
            conn.commit();
            System.out.println(++count + " rows deleted from hl7_repository table");
        }
        rs.close();
        prepState.close();
        conn.close();
        System.out.println("Done cleaning junk characters out of repository for facilities:");
        for (int p = 0; p < facilityIds.length; ++p) {
            System.out.println(facilityIds[p]);
        }
    }

    public boolean containsJunkChars(String msg) {
        boolean result = false;
        char[] junkChars = new char[]{'\u0000', '\u0002'};
        String badStr = new String(junkChars);
        int index = msg.indexOf(badStr);
        if (index != -1) {
            result = true;
        }
        return result;
    }

    public void cleanFile(String fileName) throws Exception {
        String thisLine;
        StringTokenizer strTok = new StringTokenizer(fileName, ".");
        String cleanFileName = strTok.nextToken() + "_clean." + strTok.nextToken();
        System.out.println("cleanFileName = " + cleanFileName);
        PrintStream out = new PrintStream(new FileOutputStream(cleanFileName));
        FileInputStream fin = new FileInputStream(fileName);
        BufferedReader myInput = new BufferedReader(new InputStreamReader(fin));
        while ((thisLine = myInput.readLine()) != null) {
            thisLine = this.cleanString(thisLine);
            out.println(thisLine);
        }
    }

    public String cleanString(String badString) {
        String retString = badString;
        char[] junkChars = new char[]{'\u0000', '\u0002'};
        String badChars = new String(junkChars);
        int index = badString.indexOf(badChars);
        if (index != -1) {
            retString = badString.substring(0, index) + badString.substring(index + 2, badString.length());
        }
        return retString;
    }

    public void removeFileFromRepository(String fileName, String dbUrl) throws Exception {
        String thisLine;
        FileInputStream fin = new FileInputStream(fileName);
        BufferedReader buffy = new BufferedReader(new InputStreamReader(fin));
        System.out.println("dbUrl = " + dbUrl);
        OracleDriver driver = new OracleDriver();
        DriverManager.registerDriver((Driver)driver);
        Connection conn = DriverManager.getConnection(dbUrl);
        conn.setAutoCommit(false);
        System.out.println("connection established to " + dbUrl);
        int count = 0;
        char[] startOfBlockChar = new char[]{'\u000b'};
        String startOfBlockStr = new String(startOfBlockChar);
        while ((thisLine = buffy.readLine()) != null) {
            int i;
            if (thisLine.indexOf(startOfBlockStr) == -1) continue;
            thisLine = thisLine.substring(1, thisLine.length());
            int lastChar = 120;
            String tokenizableLine = "";
            for (int j = 0; j < thisLine.length(); ++j) {
                char currentChar = thisLine.charAt(j);
                if (currentChar == '^' && lastChar == 94) {
                    tokenizableLine = tokenizableLine + " ";
                }
                tokenizableLine = tokenizableLine + currentChar;
                lastChar = currentChar;
            }
            StringTokenizer mshTok = new StringTokenizer(tokenizableLine, "^");
            String facilityId = "";
            String messageControlId = "";
            for (i = 0; i < 4; ++i) {
                facilityId = mshTok.nextToken();
            }
            for (i = 0; i < 6; ++i) {
                messageControlId = mshTok.nextToken();
            }
            System.out.println("facilityId = " + facilityId);
            System.out.println("messageControlId = " + messageControlId);
            String delStr = "delete from hl7_repository where message_control_id=? and facility_id=?";
            System.out.println(delStr);
            PreparedStatement delState = conn.prepareStatement(delStr);
            delState.setString(1, messageControlId);
            delState.setString(2, facilityId);
            delState.executeUpdate();
            delState.close();
            conn.commit();
            System.out.println(++count + " rows have been removed from the hl7_repository table");
        }
        System.out.println("All messages from file " + fileName + " have been removed from the hl7_repository table");
    }
}

