/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7repository;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.fhie.transformer.hl7adapters.hl7repository.HL7RepositoryException;
import gov.fhie.transformer.hl7adapters.hl7repository.InvalidPidException;
import gov.fhie.transformer.hl7adapters.hl7repository.InvalidTimeException;
import gov.fhie.transformer.rimlibrary.QualifiedPersonID;
import gov.fhie.transformer.rimlibrary.TimeSpan;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegmentFactory;
import gov.va.med.hds.hdr.transformer.hl7.model.PidSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.PidSegmentFactory;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7Message;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7MessageImpl;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.StringArrayMessageMetaData;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentMessageMetaData;
import java.io.IOException;
import java.io.Writer;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.Vector;
import oracle.sql.CLOB;
import org.dom4j.Document;

public class HL7RepositoryWrapper {
    private final String schemaHL7_PLUS = SqlUtil.getSchemaFor("hl7_plus", ".");
    private static final String indexHintTemplate = "/*+index({0}hl7_repository.ind_local_pid)*/";
    private final String indexHint;
    private static final String queryExistingTemplate = "select message_control_id, message_date_time from {0}hl7_repository where clinical_id=? and active=''Y''";
    private final String queryExisting;
    private static final String queryBySendingAppTemplate = "select {1} facility_id, clinical_id, message_control_id, message from {0}hl7_repository where active=''Y'' and (";
    private final String queryBySendingApp;
    private static final String queryByMessageTypeTemplate = "select local_pid, pid_domain, sending_application, facility_id, message_date_time, message_ty, message_control_id, hl7_version, clinical_id, latest_clinical_date, message from {0}hl7_repository where local_pid=? and pid_domain=? and active=''Y'' and message_ty in (";
    private final String queryByMessageType;
    private static final String queryPointForwardTemplate = "select local_pid, pid_domain, sending_application, facility_id, message_date_time, message_ty, message_control_id, hl7_version, message, clinical_id, latest_clinical_date from {0}hl7_repository where local_pid=? and pid_domain=? and active=''Y'' and (latest_clinical_date is null or latest_clinical_date>=?) and message_ty in (";
    private final String queryPointForward;
    private static final String queryInTimespanTemplate = "select local_pid, pid_domain, sending_application, facility_id, message_date_time, message_ty, message_control_id, hl7_version, message, clinical_id, latest_clinical_date from hl7_repository where local_pid=? and pid_domain=? and active=''Y'' and (latest_clinical_date is null or (latest_clinical_date>=? and latest_clinical_date<?)) and message_ty in (";
    private final String queryInTimespan;
    private static final String queryEncounterTemplate = "select {1} facility_id, message_control_id,message from {0}hl7_repository where active=''Y'' and local_pid=? and pid_domain=? and message_ty =''ADT\\A08'' and message_insertion_time>=? and message_insertion_time<?";
    private final String queryEncounter;
    private static final String insertNewMessageTemplate = "insert into {0}hl7_repository (local_pid,pid_domain,sending_application,facility_id,message_date_time,message_ty,message_control_id,hl7_version,message_insertion_time,latest_clinical_date,clinical_id,original,active,file_name,message) values (?,?,?,?,?,?,?,?,?,?,?,?,?,?,empty_clob())";
    private final String insertNewMessage;
    private static final String queryForClobUpdateTemplate = "select message from {0}hl7_repository where facility_id = ? and message_control_id = ? for update";
    private final String queryForClobUpdate;
    private static final String updateMessageActiveStatusTemplate = "update {0}hl7_repository set active = ''N'' where clinical_id=? and facility_id=? and active=''Y''";
    private final String updateMessageActiveStatus;
    private static final String XP_TEMPLATE_MSGTYPE = "transformer/mapping-type-codes/mapping-type-code[@template='TEMPLATE_NAME']";
    private static final String XP_CLINICAL_DATA_TEMPLATE = "transformer/clinical-data-templates/template[@message-type='MESSAGE_TYPE']/@template-name";
    private Connection conn;
    private Statement stmt;
    private PreparedStatement prepStmt;
    private ResultSet theResultSet;
    public static final char lineDelimiter = '\r';
    private static final String TIMEZONE_ID = "GMT";
    private String domain;
    private HL7MessageInfoImpl messageInfo = null;

    public HL7RepositoryWrapper(String domain) {
        this.domain = domain;
        this.indexHint = MessageFormat.format(indexHintTemplate, this.schemaHL7_PLUS);
        this.queryExisting = MessageFormat.format(queryExistingTemplate, this.schemaHL7_PLUS);
        this.queryBySendingApp = MessageFormat.format(queryBySendingAppTemplate, this.schemaHL7_PLUS, this.indexHint);
        this.queryByMessageType = MessageFormat.format(queryByMessageTypeTemplate, this.schemaHL7_PLUS);
        this.queryPointForward = MessageFormat.format(queryPointForwardTemplate, this.schemaHL7_PLUS);
        this.queryInTimespan = MessageFormat.format(queryInTimespanTemplate, this.schemaHL7_PLUS);
        this.queryEncounter = MessageFormat.format(queryEncounterTemplate, this.schemaHL7_PLUS, this.indexHint);
        this.insertNewMessage = MessageFormat.format(insertNewMessageTemplate, this.schemaHL7_PLUS);
        this.queryForClobUpdate = MessageFormat.format(queryForClobUpdateTemplate, this.schemaHL7_PLUS);
        this.updateMessageActiveStatus = MessageFormat.format(updateMessageActiveStatusTemplate, this.schemaHL7_PLUS);
    }

    public void saveMessage(String rawMsg, MessageMetaData metaData, String fileName) throws HL7RepositoryException {
        long startTime = System.currentTimeMillis();
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String clinicalId = metaData.getClinicalId();
            String facilityId = metaData.getFacilityId();
            if (clinicalId == null || clinicalId.length() == 0 || facilityId == null || facilityId.length() == 0) {
                throw new HL7RepositoryException("Not enough meta-data available in message. Clincial ID and Facility ID must be available to store the message in the HL7 Repository.");
            }
            conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            conn.setAutoCommit(false);
            pstmt = conn.prepareStatement(this.queryExisting);
            pstmt.setString(1, clinicalId);
            rs = pstmt.executeQuery();
            String activeFlag = "Y";
            String original = "Y";
            String currentMessageDateTime = null;
            if (rs.next()) {
                currentMessageDateTime = rs.getString("MESSAGE_DATE_TIME");
                if (currentMessageDateTime.compareTo(metaData.getMessageDateTime()) <= 0) {
                    this.setInactive(conn, clinicalId, facilityId);
                } else {
                    activeFlag = "N";
                }
                original = "N";
            }
            this.storeMessage(conn, rawMsg, metaData, fileName, activeFlag, original);
            conn.commit();
        }
        catch (Exception except) {
            try {
                if (conn != null) {
                    conn.rollback();
                }
            }
            catch (SQLException sqle) {
                // empty catch block
            }
            HL7RepositoryException repEx = new HL7RepositoryException("An error was encountered while saving the message.", except);
            if (except instanceof SQLException && 1 == ((SQLException)except).getErrorCode()) {
                throw IMSException.getIMSException(repEx, (CharSequence)except.getLocalizedMessage(), null, ErrorCode.JDBC_031, new String[]{rawMsg});
            }
            throw IMSException.getIMSException(repEx, (CharSequence)rawMsg);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeMessage(Connection conn, String rawMessage, MessageMetaData metaData, String fileName, String activeFlag, String original) throws SQLException, IOException {
        block24: {
            PropertyMgr pm = PropertyMgr.getInstance(this.domain);
            String namingEntityPrefix = pm.getProperty("naming_entity_prefix").getValue();
            PreparedStatement pstmtInsert = null;
            Statement pstmtUpdateMessage = null;
            ResultSet rsUpdateMessage = null;
            Writer out = null;
            try {
                pstmtInsert = conn.prepareStatement(this.insertNewMessage);
                SqlUtil.setPreparedStatmentString(pstmtInsert, 1, metaData.getLocalId());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 2, namingEntityPrefix + metaData.getPidDomain());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 3, metaData.getSendingApplication());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 4, metaData.getFacilityId());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 5, metaData.getMessageDateTime());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 6, metaData.getMessageType());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 7, metaData.getMessageControlId());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 8, metaData.getVersion());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 9, System.currentTimeMillis() + "");
                SqlUtil.setPreparedStatementTimestamp(pstmtInsert, 10, metaData.getClinicallyRelevantDate());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 11, metaData.getClinicalId());
                SqlUtil.setPreparedStatmentString(pstmtInsert, 12, original);
                SqlUtil.setPreparedStatmentString(pstmtInsert, 13, activeFlag);
                SqlUtil.setPreparedStatmentString(pstmtInsert, 14, fileName);
                pstmtInsert.execute();
                pstmtUpdateMessage = conn.prepareStatement(this.queryForClobUpdate);
                SqlUtil.setPreparedStatmentString((PreparedStatement)pstmtUpdateMessage, 1, metaData.getFacilityId());
                SqlUtil.setPreparedStatmentString((PreparedStatement)pstmtUpdateMessage, 2, metaData.getMessageControlId());
                rsUpdateMessage = pstmtUpdateMessage.executeQuery();
                if (rsUpdateMessage.next()) {
                    Clob message = (Clob)rsUpdateMessage.getObject("MESSAGE");
                    out = message.setCharacterStream(0L);
                    out.write(rawMessage);
                    out.flush();
                    break block24;
                }
                throw IMSException.getIMSException((CharSequence)"Unable to find row storing CLOB.", "HL7RepositoryWrapper::storeMessage", ErrorCode.JDBC_025, new String[]{metaData.getFacilityId(), metaData.getMessageControlId(), rawMessage});
            }
            finally {
                if (out != null) {
                    try {
                        out.close();
                    }
                    catch (IOException ioe) {}
                }
                if (rsUpdateMessage != null) {
                    try {
                        rsUpdateMessage.close();
                    }
                    catch (SQLException sqle) {}
                }
                if (pstmtUpdateMessage != null) {
                    try {
                        pstmtUpdateMessage.close();
                    }
                    catch (SQLException sqle) {}
                }
                if (pstmtInsert != null) {
                    try {
                        pstmtInsert.close();
                    }
                    catch (SQLException sqle) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setInactive(Connection conn, String clinicalId, String facilityId) throws SQLException {
        PreparedStatement pstmtUpdate = null;
        try {
            pstmtUpdate = conn.prepareStatement(this.updateMessageActiveStatus);
            SqlUtil.setPreparedStatmentString(pstmtUpdate, 1, clinicalId);
            SqlUtil.setPreparedStatmentString(pstmtUpdate, 2, facilityId);
            pstmtUpdate.executeUpdate();
        }
        finally {
            if (pstmtUpdate != null) {
                pstmtUpdate.close();
            }
        }
    }

    public void saveMessage(String rawMsg, String fileName) throws HL7RepositoryException {
        String[] dbdata = this.parseMessage(rawMsg);
        StringArrayMessageMetaData metaData = new StringArrayMessageMetaData(dbdata);
        this.saveMessage(rawMsg, metaData, fileName);
    }

    public void getSelected(QualifiedPersonID[] pids, TimeSpan time, String[] sendingApp) throws HL7RepositoryException, InvalidTimeException, InvalidPidException {
        StringBuffer sb = new StringBuffer();
        long startTime = 0L;
        long stopTime = 0L;
        try {
            startTime = DateTimeUtility.getMilliSecond(time.start_time);
            stopTime = DateTimeUtility.getMilliSecond(time.stop_time);
        }
        catch (Exception ite) {
            throw new InvalidTimeException(ite.getMessage());
        }
        sb = new StringBuffer(this.queryBySendingApp);
        for (int i = 0; i < pids.length; ++i) {
            sb.append((0 < i ? " or " : "") + "(local_pid=? and pid_domain=?)");
        }
        sb.append(") and message_insertion_time>=? and message_insertion_time<? ");
        if (sendingApp != null) {
            sb.append(" and sending_application in (").append(SqlUtil.fillParams(sendingApp.length)).append(") ");
        } else {
            sb.append("and sending_application!='ADT' and sending_application!='LABBB' ");
        }
        try {
            if (this.conn == null) {
                this.conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            }
            this.prepStmt = this.conn.prepareStatement(sb.toString());
            int col = 1;
            int i = 0;
            while (i < pids.length) {
                this.prepStmt.setString(col, pids[i].id);
                this.prepStmt.setString(col + 1, pids[i].domain.naming_entity);
                ++i;
                col += 2;
            }
            this.prepStmt.setLong(col++, startTime);
            this.prepStmt.setLong(col++, stopTime);
            i = 0;
            while (i < sendingApp.length) {
                this.prepStmt.setString(col, sendingApp[i]);
                ++i;
                ++col;
            }
        }
        catch (Exception e) {
            this.done();
            throw new HL7RepositoryException("Can't get connection " + e);
        }
        try {
            this.theResultSet = this.prepStmt.executeQuery();
        }
        catch (Exception e) {
            this.done();
            throw new HL7RepositoryException("Can't get theResultSet " + e);
        }
    }

    public HL7Message[] getMessages(String templateName, PatientIdentifier pid) throws HL7RepositoryException {
        Vector<HL7MessageImpl> vMessages = new Vector<HL7MessageImpl>();
        HL7MessageImpl message = null;
        StringBuffer sbQuery = new StringBuffer(this.queryByMessageType);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xPath = XP_TEMPLATE_MSGTYPE.replaceFirst("TEMPLATE_NAME", templateName);
        PropertyElement[] pes = pm.getProperties(xPath);
        sbQuery.append(SqlUtil.fillParams(pes.length) + ")");
        try {
            if (this.conn == null) {
                this.conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            }
            this.prepStmt = this.conn.prepareStatement(sbQuery.toString());
            this.prepStmt.setString(1, pid.getId());
            this.prepStmt.setString(2, pid.getDomain());
            for (int i = 0; i < pes.length; ++i) {
                this.prepStmt.setString(i + 3, pes[i].getAttribute("message-type"));
            }
            this.theResultSet = this.prepStmt.executeQuery();
            while (this.theResultSet.next()) {
                CLOB oracleClob = (CLOB)this.theResultSet.getObject("MESSAGE");
                if (oracleClob == null) continue;
                message = new HL7MessageImpl();
                message.setLocalPid(this.theResultSet.getString("LOCAL_PID"));
                message.setPidDomain(this.theResultSet.getString("PID_DOMAIN"));
                message.setSendingApplication(this.theResultSet.getString("SENDING_APPLICATION"));
                message.setFacilityId(this.theResultSet.getString("FACILITY_ID"));
                message.setMessageDateTime(this.theResultSet.getString("MESSAGE_DATE_TIME"));
                message.setMessageType(this.theResultSet.getString("MESSAGE_TY"));
                message.setMessageControlId(this.theResultSet.getString("MESSAGE_CONTROL_ID"));
                message.setHl7Version(this.theResultSet.getString("HL7_VERSION"));
                message.setMessage(oracleClob.getSubString(1L, (int)oracleClob.length()));
                message.setClinicalId(this.theResultSet.getString("CLINICAL_ID"));
                message.setClinicallyRelevantDate(this.theResultSet.getTimestamp("LATEST_CLINICAL_DATE", Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID))));
                vMessages.add(message);
            }
        }
        catch (Exception e) {
            throw new HL7RepositoryException("An error occurred while looking up messages from HL7 repository.\n\tMessage: " + e.getMessage());
        }
        finally {
            this.done();
        }
        return vMessages.toArray(new HL7MessageImpl[vMessages.size()]);
    }

    public HL7Message[] getMessagesPointForward(String templateName, PatientIdentifier pid, String point) throws HL7RepositoryException {
        Vector<HL7MessageImpl> vMessages = new Vector<HL7MessageImpl>();
        HL7MessageImpl message = null;
        StringBuffer sbQuery = new StringBuffer(this.queryPointForward);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xPath = XP_TEMPLATE_MSGTYPE.replaceFirst("TEMPLATE_NAME", templateName);
        PropertyElement[] pes = pm.getProperties(xPath);
        sbQuery.append(SqlUtil.fillParams(pes.length) + ")");
        try {
            if (this.conn == null) {
                this.conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            }
            this.prepStmt = this.conn.prepareStatement(sbQuery.toString());
            Timestamp clinicalDate = new Timestamp(DateTimeUtility.getMilliSecond(point));
            this.prepStmt.setString(1, pid.getId());
            this.prepStmt.setString(2, pid.getDomain());
            this.prepStmt.setTimestamp(3, clinicalDate, Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID)));
            for (int i = 0; i < pes.length; ++i) {
                this.prepStmt.setString(i + 4, pes[i].getAttribute("message-type"));
            }
            this.theResultSet = this.prepStmt.executeQuery();
            while (this.theResultSet.next()) {
                CLOB oracleClob = (CLOB)this.theResultSet.getObject("MESSAGE");
                if (oracleClob == null) continue;
                message = new HL7MessageImpl();
                message.setLocalPid(this.theResultSet.getString("LOCAL_PID"));
                message.setPidDomain(this.theResultSet.getString("PID_DOMAIN"));
                message.setSendingApplication(this.theResultSet.getString("SENDING_APPLICATION"));
                message.setFacilityId(this.theResultSet.getString("FACILITY_ID"));
                message.setMessageDateTime(this.theResultSet.getString("MESSAGE_DATE_TIME"));
                message.setMessageType(this.theResultSet.getString("MESSAGE_TY"));
                message.setMessageControlId(this.theResultSet.getString("MESSAGE_CONTROL_ID"));
                message.setHl7Version(this.theResultSet.getString("HL7_VERSION"));
                message.setMessage(oracleClob.getSubString(1L, (int)oracleClob.length()));
                message.setClinicalId(this.theResultSet.getString("CLINICAL_ID"));
                message.setClinicallyRelevantDate(this.theResultSet.getTimestamp("LATEST_CLINICAL_DATE", Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID))));
                vMessages.add(message);
            }
        }
        catch (Exception e) {
            throw new HL7RepositoryException("An error occurred while looking up messages from HL7 repository.\n\tMessage: " + e.getMessage());
        }
        finally {
            this.done();
        }
        return vMessages.toArray(new HL7MessageImpl[vMessages.size()]);
    }

    public HL7Message[] getMessagesInTimeSpan(String templateName, PatientIdentifier pid, TimeSpan timeSpan) throws HL7RepositoryException {
        Vector<HL7MessageImpl> vMessages = new Vector<HL7MessageImpl>();
        HL7MessageImpl message = null;
        StringBuffer sbQuery = new StringBuffer(this.queryInTimespan);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xPath = XP_TEMPLATE_MSGTYPE.replaceFirst("TEMPLATE_NAME", templateName);
        PropertyElement[] pes = pm.getProperties(xPath);
        sbQuery.append(SqlUtil.fillParams(pes.length) + ")");
        try {
            if (this.conn == null) {
                this.conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            }
            this.prepStmt = this.conn.prepareStatement(sbQuery.toString());
            Timestamp start_time = new Timestamp(DateTimeUtility.getMilliSecond(timeSpan.start_time));
            Timestamp stop_time = new Timestamp(DateTimeUtility.getMilliSecond(timeSpan.stop_time));
            this.prepStmt.setString(1, pid.getId());
            this.prepStmt.setString(2, pid.getDomain());
            this.prepStmt.setTimestamp(3, start_time, Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID)));
            this.prepStmt.setTimestamp(4, stop_time, Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID)));
            for (int i = 0; i < pes.length; ++i) {
                this.prepStmt.setString(i + 5, pes[i].getAttribute("message-type"));
            }
            this.theResultSet = this.prepStmt.executeQuery();
            while (this.theResultSet.next()) {
                CLOB oracleClob = (CLOB)this.theResultSet.getObject("MESSAGE");
                if (oracleClob == null) continue;
                message = new HL7MessageImpl();
                message.setLocalPid(this.theResultSet.getString("LOCAL_PID"));
                message.setPidDomain(this.theResultSet.getString("PID_DOMAIN"));
                message.setSendingApplication(this.theResultSet.getString("SENDING_APPLICATION"));
                message.setFacilityId(this.theResultSet.getString("FACILITY_ID"));
                message.setMessageDateTime(this.theResultSet.getString("MESSAGE_DATE_TIME"));
                message.setMessageType(this.theResultSet.getString("MESSAGE_TY"));
                message.setMessageControlId(this.theResultSet.getString("MESSAGE_CONTROL_ID"));
                message.setHl7Version(this.theResultSet.getString("HL7_VERSION"));
                message.setMessage(oracleClob.getSubString(1L, (int)oracleClob.length()));
                message.setClinicalId(this.theResultSet.getString("CLINICAL_ID"));
                message.setClinicallyRelevantDate(this.theResultSet.getTimestamp("LATEST_CLINICAL_DATE", Calendar.getInstance(TimeZone.getTimeZone(TIMEZONE_ID))));
                vMessages.add(message);
            }
        }
        catch (Exception e) {
            throw new HL7RepositoryException("An error occurred while looking up messages from HL7 repository.\n\tMessage: " + e.getMessage());
        }
        finally {
            this.done();
        }
        return vMessages.toArray(new HL7MessageImpl[vMessages.size()]);
    }

    public Vector getEncounter(QualifiedPersonID pid, TimeSpan time) throws HL7RepositoryException, InvalidTimeException, InvalidPidException {
        long startTime = 0L;
        long stopTime = 0L;
        String localPid = null;
        String pidDomain = null;
        try {
            startTime = DateTimeUtility.getMilliSecond(time.start_time);
            stopTime = DateTimeUtility.getMilliSecond(time.stop_time);
        }
        catch (Exception ite) {
            throw new InvalidTimeException(ite.getMessage());
        }
        String[] result = null;
        Vector<String[]> resultVec = new Vector<String[]>();
        try {
            if (this.conn == null) {
                this.conn = DataSourceManager.getInstance().getDataSource(this.domain).getConnection();
            }
        }
        catch (Exception e) {
            this.done();
            throw new HL7RepositoryException("No connection from HL7Repository " + e);
        }
        try {
            this.prepStmt = this.conn.prepareStatement(this.queryEncounter);
            this.prepStmt.setString(1, pid.id);
            this.prepStmt.setString(2, pid.domain.naming_entity);
            this.prepStmt.setLong(3, startTime);
            this.prepStmt.setLong(4, stopTime);
            this.theResultSet = this.prepStmt.executeQuery();
            CLOB oracleClob = null;
            while (this.theResultSet.next()) {
                result = new String[4];
                result[0] = this.theResultSet.getString("FACILITY_ID");
                result[2] = this.theResultSet.getString("MESSAGE_CONTROL_ID");
                oracleClob = (CLOB)this.theResultSet.getObject("MESSAGE");
                if (oracleClob == null) continue;
                result[3] = oracleClob.getSubString(1L, (int)oracleClob.length());
                result[1] = localPid + "|" + pidDomain;
                resultVec.add(result);
            }
        }
        catch (SQLException sqle) {
            this.done();
            throw new HL7RepositoryException("SQLException when getEncounter " + sqle);
        }
        this.done();
        return resultVec;
    }

    public void done() {
        try {
            if (this.theResultSet != null) {
                this.theResultSet.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.prepStmt != null) {
                this.prepStmt.close();
            }
            if (this.conn != null) {
                this.conn.close();
                this.conn = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public String[] parseMessage(String rawMsg) {
        this.messageInfo = new HL7MessageInfoImpl(rawMsg);
        String delimiter = "\r";
        StringTokenizer st = new StringTokenizer(rawMsg, delimiter);
        String[] mshPid = new String[2];
        while (st.hasMoreTokens()) {
            String nextSegment = st.nextToken();
            if (nextSegment.startsWith("MSH")) {
                mshPid[0] = nextSegment;
                continue;
            }
            if (!nextSegment.startsWith("PID")) continue;
            mshPid[1] = nextSegment;
            break;
        }
        if (mshPid[0] == null || mshPid[0].equals("")) {
            throw IMSException.getIMSException("MSH is null", (CharSequence)rawMsg, null);
        }
        String[] mshFields = this.parseMSH(mshPid[0]);
        MshSegment mshSegment = MshSegmentFactory.createSegment(mshFields, (HL7MessageInfo)this.messageInfo);
        if (mshPid[1] == null || mshPid[1].equals("")) {
            throw IMSException.getIMSException("MSH is null", (CharSequence)rawMsg, null);
        }
        String[] pid3 = null;
        PropertyMgr pmgr = PropertyMgr.getInstance(this.domain);
        String namingEntityPrefix = pmgr.getProperty("naming_entity_prefix").getValue();
        String fieldDelimeter = HL7MessageInfoImpl.getFieldDelimeter((String)rawMsg);
        String componentSeparator = HL7MessageInfoImpl.getComponentSeparator((String)rawMsg);
        pid3 = this.getLocalPid(mshPid[1], fieldDelimeter, componentSeparator);
        String[] dbData = new String[11];
        dbData[0] = pid3[0];
        dbData[1] = namingEntityPrefix + pid3[1].toUpperCase();
        dbData[2] = mshSegment.getSendingApplicationNamespaceId();
        dbData[3] = mshSegment.getSendingFacilityUniversalId();
        dbData[4] = mshSegment.getDateTimeOfMessage();
        dbData[6] = mshSegment.getMessageControlId();
        dbData[7] = mshSegment.getVersionId();
        dbData[8] = System.currentTimeMillis() + "";
        try {
            ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(rawMsg);
            String messageType = resultAdapter.getMessageType(rawMsg);
            PropertyMgr pm = PropertyMgr.getInstance();
            String xPath = XP_CLINICAL_DATA_TEMPLATE.replaceFirst("MESSAGE_TYPE", messageType);
            String templateName = pm.getProperty(xPath).getValue();
            if (templateName == null) {
                throw IMSException.getIMSException("Could not retrieve template name from configuration file using XPATH: " + xPath);
            }
            Document graph = (Document)resultAdapter.adapt(rawMsg, templateName);
            XMLDocumentMessageMetaData metaData = new XMLDocumentMessageMetaData(graph);
            dbData[5] = metaData.getMessageType();
            dbData[9] = metaData.getClinicallyRelevantDate();
        }
        catch (ResultAdapterException e) {
            throw IMSException.getIMSException(e);
        }
        return dbData;
    }

    public String[] parseMSH(String segLine) {
        String fieldDelimeter = HL7MessageInfoImpl.getFieldDelimeter((String)segLine);
        Vector<String> fields = new Vector<String>();
        segLine = HL7SegmentParser.fillLine(segLine, fieldDelimeter);
        StringTokenizer st = new StringTokenizer(segLine, fieldDelimeter);
        while (st.hasMoreTokens()) {
            fields.add(st.nextToken());
        }
        return fields.toArray(new String[fields.size()]);
    }

    public String[] getLocalPid(String segLine, String fieldDelimeter, String componentSeparator) {
        String[] localPid = new String[2];
        String[] pidArray = HL7SegmentParser.parseLine(segLine, (HL7MessageInfo)this.messageInfo);
        PidSegment pidSegment = PidSegmentFactory.createSegment(pidArray, (HL7MessageInfo)this.messageInfo);
        localPid[0] = pidSegment.getDomainId("PI");
        localPid[1] = pidSegment.getDomain("PI");
        return localPid;
    }
}

