/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7repository;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.hl7adapters.hl7repository.DedupResult;
import gov.fhie.transformer.hl7adapters.hl7repository.HL7RepositoryException;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.HL7Checksum;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import java.security.NoSuchAlgorithmException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class HL7RepositoryDedup {
    private static final String queryByCheckSumTemplate = "select message_control_id,message_date_time,checksum {0}from hl7_repository where clinical_id=? and facility_id=? and active=''Y''";
    private final String queryByCheckSum;
    protected String dbConnStr;

    public HL7RepositoryDedup(String domain) {
        this.dbConnStr = domain;
        this.queryByCheckSum = MessageFormat.format(queryByCheckSumTemplate, SqlUtil.getSchemaFor("hl7_plus", "."));
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DedupResult dedup(String msg, MessageMetaData dbdata, String fileName) throws HL7RepositoryException {
        String errorMessage;
        String clinicalId = dbdata.getClinicalId();
        if (clinicalId == null) {
            IMSException.getIMSException((CharSequence)"clinical Id is null.", null, ErrorCode.CLIN_011, new String[]{msg});
            return null;
        }
        Connection conn = null;
        Statement pstmt = null;
        ResultSet rs = null;
        try {
            String checkSum = HL7Checksum.toString(HL7Checksum.checkSumHL7(msg, dbdata));
            conn = DataSourceManager.getInstance().getDataSource(this.dbConnStr).getConnection();
            pstmt = conn.prepareStatement(this.queryByCheckSum);
            pstmt.setString(1, dbdata.getClinicalId());
            pstmt.setString(2, dbdata.getFacilityId());
            rs = pstmt.executeQuery();
            if (rs.next()) {
                String curCksum = rs.getString("checksum");
                if (curCksum.equals(checkSum)) {
                    DedupResult dedupResult = new DedupResult(null, null, checkSum);
                    return dedupResult;
                }
                String msgDateTime = rs.getString("message_date_time");
                if (dbdata.getMessageDateTime().compareTo(msgDateTime) < 0) {
                    DedupResult dedupResult = new DedupResult(clinicalId, "N", checkSum);
                    return dedupResult;
                }
                DedupResult dedupResult = new DedupResult(clinicalId, "Y", rs.getString("message_control_id"), dbdata.getFacilityId(), "N", checkSum);
                return dedupResult;
            }
            DedupResult curCksum = new DedupResult(dbdata.getClinicalId(), "Y", checkSum);
            return curCksum;
        }
        catch (NoSuchAlgorithmException nsae) {
            errorMessage = "An error occured while calculating checksum for message.";
            IMSException.getIMSException(nsae, (CharSequence)errorMessage, null, ErrorCode.UNCL_015, new String[]{nsae.getMessage()});
            throw new HL7RepositoryException(errorMessage, nsae);
        }
        catch (Exception e) {
            errorMessage = "An error occurred while querying database.";
            IMSException.getIMSException(e, (CharSequence)errorMessage, null, ErrorCode.JDBC_000, new String[]{e.getMessage()});
            throw new HL7RepositoryException(errorMessage, e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException sqle) {}
            }
            if (pstmt != null) {
                try {
                    pstmt.close();
                }
                catch (SQLException sqle) {}
            }
            if (conn != null) {
                try {
                    conn.close();
                }
                catch (SQLException sqle) {}
            }
        }
    }
}

