/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7messageprocessor;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.fhie.transformer.systemcontrol.SupportComponents;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class hl7statutil {
    private static final String queryStatsTemplate = "select file_name,process_begin_date,process_end_date,process_begin_time,process_end_time from {0}hl7_stats where process_begin_time is null";
    private final String queryStats = MessageFormat.format("select file_name,process_begin_date,process_end_date,process_begin_time,process_end_time from {0}hl7_stats where process_begin_time is null", SqlUtil.getSchemaFor("hl7_plus", "."));
    private Connection conn;
    protected String dbConnStr;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void populateBETime() throws Exception {
        block23: {
            Statement stmt;
            ResultSet uprs;
            block21: {
                uprs = null;
                stmt = null;
                this.dbConnStr = "fhie.gov/dod0";
                if (this.conn == null) {
                    this.conn = this.getConnection();
                }
                try {
                    stmt = this.conn.createStatement(1005, 1008);
                    uprs = stmt.executeQuery(this.queryStats);
                    while (uprs.next()) {
                        String fn = uprs.getString(1);
                        String processBeginDate = uprs.getString(2);
                        String processEndDate = uprs.getString(3);
                        long pBeginTime = DateTimeUtility.getMilliSecond(processBeginDate);
                        long pEndTime = DateTimeUtility.getMilliSecond(processEndDate);
                        uprs.updateLong(4, pBeginTime);
                        uprs.updateLong(5, pEndTime);
                        uprs.updateRow();
                        this.conn.commit();
                    }
                    this.conn.commit();
                    Object var11_9 = null;
                    if (uprs == null) break block21;
                }
                catch (Throwable throwable) {
                    Object var11_11 = null;
                    if (uprs != null) {
                        uprs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (null != this.conn) {
                        try {
                            this.conn.rollback();
                        }
                        catch (SQLException e) {
                            IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                        }
                        try {
                            this.conn.close();
                        }
                        catch (SQLException e) {
                            IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                        }
                    }
                    throw throwable;
                }
                uprs.close();
            }
            if (stmt != null) {
                stmt.close();
            }
            if (null != this.conn) {
                try {
                    this.conn.rollback();
                }
                catch (SQLException e) {
                    IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                }
                try {
                    this.conn.close();
                }
                catch (SQLException e) {
                    IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                }
            }
            break block23;
            {
                catch (SQLException sqle) {
                    IMSException.getIMSException(sqle, (CharSequence)sqle.getMessage(), null, ErrorCode.JDBC_017, null);
                    Object var11_10 = null;
                    if (uprs != null) {
                        uprs.close();
                    }
                    if (stmt != null) {
                        stmt.close();
                    }
                    if (null == this.conn) break block23;
                    try {
                        this.conn.rollback();
                    }
                    catch (SQLException e) {
                        IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                    }
                    try {
                        this.conn.close();
                    }
                    catch (SQLException e) {
                        IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
                    }
                }
            }
        }
    }

    public Connection getConnection() {
        while (null == this.conn) {
            try {
                this.conn = DataSourceManager.getInstance().getDataSource(this.dbConnStr).getConnection();
            }
            catch (SQLException e) {
                IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_023, new String[]{this.dbConnStr});
                if (null == this.conn) continue;
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    IMSException.getIMSException(ex, (CharSequence)ex.getMessage(), null, ErrorCode.JDBC_009, null);
                }
                this.conn = null;
            }
        }
        return this.conn;
    }

    public static void main(String[] args) {
        try {
            SupportComponents sc = new SupportComponents("fhie_properties.xml", "transformer", "tfmr_all_1");
            PropertyMgr pm = PropertyMgr.getInstance("app_node_key");
        }
        catch (Exception e) {
            System.out.println("Can not get System/SupportComponents ready!");
            return;
        }
        hl7statutil util = new hl7statutil();
        try {
            util.populateBETime();
        }
        catch (Exception e) {
            System.out.println("populateBeginTime failed." + e);
        }
        System.exit(0);
    }
}

