/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7messageprocessor;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.fhie.transformer.systemcontrol.SupportComponents;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.SqlUtil;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;

public class HL7FileStatistics {
    private static final String queryNextSeqTemplate = "select {0}stat_index_seq.nextval from dual";
    private final String queryNextSeq;
    private static final String insertStatsTemplate = "insert into {0}hl7_stats_detail (stat_index,date_time,text,file_name ) values (?,?,?,?)";
    private final String insertStats;
    private static final String updateStatsTemplate = "update {0}hl7_stats set process_end_date=?,process_end_time=? where file_name=?";
    private final String updateStats;
    private Connection conn;
    protected String dbConnStr;
    private String fileName = "";
    private long fileSize;
    private long lastModifiedTime;
    private String siteId;
    private int messageNumber = 0;
    private boolean isBadFile = false;
    private String scanFileCompleteTime;
    private String processBeginDate;
    private String badFileInfo;
    private String detailInfo = "";
    private String badChars = "";
    private PropertyMgr propertyManager = null;
    String interfaceName = "";

    public HL7FileStatistics(String domain, String interfaceName) {
        this.dbConnStr = domain;
        this.propertyManager = PropertyMgr.getInstance(domain);
        this.interfaceName = interfaceName;
        String schema = SqlUtil.getSchemaFor("hl7_plus", ".");
        this.queryNextSeq = MessageFormat.format(queryNextSeqTemplate, schema);
        this.insertStats = MessageFormat.format(insertStatsTemplate, schema);
        this.updateStats = MessageFormat.format(updateStatsTemplate, schema);
    }

    /*
     * Exception decompiling
     */
    public boolean scanFile(File f, int startChar, int endChar) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [3[TRYBLOCK]], but top level block is 28[FORLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void getFileInfo(File f) {
        this.fileName = f.getName();
        this.fileSize = f.length();
        this.lastModifiedTime = f.lastModified();
        this.siteId = this.getSiteId(this.fileName);
    }

    public String getSiteId(String fileName) {
        String siteId = null;
        try {
            int startIndex = fileName.indexOf("_") + 1;
            int endIndex = fileName.indexOf("_", startIndex);
            siteId = fileName.substring(startIndex, endIndex - 2);
        }
        catch (Exception e) {
            this.detailInfo = "Can't get siteId for the invalid FileName: " + fileName;
        }
        return siteId;
    }

    public Connection getConnection() {
        block5: {
            while (null == this.conn) {
            }
            try {
                this.conn = DataSourceManager.getInstance().getDataSource(this.dbConnStr).getConnection();
            }
            catch (SQLException e) {
                IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_007, null);
                if (this.conn == null) break block5;
                try {
                    this.conn.close();
                }
                catch (SQLException ex) {
                    IMSException.getIMSException(ex, (CharSequence)ex.getMessage(), null, ErrorCode.JDBC_009, null);
                }
                this.conn = null;
            }
        }
        return this.conn;
    }

    public void saveFileInfo(File f, String interfaceName) {
        this.fileName = f.getName();
        this.fileSize = f.length();
        this.lastModifiedTime = f.lastModified();
        this.siteId = this.getSiteId(this.fileName);
        String receiveDate = DateTimeUtility.getISOTime(this.lastModifiedTime);
        String insertStmt = "insert into hl7_stats (file_name,site_id,file_size,received_date,num_of_msgs,process_begin_date,bad_file,interface_name,process_begin_time) values (?,?,?,?,?,?,?,?,?)";
        this.conn = this.getConnection();
        try {
            PreparedStatement pstmt = this.conn.prepareStatement(insertStmt);
            pstmt.setString(1, this.fileName);
            pstmt.setString(2, this.siteId);
            pstmt.setLong(3, this.fileSize);
            pstmt.setString(4, receiveDate);
            pstmt.setInt(5, this.messageNumber);
            pstmt.setString(6, this.processBeginDate);
            if (this.isBadFile) {
                pstmt.setInt(7, 1);
            } else {
                pstmt.setInt(7, 0);
            }
            pstmt.setString(8, interfaceName);
            long lBeginTime = DateTimeUtility.getMilliSecond(this.processBeginDate);
            pstmt.setLong(9, lBeginTime);
            pstmt.execute();
            this.conn.commit();
            pstmt.close();
            String completeTime = "ScanFileCompleteTime is " + this.scanFileCompleteTime;
            this.insertDetail(completeTime, this.fileName);
            if (null != this.badFileInfo && 0 < this.badFileInfo.length()) {
                this.insertDetail(this.badFileInfo, this.fileName);
            }
            if (null != this.detailInfo && 0 < this.detailInfo.length()) {
                this.insertDetail(this.detailInfo, this.fileName);
                this.detailInfo = "";
            }
        }
        catch (SQLException sqle) {
            IMSException.getIMSException(sqle, (CharSequence)sqle.getMessage(), null, ErrorCode.JDBC_013, new String[]{this.fileName});
        }
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
            }
            this.conn = null;
        }
    }

    public void addEndProcessTime(String endTime) {
        long lEndTime = DateTimeUtility.getMilliSecond(endTime);
        this.conn = this.getConnection();
        try {
            PreparedStatement pstmt = this.conn.prepareStatement(this.updateStats);
            pstmt.setString(1, endTime);
            pstmt.setLong(2, lEndTime);
            pstmt.setString(3, this.fileName);
            pstmt.execute();
            this.conn.commit();
            pstmt.close();
        }
        catch (SQLException sqle) {
            IMSException.getIMSException(sqle, (CharSequence)sqle.getMessage(), null, ErrorCode.JDBC_015, null);
        }
        if (null != this.conn) {
            try {
                this.conn.close();
            }
            catch (SQLException e) {
                IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_009, null);
            }
            this.conn = null;
        }
    }

    public void insertDetail(String detailData, String fName) throws SQLException {
        long currentTime = System.currentTimeMillis();
        int index = 0;
        Statement statement = null;
        ResultSet resultSet = null;
        PreparedStatement pstmt = null;
        this.conn = this.getConnection();
        statement = this.conn.createStatement();
        resultSet = statement.executeQuery(this.queryNextSeq);
        if (resultSet.next()) {
            index = resultSet.getInt(1);
        }
        resultSet.close();
        statement.close();
        pstmt = this.conn.prepareStatement(this.insertStats);
        pstmt.setInt(1, index);
        pstmt.setLong(2, currentTime);
        pstmt.setString(3, detailData);
        pstmt.setString(4, fName);
        pstmt.executeUpdate();
        this.conn.commit();
        pstmt.close();
    }

    public static void main(String[] args) {
        try {
            SupportComponents sc = new SupportComponents("fhie_properties.xml", "transformer", "tfmr_all_1");
            PropertyMgr pm = PropertyMgr.getInstance("app_node_key");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Error! Can not get System/SupportComponents ready!");
        }
        File file = new File("C:/fhie/projects/rundir/badchar/MyBadCharRad.dat");
        if (file == null) {
            System.out.println("File is null");
            return;
        }
        HL7FileStatistics stat = new HL7FileStatistics("fhie.gov/dod0", "NORMAL");
        stat.scanFile(file, 11, 28);
        stat.saveFileInfo(file, "testInterface");
        String endTime = DateTimeUtility.getCurrentTime();
        stat.addEndProcessTime(endTime);
        System.out.println("Done!!!");
    }
}

