/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7messagebuilder;

import gov.fhie.transformer.hl7adapters.hl7message.HL7Segment;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentFactory;
import gov.va.med.hds.hdr.common.util.StringHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import java.util.StringTokenizer;

public final class HL7SegmentParser {
    public HL7Segment getSegment(String segName, String incoming, HL7MessageInfo messageInfo) {
        String[] fields = HL7SegmentParser.parseLine(incoming, messageInfo);
        HL7SegmentFactory factory = new HL7SegmentFactory();
        if (fields == null || fields.length == 0) {
            return null;
        }
        return factory.createSegment(segName, fields, messageInfo);
    }

    public static final String[] parseLine(String messageLine, HL7MessageInfo messageInfo) {
        long startTime = System.currentTimeMillis();
        return StringHelper.split((String)messageLine, (String)messageInfo.getFieldDelimeter());
    }

    public static final String fillLine(String segLine, String fieldDelimeter) {
        int idx = 0;
        String dfd = fieldDelimeter + fieldDelimeter;
        StringBuffer filledSegment = new StringBuffer();
        int fromIdx = 0;
        while ((idx = segLine.indexOf(dfd, fromIdx)) != -1) {
            filledSegment.append(segLine.substring(fromIdx, idx)).append(fieldDelimeter).append("NIL");
            fromIdx = idx + 1;
        }
        filledSegment.append(segLine.substring(fromIdx));
        if (segLine.endsWith(fieldDelimeter)) {
            filledSegment.append("NIL");
        }
        return filledSegment.toString();
    }

    public int getFieldCount(String segLine, String fieldDelimeter) {
        String input = HL7SegmentParser.fillLine(segLine, fieldDelimeter);
        StringTokenizer tk = new StringTokenizer(input, fieldDelimeter);
        return tk.countTokens();
    }
}

