/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7messagebuilder;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.hl7adapters.hl7message.HL7Segment;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentFactoryIF;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import java.lang.reflect.Constructor;

public class HL7SegmentFactory
implements HL7SegmentFactoryIF {
    private static final String XP_SEGMENT_TYPES = "transformer/hl7segmenttypes/*";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_CLASS = "class";
    static String msgCntrlId = "";
    static String patientId = "";

    public HL7Segment createSegment(String segmentName, String[] fieldStrings, HL7MessageInfo messageInfo) {
        HL7Segment segment = null;
        try {
            Class clazz = this.getSegmentClass(segmentName, messageInfo.getVersion());
            Constructor constructor = clazz.getConstructor(String.class, String[].class, HL7MessageInfo.class);
            segment = (HL7Segment)constructor.newInstance(segmentName, fieldStrings, messageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        return segment;
    }

    private Class getSegmentClass(String segmentName, String version) {
        Class<?> clazz = null;
        String key = version + segmentName;
        PropertyMgr pmgr = PropertyMgr.getInstance();
        PropertyElement[] propertyElements = pmgr.getProperties(XP_SEGMENT_TYPES);
        for (int i = 0; i < propertyElements.length; ++i) {
            String k = propertyElements[i].getAttribute(ATTR_KEY);
            if (k == null || !key.equalsIgnoreCase(k)) continue;
            try {
                clazz = Class.forName(propertyElements[i].getAttribute(ATTR_CLASS));
                break;
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
        }
        if (clazz == null) {
            clazz = this.getSegmentClass("", version);
        }
        return clazz;
    }
}

