/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.hl7adapters.hl7message;

import gov.fhie.transformer.commonadapters.message.Field;
import gov.fhie.transformer.commonadapters.message.Segment;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import javax.swing.tree.DefaultMutableTreeNode;

public abstract class HL7Segment
extends Segment {
    protected static final String HL7_22 = "2.2";
    protected static final String HL7_24 = "2.4";
    protected HL7MessageInfo messageInfo = null;

    public HL7Segment(HL7MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public abstract String toString();

    public abstract String[] getTypes();

    protected abstract void initSegment(String var1, String[] var2);

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public void setFieldTypes(String[] fieldTypes) {
        this.fieldTypes = fieldTypes;
    }

    public String getSegmentDesc() {
        return this.segmentDesc;
    }

    public void setSegmentDesc(String segmentDesc) {
        this.segmentDesc = segmentDesc;
    }

    public Field[] getSegmentFields() {
        return this.segmentFields;
    }

    public void setSegmentFields(Field[] segmentFields) {
        this.segmentFields = segmentFields;
    }

    public int getSegmentIndex() {
        return this.segmentIndex;
    }

    public void setSegmentIndex(int segmentIndex) {
        this.segmentIndex = segmentIndex;
    }

    public String getSegmentType() {
        return this.segmentType;
    }

    public void setSegmentType(String segmentType) {
        this.segmentType = segmentType;
    }

    public void printXML() {
        System.out.println("  <" + this.segmentType + ">");
        if (this.getIndex() % 10 == 0) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "ST SEGMENT IN THE MESSAGE -->");
        } else if (this.getIndex() % 10 == 1) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "ND SEGMENT IN THE MESSAGE -->");
        } else if (this.getIndex() % 10 == 2) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "RD SEGMENT IN THE MESSAGE -->");
        } else {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "TH SEGMENT IN THE MESSAGE -->");
        }
        if (this.segmentDesc != null && this.segmentDesc.length() > 0) {
            System.out.println("    <!-- " + this.segmentDesc + " -->");
        }
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            if (this.segmentFields[i].isSimpleField()) {
                System.out.print("    <" + this.segmentType + "." + (i + 1) + ">");
                this.segmentFields[i].printXML();
                System.out.println("</" + this.segmentType + "." + (i + 1) + ">");
                continue;
            }
            System.out.println("    <" + this.segmentType + "." + (i + 1) + ">");
            this.segmentFields[i].printXML();
            System.out.println("    </" + this.segmentType + "." + (i + 1) + ">");
        }
        System.out.println("  </" + this.segmentType + ">");
    }

    public void print() {
        System.out.println("  Segment " + (this.getIndex() + 1) + " Type: " + this.segmentType + " Name: " + this.segmentDesc);
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            if (this.segmentFields[i].isSimpleField()) {
                System.out.print("    " + this.segmentType + "." + (i + 1) + ":  =>");
                this.segmentFields[i].print();
                System.out.println("<=");
                continue;
            }
            System.out.println("    " + this.segmentType + "." + (i + 1) + ":");
            this.segmentFields[i].print();
        }
        System.out.println("  --End of Segment " + (this.getIndex() + 1) + " #");
    }

    public void display(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode segNode = new DefaultMutableTreeNode(this.segmentType + " [" + (this.getIndex() + 1) + "]  " + this.segmentDesc);
        parent.add(segNode);
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            DefaultMutableTreeNode fldNode = new DefaultMutableTreeNode(this.segmentType + "." + (i + 1));
            segNode.add(fldNode);
            if (this.segmentFields[i].isSimpleField()) {
                this.segmentFields[i].display(fldNode);
                continue;
            }
            this.segmentFields[i].display(fldNode);
        }
    }
}

