/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.commonadapters.resultsadapter;

import gov.fhie.transformer.commonadapters.resultsadapter.AttributeMap;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.IdentityRegistry;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapKey;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapKeyFactory;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MappingFileMapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MappingInfoMapKeyFactory;
import gov.va.med.hds.hdr.transformer.hl7.mapping.SegmentInfo;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.Vector;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MappingInfo
implements IdentityRegistry {
    public static final int TEMP_SUB_TYPE = 0;
    public static final int SEG_COL = 1;
    public static final int SEGMENT_COL = 2;
    public static final int FIELDNUM_COL = 3;
    public static final int NEXTFIELD_COL = 4;
    public static final int SKIPFLAG_COL = 5;
    public static final int APPENDFIELD_COL = 4;
    public static final int SEPARATEFIELD_COL = 5;
    public static final int FIELDNAME_COL = 6;
    public static final int SOURCETYPE_COL = 7;
    public static final int ATTRINUM_COL = 8;
    public static final int REGEX_COL = 9;
    public static final int ATTRIBUTE_COL = 10;
    public static final int DATATYPE_COL = 11;
    public static final int ATTRIBTYPE_COL = 12;
    public static final int COMPOVAL_COL = 13;
    public static final int ESCAPE_COL = 14;
    public static final int NEW_DOMAIN_COL = 15;
    public static final int NEW_INSTANCE_COL = 16;
    public static final int COMMENT_COL = 17;
    public final String MAP_COMMA = ",";
    public static final String MAP_DOT = ".";
    private static final String MAP_NAME_SEP = "_";
    private List<String> msgTemplateNames;
    private Map<Object, Map<Object, Map<Object, List<AttributeMap>>>> mpMap;
    private Map<String, List<String>> mpTemplateNames = null;
    private static Map<MapKey, List<MappingFileMapInfo>> registry = new Hashtable<MapKey, List<MappingFileMapInfo>>();
    private static final String FILE_EXTENSION = ".txt";
    private static final int SID_MESSAGE_TYPE = 0;
    private static final int SID_SEGMENT_TYPE = 1;
    private static final int SID_EXPRESSION = 2;
    private static final int SID_SEGMENT_NAME = 4;
    private static final int SID_GROUP_NAME = 5;
    private static final int SID_NEW_GROUP = 6;
    private static final int EGID_MESSAGE_TYPE = 0;
    private static final int EGID_SEGMENT_TYPE = 1;
    private static final int EGID_EXPRESSION = 2;
    private static final int EGID_PARENTGROUPNAME = 4;
    private static final MappingInfo INSTANCE = new MappingInfo();
    private Map<String, List<SegmentInfo>> segmentIdentifierMap;
    private Map<String, List<List<String>>> endGroupIdentifierMap = null;
    private MapKeyFactory mapKeyFactory = new MappingInfoMapKeyFactory();

    @Override
    public MapInfo[] getMapInfos(MapKey mappingKey) {
        List<MappingFileMapInfo> l = registry.get(mappingKey);
        return l != null ? l.toArray(new MapInfo[0]) : new MapInfo[]{};
    }

    @Override
    public SegmentInfo identifySegment(HL7MessageInfo messageInfo, String messageType, String segmentName, String segmentGroup, String segmentText) {
        String groupName = this.getGroupEndGroupName(messageInfo, messageType, segmentName, segmentText);
        boolean endGroup = groupName != null;
        segmentGroup = groupName != null ? groupName : segmentGroup;
        return this.getSegmentInfo(messageInfo, messageType, segmentName, segmentGroup, segmentText, endGroup);
    }

    @Override
    public MapKey identifyToken(String modelIdentifier, HL7MessageInfo messageInfo, String messageType, String segmentName, int fieldIndex, int componentIndex, int subcomponentIndex) {
        return this.mapKeyFactory.create(new Object[]{modelIdentifier, messageType, segmentName, new Integer(fieldIndex), new Integer(componentIndex), new Integer(subcomponentIndex)});
    }

    public static String getPosition(int componentIndex, int subcomponentIndex) {
        String position = null;
        position = componentIndex == 0 ? String.valueOf(0) : (subcomponentIndex == 0 ? String.valueOf(componentIndex) : componentIndex + MAP_DOT + subcomponentIndex);
        return position;
    }

    public static MappingInfo getInstance() {
        return INSTANCE;
    }

    private MappingInfo() {
        this.msgTemplateNames = new ArrayList<String>();
        this.mpMap = new HashMap<Object, Map<Object, Map<Object, List<AttributeMap>>>>();
        this.segmentIdentifierMap = new HashMap<String, List<SegmentInfo>>();
        this.endGroupIdentifierMap = new HashMap<String, List<List<String>>>();
        this.mpTemplateNames = new HashMap<String, List<String>>();
        Resource[] resources = null;
        PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
        try {
            for (Resource resource : resources = resolver.getResources("classpath*:gov/va/med/hds/hdr/config/*.txt")) {
                this.loadMappingFile(resource);
            }
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Invalid resource path.", e);
        }
    }

    private int loadMappingFile(Resource mapFileResource) {
        int nSuccess = 0;
        List<String[]> parsedMessageList = null;
        StringBuffer szTemplateName = new StringBuffer();
        if (mapFileResource.exists()) {
            parsedMessageList = this.parseMappingData(mapFileResource, szTemplateName);
        }
        HashMap msgTypes = new HashMap();
        ArrayList<String> msgTypeNameList = new ArrayList<String>();
        if (parsedMessageList != null && parsedMessageList.size() != 0) {
            int nMapFileLines = parsedMessageList.size();
            ArrayList<String[]> lMessageTypeLines = new ArrayList<String[]>();
            int i = 0;
            String[] nextline = parsedMessageList.get(i);
            String msgTypeName = nextline[0];
            String currMsgType = msgTypeName.toString();
            lMessageTypeLines.add(nextline);
            ++i;
            while (i < nMapFileLines) {
                nextline = parsedMessageList.get(i);
                msgTypeName = nextline[0];
                if (msgTypeName.toString().equals(currMsgType)) {
                    lMessageTypeLines.add(nextline);
                } else {
                    msgTypes.put(currMsgType, lMessageTypeLines);
                    msgTypeNameList.add(currMsgType);
                    lMessageTypeLines = new ArrayList();
                    lMessageTypeLines.add(nextline);
                    currMsgType = msgTypeName.toString();
                }
                ++i;
            }
            if (lMessageTypeLines.size() > 0) {
                msgTypes.put(currMsgType, lMessageTypeLines);
                msgTypeNameList.add(currMsgType);
            }
        }
        Set set = msgTypes.entrySet();
        for (Map.Entry mapent : set) {
            List msgTypeList = (List)mapent.getValue();
            int nListLength = msgTypeList == null ? 0 : msgTypeList.size();
            String szMsgType = (String)mapent.getKey();
            String mapping_name = szTemplateName + MAP_NAME_SEP + szMsgType;
            if (!this.buildMessageMap(mapping_name, parsedMessageList)) continue;
            ++nSuccess;
            this.msgTemplateNames.add(mapping_name);
        }
        this.mpTemplateNames.put(szTemplateName.toString(), msgTypeNameList);
        return nSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String[]> parseMappingData(Resource mapFileResource, StringBuffer template) {
        Vector<String[]> parsedMappings = new Vector<String[]>();
        List<SegmentInfo> parsedSegmentIdentifiers = null;
        List<List<String>> parsedEndGroupIndentifiers = null;
        BufferedReader br = null;
        try {
            br = new BufferedReader(new InputStreamReader(mapFileResource.getInputStream()));
            String fileLine = null;
            StringTokenizer strTok = null;
            Vector<String> vFields = null;
            while ((fileLine = br.readLine()) != null) {
                if (fileLine.startsWith("#")) continue;
                if (fileLine.indexOf(",") == -1) {
                    template.append(fileLine);
                    continue;
                }
                strTok = new StringTokenizer(fileLine, ",");
                vFields = new Vector<String>();
                while (strTok.hasMoreTokens()) {
                    vFields.add(strTok.nextToken());
                }
                if (fileLine.indexOf("Segment Identifier") != -1) {
                    SegmentInfo segmentInfo = new SegmentInfo((String)vFields.get(0), (String)vFields.get(1), (String)vFields.get(4), (String)vFields.get(2), (String)vFields.get(5), "1".equals((String)vFields.get(6)));
                    String key = segmentInfo.getMessageType() + MAP_NAME_SEP + segmentInfo.getSegmentType();
                    parsedSegmentIdentifiers = this.segmentIdentifierMap.get(key);
                    if (parsedSegmentIdentifiers == null) {
                        parsedSegmentIdentifiers = new Vector<SegmentInfo>();
                        this.segmentIdentifierMap.put(key, parsedSegmentIdentifiers);
                    }
                    parsedSegmentIdentifiers.add(segmentInfo);
                    continue;
                }
                if (fileLine.indexOf("End Group") != -1) {
                    String key = (String)vFields.get(0) + MAP_NAME_SEP + (String)vFields.get(1);
                    parsedEndGroupIndentifiers = this.endGroupIdentifierMap.get(key);
                    if (parsedEndGroupIndentifiers == null) {
                        parsedEndGroupIndentifiers = new Vector<List<String>>();
                        this.endGroupIdentifierMap.put(key, parsedEndGroupIndentifiers);
                    }
                    parsedEndGroupIndentifiers.add(vFields);
                    continue;
                }
                parsedMappings.add(vFields.toArray(new String[vFields.size()]));
            }
        }
        catch (Exception e) {
            IMSException.getIMSException("An error occurred while parsing the mapping file.", e);
        }
        finally {
            if (br != null) {
                try {
                    br.close();
                }
                catch (IOException ioe) {}
            }
        }
        return parsedMappings;
    }

    private boolean buildMessageMap(Object msgType, List<String[]> parsedMsgList) {
        boolean bSuccess = true;
        ArrayList<Object> segmentNmList = new ArrayList<Object>();
        HashMap<String, Map<Object, List<AttributeMap>>> mpSegMap = new HashMap<String, Map<Object, List<AttributeMap>>>();
        if (!this.mpMap.containsKey(msgType)) {
            int rowCount = parsedMsgList.size();
            int i = 0;
            ArrayList<Object> fieldList = new ArrayList<String[]>();
            String[] nextline = parsedMsgList.get(i);
            Object segmentName = nextline[2];
            segmentNmList.add(segmentName);
            fieldList.add(parsedMsgList.get(0));
            ++i;
            while (i < rowCount) {
                Object nextSegmentName = ((Object[])parsedMsgList.get(i))[2];
                if (nextSegmentName.equals(segmentName)) {
                    fieldList.add(parsedMsgList.get(i));
                } else {
                    mpSegMap.put((String)segmentName, this.buildSegmentMap(msgType, segmentName, fieldList));
                    segmentName = nextSegmentName;
                    segmentNmList.add(segmentName);
                    fieldList = new ArrayList();
                    fieldList.add(parsedMsgList.get(i));
                }
                ++i;
            }
            mpSegMap.put((String)segmentName, this.buildSegmentMap(msgType, segmentName, fieldList));
            if (segmentNmList.size() == 0) {
                bSuccess = false;
            }
        }
        this.mpMap.put(msgType, mpSegMap);
        return bSuccess;
    }

    private Map<Object, List<AttributeMap>> buildSegmentMap(Object msgType, Object segName, List<String[]> fieldList) {
        HashMap mpFieldNum = new HashMap();
        HashMap<Object, List<AttributeMap>> mpFldMap = new HashMap<Object, List<AttributeMap>>();
        int rowCount = fieldList.size();
        int i = 0;
        ArrayList<Object> fieldNumList = new ArrayList<Object>();
        ArrayList<Object> attribList = new ArrayList<String[]>();
        Object fieldNum = ((Object[])fieldList.get(i))[3];
        fieldNumList.add(fieldNum);
        attribList.add(fieldList.get(0));
        ++i;
        while (i < rowCount) {
            Object nextFieldNum = ((Object[])fieldList.get(i))[3];
            if (nextFieldNum.equals(fieldNum)) {
                attribList.add(fieldList.get(i));
            } else {
                mpFldMap.put(fieldNum, this.buildFieldMap(msgType, segName, fieldNum, attribList));
                fieldNum = nextFieldNum;
                fieldNumList.add(fieldNum);
                attribList = new ArrayList();
                attribList.add(fieldList.get(i));
            }
            ++i;
        }
        mpFldMap.put(fieldNum, this.buildFieldMap(msgType, segName, fieldNum, attribList));
        return mpFldMap;
    }

    private List<AttributeMap> buildFieldMap(Object msgType, Object segName, Object fldNum, List<String[]> attribLineList) {
        int rowCount = attribLineList.size();
        int i = 0;
        ArrayList<String[]> attribList = new ArrayList<String[]>();
        ArrayList<Object> attribNumList = new ArrayList<Object>();
        AttributeMap attributeObject = null;
        ArrayList<AttributeMap> attribObjectList = new ArrayList<AttributeMap>();
        Object attribNum = ((Object[])attribLineList.get(i))[10];
        attribNumList.add(attribNum);
        attribList.add(attribLineList.get(0));
        ++i;
        while (i < rowCount) {
            Object tempAttribNum = ((Object[])attribLineList.get(i))[10];
            if (tempAttribNum.equals(attribNum)) {
                attribList.add(attribLineList.get(i));
                ++i;
                continue;
            }
            attributeObject = new AttributeMap();
            attributeObject.setAttribList(attribList);
            attributeObject.setAttribNm(attribNum);
            attribObjectList.add(attributeObject);
            attribNum = tempAttribNum;
            attribList = new ArrayList();
            attribList.add(attribLineList.get(i));
            attribNumList.add(tempAttribNum);
            this.buildRegistryEntry((String)msgType, (String)segName, (String)fldNum, attributeObject);
            ++i;
        }
        attributeObject = new AttributeMap();
        attributeObject.setAttribList(attribList);
        attributeObject.setAttribNm(attribNum);
        attribObjectList.add(attributeObject);
        this.buildRegistryEntry((String)msgType, (String)segName, (String)fldNum, attributeObject);
        return attribObjectList;
    }

    private void buildRegistryEntry(String messageType, String segmentName, String fieldIdx, AttributeMap attrMap) {
        for (int i = 0; i < attrMap.mapSize; ++i) {
            String idx = attrMap.getAttributeLine(i)[8];
            if (idx.indexOf(46) == -1) {
                idx = idx + ".0";
            }
            String position = fieldIdx + MAP_DOT + idx;
            MapKey key = new MapKey();
            key.setId(messageType + MAP_NAME_SEP + segmentName + MAP_NAME_SEP + position);
            List<MappingFileMapInfo> mapInfos = registry.get(key);
            if (mapInfos == null) {
                mapInfos = new ArrayList<MappingFileMapInfo>();
                registry.put(key, mapInfos);
            }
            mapInfos.add(new MappingFileMapInfo(attrMap.getAttributeLine(i)));
        }
    }

    public SegmentInfo getSegmentInfo(HL7MessageInfo messageInfo, String messageType, String segmentType, String groupName, String segmentText, boolean endGroup) {
        SegmentInfo segmentInfo = null;
        String key = messageType + MAP_NAME_SEP + segmentType;
        List<SegmentInfo> sids = this.segmentIdentifierMap.get(key);
        if (sids != null) {
            for (SegmentInfo si : sids) {
                si.setEndGroup(endGroup);
                String expression = RegularExpressionHelper.genericToMessageSpecific(messageInfo, si.getIdentifyingExpression());
                if (segmentText == null || !segmentText.matches(expression) || !groupName.equals(si.getGroupName())) continue;
                segmentInfo = (SegmentInfo)si.clone();
                break;
            }
        }
        return segmentInfo;
    }

    public String getGroupEndGroupName(HL7MessageInfo messageInfo, String messageType, String segmentType, String segmentText) {
        String parentGroup = null;
        String key = messageType + MAP_NAME_SEP + segmentType;
        List<List<String>> egids = this.endGroupIdentifierMap.get(key);
        if (egids != null) {
            Iterator<List<String>> iter = egids.iterator();
            Vector fields = null;
            while (iter.hasNext()) {
                fields = (Vector)iter.next();
                String expression = RegularExpressionHelper.genericToMessageSpecific(messageInfo, (String)fields.get(2));
                if (segmentText == null || !segmentText.matches(expression)) continue;
                parentGroup = (String)fields.get(4);
            }
        }
        return parentGroup;
    }

    public String[] getTemplates(String msgType) {
        String[] ss = new String[this.mpTemplateNames.size()];
        Set<Map.Entry<String, List<String>>> set = this.mpTemplateNames.entrySet();
        Iterator<Map.Entry<String, List<String>>> iter = set.iterator();
        int i = 0;
        boolean bGotIt = true;
        while (iter.hasNext()) {
            Map.Entry<String, List<String>> mapent = iter.next();
            String tempName = mapent.getKey().toString();
            if (msgType != null) {
                bGotIt = false;
                String[] aTypes = this.getSendingAppNames(tempName);
                if (aTypes != null) {
                    for (int j = 0; j < aTypes.length; ++j) {
                        if (!aTypes[j].equalsIgnoreCase(msgType)) continue;
                        bGotIt = true;
                        break;
                    }
                }
            }
            if (!bGotIt) continue;
            ss[i++] = tempName;
        }
        if (i > 0 && i != this.mpTemplateNames.size()) {
            String[] sss = new String[i];
            for (int k = 0; k < i; ++k) {
                sss[k] = ss[k];
            }
            return sss;
        }
        if (i == this.mpTemplateNames.size()) {
            return ss;
        }
        return null;
    }

    public String[] getFTemplateNames(String mapType) {
        Object[] os = this.msgTemplateNames.toArray();
        String[] ss = new String[os.length];
        if (mapType == null) {
            for (int i = 0; i < os.length; ++i) {
                ss[i] = os[i].toString();
            }
            return ss;
        }
        int idx = 0;
        for (int i = 0; i < os.length; ++i) {
            String tempName = os[i].toString().substring(os[i].toString().length() - mapType.length());
            if (!tempName.equalsIgnoreCase(mapType)) continue;
            ss[idx++] = os[i].toString();
        }
        if (idx == 0) {
            return null;
        }
        String[] sss = new String[idx];
        for (int i = 0; i < idx; ++i) {
            sss[i] = ss[i];
        }
        return sss;
    }

    public String[] getSendingAppNames(String templateName) {
        if (templateName == null) {
            return null;
        }
        ArrayList l = (ArrayList)this.mpTemplateNames.get(templateName);
        if (l == null) {
            return null;
        }
        String[] s = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            s[i] = (String)l.get(i);
        }
        return s;
    }

    public String[] getSendingAppNames(String[] templateNames) {
        if (templateNames == null || templateNames.length == 0) {
            return null;
        }
        List<String> l = this.mpTemplateNames.get(templateNames[0]);
        if (templateNames.length > 1) {
            for (int i = 1; i < templateNames.length; ++i) {
                l.addAll((Collection<String>)this.mpTemplateNames.get(templateNames[i]));
            }
        }
        if (l == null) {
            return null;
        }
        String[] s = new String[l.size()];
        for (int i = 0; i < l.size(); ++i) {
            s[i] = l.get(i);
        }
        return s;
    }

    public String getTemplateName(String msgType) {
        return this.getTemplateName(null, msgType);
    }

    public String getTemplateName(String tempName, String msgType) {
        if (tempName == null) {
            String[] tempList = this.getTemplates(msgType);
            if (tempList != null && tempList.length == 1) {
                return tempList[0];
            }
            return null;
        }
        return tempName + MAP_NAME_SEP + msgType;
    }

    public List getMappedFieldsForSegment(String msgType, String segmentNm) {
        List<String> a = null;
        a = this.getMappedFieldsForSegment((Object)msgType, (Object)segmentNm);
        return a;
    }

    public List<String> getMappedFieldsForSegment(Object msgType, Object segmentNm) {
        Map<Object, Map<Object, List<AttributeMap>>> mpSeg;
        String[] tempList;
        List<String> fieldList = null;
        Object msgName = msgType;
        if (msgType.toString().length() < 6 && (tempList = this.getFTemplateNames(msgType.toString())).length == 1) {
            msgName = tempList[0];
        }
        if (this.mpMap.containsKey(msgName) && (mpSeg = this.mpMap.get(msgName)).containsKey(segmentNm)) {
            Map<Object, List<AttributeMap>> mpFld = mpSeg.get(segmentNm);
            fieldList = this.getMapKeys(mpFld);
        }
        return fieldList;
    }

    public List getMappedFieldsForSegment(String tempType, String msgType, String segmentNm) {
        List<String> a = null;
        a = this.getMappedFieldsForSegment((Object)(tempType + MAP_NAME_SEP + msgType), (Object)segmentNm);
        return a;
    }

    public List getSegmentsForMsgType(String msgType) {
        List a = null;
        a = this.getSegmentsForMsgType((Object)msgType);
        return a;
    }

    public List getSegmentsForMsgType(Object msgType) {
        String[] tempList;
        List<String> segmentNmList = null;
        Object msgName = msgType;
        if (msgType.toString().length() < 6 && (tempList = this.getFTemplateNames(msgType.toString())) != null && tempList.length == 1) {
            msgName = tempList[0];
        }
        if (this.mpMap.containsKey(msgName)) {
            segmentNmList = this.getMappedSegments(msgName.toString());
        }
        return segmentNmList;
    }

    public List getSegmentsForMsgType(String tempName, String msgType) {
        List a = null;
        a = this.getSegmentsForMsgType((Object)(tempName + MAP_NAME_SEP + msgType));
        return a;
    }

    public List getFieldMap(String msgType, String segmentNm, int fieldNum) {
        List a = null;
        a = this.getFieldMap((Object)msgType, (Object)segmentNm, new Integer(fieldNum));
        return a;
    }

    public List getFieldMap(Object msgType, Object segmentNm, Object fieldNum) {
        Map<Object, List<AttributeMap>> mpFieldNm;
        Map<Object, Map<Object, List<AttributeMap>>> mpSegmntNm;
        String[] tempList;
        List<AttributeMap> attribObjectList = null;
        Object msgName = msgType;
        if (msgType.toString().length() < 6 && (tempList = this.getFTemplateNames(msgType.toString())) != null && tempList.length == 1) {
            msgName = tempList[0];
        }
        if (this.mpMap.containsKey(msgName) && (mpSegmntNm = this.mpMap.get(msgName)).containsKey(segmentNm) && (mpFieldNm = mpSegmntNm.get(segmentNm)).containsKey(fieldNum)) {
            attribObjectList = mpFieldNm.get(fieldNum);
        }
        return attribObjectList;
    }

    public List getFieldMap(String tempName, String msgType, String segmentNm, String fieldNum) {
        List a = null;
        a = this.getFieldMap((Object)(tempName + MAP_NAME_SEP + msgType), (Object)segmentNm, fieldNum);
        return a;
    }

    public List<String> getMappedSegments(Object msgType) {
        String[] tempList;
        List<String> segList = null;
        Object msgName = msgType;
        if (msgType.toString().length() < 6 && (tempList = this.getFTemplateNames(msgType.toString())) != null && tempList.length == 1) {
            msgName = tempList[0];
        }
        if (this.mpMap.containsKey(msgName)) {
            Map<Object, Map<Object, List<AttributeMap>>> mpSegs = this.mpMap.get(msgName);
            segList = this.getMapKeys(mpSegs);
        }
        return segList;
    }

    public List getMappedSegments(Object tempName, Object msgType) {
        List<String> a = null;
        a = this.getMappedSegments(tempName.toString() + MAP_NAME_SEP + msgType.toString());
        return a;
    }

    public List getMappedFields(String msgType, String segmentNm) {
        String[] tempList;
        List<String> fieldList = null;
        List<String> segList = null;
        Object a = null;
        segList = msgType.length() < 6 ? ((tempList = this.getFTemplateNames(msgType)).length == 1 ? this.getMappedSegments(tempList[0]) : null) : this.getMappedSegments(msgType);
        if (segList != null) {
            Map<Object, Map<Object, List<AttributeMap>>> segMap = this.mpMap.get(msgType);
            Map<Object, List<AttributeMap>> fldMap = segMap.get(segmentNm);
            fieldList = this.getMapKeys(fldMap);
        }
        return fieldList;
    }

    public List getMappedFields(String tempName, String msgType, String segmentNm) {
        List a = null;
        a = this.getMappedFields(tempName + MAP_NAME_SEP + msgType, segmentNm);
        return a;
    }

    private List<String> getMapKeys(Map<Object, ? extends Object> mMap) {
        boolean nSort = false;
        if (mMap == null) {
            return null;
        }
        Object[] array = null;
        ArrayList<String> lList = null;
        if (nSort) {
            TreeMap<Object, ? extends Object> tMap = new TreeMap<Object, Object>(mMap);
            array = tMap.keySet().toArray();
        } else {
            array = mMap.keySet().toArray();
        }
        int x = -1;
        try {
            Integer y = new Integer((String)array[0]);
            x = y;
        }
        catch (Exception e) {
            // empty catch block
        }
        lList = new ArrayList<String>();
        if (x >= 0) {
            int i;
            TreeSet<Integer> tSet = new TreeSet<Integer>();
            for (i = 0; i < array.length; ++i) {
                tSet.add(new Integer((String)array[i]));
            }
            array = tSet.toArray();
            for (i = 0; i < array.length; ++i) {
                String keyName = array[i].toString();
                lList.add(keyName);
            }
        } else {
            for (int i = 0; i < array.length; ++i) {
                String keyName = (String)array[i];
                lList.add(keyName);
            }
        }
        return lList;
    }
}

