/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.commonadapters.repositorywrapper;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;

public class RepositoryWrapper {
    protected Connection conn;
    protected PreparedStatement pstmt;
    protected ResultSet rs;
    protected Statement stmt;
    protected String dbConnStr;
    protected String domain;

    public RepositoryWrapper(String domain) {
        this.domain = domain;
        this.dbConnStr = domain;
    }

    public void getConnection() {
        while (null == this.conn) {
            try {
                this.conn = DataSourceManager.getInstance().getDataSource(this.dbConnStr).getConnection();
            }
            catch (SQLException e) {
                IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_023, new String[]{this.dbConnStr});
            }
        }
    }

    public void done() {
        try {
            if (this.rs != null) {
                this.rs.close();
            }
            if (this.stmt != null) {
                this.stmt.close();
            }
            if (this.pstmt != null) {
                this.pstmt.close();
            }
        }
        catch (SQLException e) {
            // empty catch block
        }
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException e) {
            IMSException.getIMSException(e, (CharSequence)e.getMessage(), null, ErrorCode.JDBC_005, null);
        }
        this.conn = null;
    }
}

