/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.commonadapters.message;

import gov.fhie.transformer.commonadapters.message.FieldComponent;
import gov.fhie.transformer.commonadapters.message.FormattedField;
import java.text.ParseException;
import java.text.SimpleDateFormat;

public class TSField
extends FormattedField {
    public TSField() {
        this.setType("TS");
        this.values = new FieldComponent[2];
    }

    public TSField(FieldComponent[] fields) {
        this();
        this.setComponents(fields);
    }

    public String toCOASFormat() {
        FieldComponent comp1 = this.values[0];
        FieldComponent comp2 = this.values[1];
        if (comp1 == null) {
            return null;
        }
        String dt = this.convertToCOASFormat(comp1);
        if (comp2 == null) {
            return dt;
        }
        return dt + this.getDelimiter() + comp2.toString();
    }

    public FieldComponent[] toCOASComponents() {
        FieldComponent[] coasComp = new FieldComponent[2];
        FieldComponent comp0 = this.values[0];
        FieldComponent comp1 = this.values[1];
        if (comp1 != null) {
            coasComp[0] = new FieldComponent(this.convertToCOASFormat(comp0));
            coasComp[1] = comp1;
        }
        return coasComp;
    }

    public String convertToCOASFormat(FieldComponent tsComp) {
        String timestamp = tsComp.toString();
        int dateLen = -1;
        boolean hasTZ = false;
        dateLen = timestamp.indexOf("-");
        hasTZ = -1 != dateLen || -1 != (dateLen = timestamp.indexOf("+"));
        if (!hasTZ) {
            dateLen = timestamp.length();
        }
        String dateFormat = "yyyyMMddHHmmss.SSS".substring(0, dateLen) + (hasTZ ? "Z" : "");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss:SSZ");
        try {
            return df.format(new SimpleDateFormat(dateFormat).parse(timestamp));
        }
        catch (ParseException e) {
            return "";
        }
    }

    public String getTime() {
        return this.values[0].toString();
    }

    public String getPrecDegree() {
        FieldComponent comp = this.values[1];
        if (comp != null) {
            return comp.toString();
        }
        return null;
    }
}

