/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.transformer.commonadapters.message;

import gov.fhie.transformer.commonadapters.message.Field;
import javax.swing.tree.DefaultMutableTreeNode;

public class Segment {
    protected String segmentType;
    protected String segmentDesc;
    protected int segmentIndex;
    protected Field[] segmentFields;
    protected String[] fieldTypes;

    public String getType() {
        return this.segmentType;
    }

    public void setType(String type) {
        this.segmentType = type;
    }

    public String getDesc() {
        return this.segmentDesc;
    }

    public void setDesc(String desc) {
        this.segmentDesc = desc;
    }

    public void setFieldTypes(String[] types) {
        this.fieldTypes = types;
    }

    public String[] getFieldTypes() {
        return this.fieldTypes;
    }

    public void setIndex(int segIndex) {
        this.segmentIndex = segIndex;
    }

    public int getIndex() {
        return this.segmentIndex;
    }

    public Field getField(int position) {
        return this.segmentFields[position - 1];
    }

    public int getFieldCount() {
        if (this.segmentFields == null) {
            return -1;
        }
        return this.segmentFields.length;
    }

    public void setFields(Field[] fields) {
        this.segmentFields = fields;
    }

    public Field[] getAllFields() {
        return this.segmentFields;
    }

    public void printXML() {
        System.out.println("  <" + this.segmentType + ">");
        if (this.getIndex() % 10 == 0) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "ST SEGMENT IN THE MESSAGE -->");
        } else if (this.getIndex() % 10 == 1) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "ND SEGMENT IN THE MESSAGE -->");
        } else if (this.getIndex() % 10 == 2) {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "RD SEGMENT IN THE MESSAGE -->");
        } else {
            System.out.println("    <!-- THIS IS THE " + (this.getIndex() + 1) + "TH SEGMENT IN THE MESSAGE -->");
        }
        if (this.segmentDesc != null && this.segmentDesc.length() > 0) {
            System.out.println("    <!-- " + this.segmentDesc + " -->");
        }
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            if (this.segmentFields[i].isSimpleField()) {
                if (this.segmentFields[i].getDesc() != null) {
                    System.out.print("    <" + this.segmentType + "." + (i + 1) + " desc=\"" + this.segmentFields[i].getDesc() + "\" type=\"" + this.segmentFields[i].getType() + "\">");
                } else {
                    System.out.print("    <" + this.segmentType + "." + (i + 1) + ">");
                }
                this.segmentFields[i].printXML();
                System.out.println("</" + this.segmentType + "." + (i + 1) + ">");
                continue;
            }
            if (this.segmentFields[i].getDesc() != null) {
                System.out.println("    <" + this.segmentType + "." + (i + 1) + " desc=\"" + this.segmentFields[i].getDesc() + "\">");
            } else {
                System.out.println("    <" + this.segmentType + "." + (i + 1) + ">");
            }
            this.segmentFields[i].printXML();
            System.out.println("    </" + this.segmentType + "." + (i + 1) + ">");
        }
        System.out.println("  </" + this.segmentType + ">");
    }

    public String toString() {
        StringBuffer sBuf = new StringBuffer("SegmentType = ").append(this.segmentType).append("\n").append("SegmentDesc = ").append(this.segmentDesc).append("\nFields:");
        for (int i = 0; i < this.segmentFields.length; ++i) {
            sBuf = sBuf.append("\n\t").append(this.segmentFields[i].toString());
        }
        return sBuf.toString();
    }

    public void print() {
        System.out.println("  Segment " + (this.getIndex() + 1) + " Type: " + this.segmentType + " Name: " + this.segmentDesc);
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            if (this.segmentFields[i].isSimpleField()) {
                System.out.print("    " + this.segmentType + "." + (i + 1) + ":  =>");
                this.segmentFields[i].print();
                System.out.println("<=");
                continue;
            }
            System.out.println("    " + this.segmentType + "." + (i + 1) + ":");
            this.segmentFields[i].print();
        }
        System.out.println("  --End of Segment " + (this.getIndex() + 1) + " #");
    }

    public void display(DefaultMutableTreeNode parent) {
        DefaultMutableTreeNode segNode = new DefaultMutableTreeNode(this.segmentType + " [" + (this.getIndex() + 1) + "]  " + this.segmentDesc);
        parent.add(segNode);
        for (int i = 0; i < this.segmentFields.length; ++i) {
            if (this.segmentFields[i] == null) continue;
            DefaultMutableTreeNode fldNode = new DefaultMutableTreeNode(this.segmentType + "." + (i + 1));
            segNode.add(fldNode);
            if (this.segmentFields[i].isSimpleField()) {
                this.segmentFields[i].display(fldNode);
                continue;
            }
            this.segmentFields[i].display(fldNode);
        }
    }
}

