/*
 * Decompiled with CFR 0.152.
 */
package gov.fhie.common.util;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;

public class ResourceManager {
    public static final int EOF = -1;
    public static final String userDir = System.getProperty("user.dir");
    public static final String classPath = System.getProperty("java.class.path");
    public static final String pathSeparator = System.getProperty("path.separator");
    public static final String fileSeparator = System.getProperty("file.separator");

    public static URL findFileURL(String fileName) throws MalformedURLException {
        File f;
        URL fileURL = ClassLoader.getSystemResource(fileName);
        if (fileURL == null && (f = new File(new StringBuffer(userDir).append(fileSeparator).append(fileName).toString())).exists()) {
            fileURL = f.toURL();
        }
        return fileURL;
    }

    public static String getAbsolutePath(String fileName) throws MalformedURLException {
        String path = "";
        URL u = ResourceManager.findFileURL(fileName);
        if (u != null) {
            path = new File(u.getFile()).getAbsolutePath();
        }
        return path;
    }

    public static InputStream loadFile(String fileName) {
        try {
            URL fileURL = ResourceManager.findFileURL(fileName);
            InputStream inputStream = fileURL.openStream();
            return inputStream;
        }
        catch (FileNotFoundException ex) {
            return null;
        }
        catch (IOException ex) {
            return null;
        }
    }

    public static void loadFile(String fileName, Writer theWriter) {
        try {
            InputStream inputStream = ResourceManager.loadFile(fileName);
            int numOfBytes = inputStream.available();
            int theByte = inputStream.read();
            while (theByte != -1) {
                theWriter.write(theByte);
                theByte = inputStream.read();
            }
            inputStream.close();
        }
        catch (FileNotFoundException ex) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String loadFileIntoString(String filename) throws FileNotFoundException, IOException, MalformedURLException {
        URL u = ResourceManager.findFileURL(filename);
        return ResourceManager.loadFileIntoString(u);
    }

    public static String loadFileIntoString(URL fileURL) throws FileNotFoundException, IOException {
        if (fileURL == null) {
            throw new FileNotFoundException("Null URL");
        }
        InputStream inputStream = fileURL.openStream();
        int numOfBytes = inputStream.available();
        byte[] buffer = new byte[numOfBytes];
        int theByte = inputStream.read(buffer);
        inputStream.close();
        String str = new String(buffer);
        return str;
    }
}

